/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.util;

public class TableNameUtil {
    private static final char SINGLE_QUOTE = '\'';
    private static final char[] FORBIDDEN_CHARS = "[]*?:/\\".toCharArray();

    public void checkTableName(CharSequence name) {
        if (name.charAt(0) == '\'') {
            throw new IllegalArgumentException("Table name should not start with ': " + name);
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            for (char fc : FORBIDDEN_CHARS) {
                if (c != fc) continue;
                throw new IllegalArgumentException("Table name should not contain " + new String(FORBIDDEN_CHARS) + ": " + name);
            }
        }
    }

    public String escapeTableName(CharSequence tableName) {
        boolean toQuote = false;
        int apostropheCount = 0;
        for (int i = 0; i < tableName.length(); ++i) {
            char c = tableName.charAt(i);
            if (Character.isWhitespace(c) || c == '.') {
                toQuote = true;
                continue;
            }
            if (c != '\'') continue;
            toQuote = true;
            ++apostropheCount;
        }
        StringBuilder sb = new StringBuilder(tableName.length() + (toQuote ? 2 : 0) + apostropheCount);
        if (toQuote) {
            sb.append('\'');
        }
        for (int i = 0; i < tableName.length(); ++i) {
            char c = tableName.charAt(i);
            sb.append(c);
            if (c != '\'') continue;
            sb.append('\'');
        }
        if (toQuote) {
            sb.append('\'');
        }
        return sb.toString();
    }
}

