/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.util;

import com.github.jferard.fastods.util.EqualityUtil;
import com.github.jferard.fastods.util.Position;
import com.github.jferard.fastods.util.TableNameUtil;
import java.text.ParseException;
import java.util.Locale;

class PositionParser {
    public static final int SINGLE_QUOTE = 39;
    private static final int HASH = 35;
    private static final int BEGIN_ROW = 3;
    private static final int BEGIN_COL = 0;
    private static final int FIRST_DIGIT = 4;
    private static final int FIRST_LETTER = 1;
    private static final int OPT_DIGIT = 5;
    private static final int OPT_SECOND_LETTER = 2;
    private static final int DOT = 46;
    private final EqualityUtil equalityUtil;
    private final TableNameUtil tableNameUtil;
    private final String address;
    private int cur;
    private int status;
    private String tableName;
    private String filename;
    private int row;
    private int col;

    public PositionParser(EqualityUtil equalityUtil, TableNameUtil tableNameUtil, String address) {
        this.equalityUtil = equalityUtil;
        this.tableNameUtil = tableNameUtil;
        this.address = address;
        this.row = 0;
        this.col = 0;
        this.cur = 0;
    }

    public Position parse() throws ParseException {
        this.parseFilename();
        this.parseTableName();
        this.parseColRow();
        return new Position(this.equalityUtil, this.tableNameUtil, this.filename, this.tableName, this.row - 1, this.col - 1, this.status);
    }

    private void parseFilename() throws ParseException {
        int i = this.address.indexOf(35);
        if (i == -1) {
            return;
        }
        String escapedFilename = this.address.substring(this.cur, i);
        this.filename = this.unescape(escapedFilename);
        this.cur = i + 1;
    }

    private String unescape(String str) throws ParseException {
        int length = str.length();
        if (str.charAt(0) == '\'' && str.charAt(length - 1) == '\'') {
            return this.unescapeEscaped(str.substring(1, length - 1));
        }
        int i = str.indexOf(39);
        if (i != -1) {
            throw new ParseException("Unquoted filename " + str, this.cur + i);
        }
        return str;
    }

    private String unescapeEscaped(String escaped) throws ParseException {
        StringBuilder sb = new StringBuilder();
        int quotes = 0;
        for (int i = 0; i < escaped.length(); ++i) {
            char c = escaped.charAt(i);
            if (c == '\'') {
                if (++quotes != 2) continue;
                quotes = 0;
                sb.append(c);
                continue;
            }
            if (quotes == 1) {
                throw new ParseException("Missing closing quote in filename " + escaped, this.cur + i);
            }
            sb.append(c);
        }
        if (quotes != 0) {
            throw new ParseException("Random quote in filename", this.cur);
        }
        return sb.toString();
    }

    private void parseTableName() throws ParseException {
        int i = this.address.indexOf(46, this.cur);
        if (i == -1) {
            return;
        }
        String escapedTableName = this.address.substring(this.cur, i);
        String tableName = this.unescape(escapedTableName);
        this.cur = i + 1;
        if (tableName.charAt(0) == '$') {
            this.status = 4;
            this.tableName = tableName.substring(1);
        } else {
            this.tableName = tableName;
        }
    }

    private void parseColRow() throws ParseException {
        String s = this.address.substring(this.cur).toUpperCase(Locale.US);
        int len = s.length();
        int state = 0;
        int n = 0;
        block8: while (n < len) {
            char c = s.charAt(n);
            switch (state) {
                case 0: {
                    if (c == '$') {
                        ++this.status;
                        ++n;
                    }
                    state = 1;
                    continue block8;
                }
                case 3: {
                    if (c == '$') {
                        this.status += 2;
                        ++n;
                    }
                    state = 4;
                    continue block8;
                }
                case 1: {
                    if ('A' <= c && c <= 'Z') {
                        this.col = c - 65 + 1;
                        state = 2;
                        ++n;
                        continue block8;
                    }
                    throw new ParseException("Expected letter", this.cur + n);
                }
                case 2: {
                    if ('A' <= c && c <= 'Z') {
                        this.col = this.col * 26 + c - 65 + 1;
                        ++n;
                        continue block8;
                    }
                    state = 3;
                    continue block8;
                }
                case 4: {
                    if ('0' <= c && c <= '9') {
                        this.row = c - 48;
                        state = 5;
                        ++n;
                        continue block8;
                    }
                    throw new ParseException("Expected digit", this.cur + n);
                }
                case 5: {
                    if ('0' <= c && c <= '9') {
                        this.row = this.row * 10 + c - 48;
                        ++n;
                        continue block8;
                    }
                    throw new ParseException("Expected digit", this.cur + n);
                }
            }
            throw new ParseException("Unexpected error", this.cur + n);
        }
        if (state != 5) {
            throw new ParseException("Unexpected error", this.cur + n);
        }
    }
}

