/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.tool;

import com.github.jferard.fastods.CellValue;
import com.github.jferard.fastods.DataWrapper;
import com.github.jferard.fastods.FastOdsException;
import com.github.jferard.fastods.TableCell;
import com.github.jferard.fastods.TableCellWalker;
import com.github.jferard.fastods.ToCellValueConverter;
import com.github.jferard.fastods.style.TableCellStyle;
import com.github.jferard.fastods.tool.ResultSetDataWrapperBuilder;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ResultSetDataWrapper
implements DataWrapper {
    private final TableCellStyle headCellStyle;
    private final Logger logger;
    private final boolean autoFilter;
    private final int max;
    private final ToCellValueConverter converter;
    private final ResultSet resultSet;
    private final Map<Integer, TableCell.Type> cellTypeByColIndex;
    private final CellValue nullValue;

    public static ResultSetDataWrapperBuilder builder(ResultSet rs) {
        return new ResultSetDataWrapperBuilder(rs);
    }

    public ResultSetDataWrapper(Logger logger, ToCellValueConverter converter, ResultSet rs, TableCellStyle headCellStyle, boolean autoFilter, Map<Integer, TableCell.Type> cellTypeByColIndex, CellValue nullValue, int max) {
        this.logger = logger;
        this.converter = converter;
        this.resultSet = rs;
        this.headCellStyle = headCellStyle;
        this.autoFilter = autoFilter;
        this.cellTypeByColIndex = cellTypeByColIndex;
        this.nullValue = nullValue;
        this.max = max;
    }

    @Override
    public boolean addToTable(TableCellWalker walker) throws IOException {
        int rowCount = 0;
        try {
            ResultSetMetaData metadata = this.resultSet.getMetaData();
            try {
                boolean oneBlankLine;
                int r1 = walker.rowIndex();
                int c1 = walker.colIndex();
                int columnCount = metadata.getColumnCount();
                this.writeFirstLineDataTo(walker, metadata);
                if (this.resultSet.next()) {
                    do {
                        if (this.max != -1 && ++rowCount > this.max) continue;
                        walker.nextRow();
                        walker.to(c1);
                        this.writeDataLineTo(walker, columnCount);
                    } while (this.resultSet.next());
                }
                boolean bl = oneBlankLine = rowCount == 0 || rowCount > this.max;
                if (oneBlankLine) {
                    walker.nextRow();
                    walker.to(c1);
                    this.writeLastLineDataTo(walker, columnCount, rowCount);
                }
                if (this.autoFilter) {
                    int r2 = walker.rowIndex();
                    int c2 = c1 + columnCount - 1;
                    walker.getTable().addAutoFilter(r1, c1, r2, c2);
                }
                walker.nextRow();
            }
            catch (SQLException e) {
                if (this.logger != null) {
                    this.logger.log(Level.SEVERE, "Can't read ResultSet row", e);
                }
                throw new RuntimeException(e);
            }
            catch (FastOdsException e) {
                throw new RuntimeException(e);
            }
        }
        catch (SQLException e) {
            if (this.logger != null) {
                this.logger.log(Level.SEVERE, "Can't read ResultSet metadata", e);
            }
            throw new RuntimeException(e);
        }
        return rowCount > 0;
    }

    private List<String> getColumnLabels(ResultSetMetaData metadata) throws SQLException {
        int columnCount = metadata.getColumnCount();
        ArrayList<String> names = new ArrayList<String>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            names.add(metadata.getColumnLabel(i + 1));
        }
        return names;
    }

    private List<Object> getColumnValues(int columnCount) throws SQLException {
        ArrayList<Object> values = new ArrayList<Object>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            values.add(this.resultSet.getObject(i + 1));
        }
        return values;
    }

    private void writeFirstLineDataTo(TableCellWalker walker, ResultSetMetaData metadata) throws SQLException, IOException {
        int columnCount = metadata.getColumnCount();
        List<String> columnLabels = this.getColumnLabels(metadata);
        for (int j = 0; j <= columnCount - 1; ++j) {
            String label = columnLabels.get(j);
            walker.setStringValue(label);
            if (this.headCellStyle != null) {
                walker.setStyle(this.headCellStyle);
            }
            walker.next();
        }
    }

    private void writeDataLineTo(TableCellWalker walker, int columnCount) throws SQLException, FastOdsException {
        List<Object> columnValues = this.getColumnValues(columnCount);
        for (int j = 0; j <= columnCount - 1; ++j) {
            Object object = columnValues.get(j);
            if (object == null) {
                walker.setCellValue(this.nullValue);
            } else if (this.cellTypeByColIndex != null) {
                TableCell.Type cellType = this.cellTypeByColIndex.get(j);
                if (cellType != null) {
                    walker.setCellValue(this.converter.from(cellType, object));
                }
            } else {
                walker.setCellValue(this.converter.from(object));
            }
            walker.next();
        }
    }

    private void writeLastLineDataTo(TableCellWalker walker, int columnCount, int rowCount) throws IOException {
        block3: {
            block2: {
                if (rowCount != 0) break block2;
                for (int j = 0; j <= columnCount - 1; ++j) {
                    walker.setStringValue("");
                    walker.next();
                }
                break block3;
            }
            if (rowCount <= this.max) break block3;
            for (int j = 0; j <= columnCount - 1; ++j) {
                walker.setStringValue(String.format("... (%d rows remaining)", rowCount - this.max));
                walker.next();
            }
        }
    }
}

