/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.NamedOdsFileWriter;
import com.github.jferard.fastods.TableAppender;
import com.github.jferard.fastods.TableBuilder;
import com.github.jferard.fastods.TableCellWalker;
import com.github.jferard.fastods.TableRowImpl;
import com.github.jferard.fastods.datastyle.DataStyles;
import com.github.jferard.fastods.odselement.ContentElement;
import com.github.jferard.fastods.odselement.StylesContainer;
import com.github.jferard.fastods.odselement.config.ConfigItemMapEntry;
import com.github.jferard.fastods.style.TableCellStyle;
import com.github.jferard.fastods.style.TableColumnStyle;
import com.github.jferard.fastods.style.TableStyle;
import com.github.jferard.fastods.util.NamedObject;
import com.github.jferard.fastods.util.PositionUtil;
import com.github.jferard.fastods.util.WriteUtil;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;
import java.text.ParseException;

public class Table
implements NamedObject {
    private final ContentElement contentElement;
    private final TableBuilder builder;
    private final TableAppender appender;
    private String name;

    public static Table create(ContentElement contentElement, PositionUtil positionUtil, WriteUtil writeUtil, XMLUtil xmlUtil, String name, int rowCapacity, int columnCapacity, StylesContainer stylesContainer, DataStyles format, boolean libreOfficeMode) {
        positionUtil.checkTableName(name);
        TableBuilder builder = TableBuilder.create(positionUtil, writeUtil, xmlUtil, stylesContainer, format, libreOfficeMode, name, rowCapacity, columnCapacity);
        return new Table(name, contentElement, builder);
    }

    Table(String name, ContentElement contentElement, TableBuilder builder) {
        this.name = name;
        this.contentElement = contentElement;
        this.builder = builder;
        this.appender = new TableAppender(builder);
    }

    public void addObserver(NamedOdsFileWriter observer) {
        this.builder.addObserver(observer);
    }

    public void appendXMLToContentEntry(XMLUtil util, Appendable appendable) throws IOException {
        this.appender.appendXMLToContentEntry(util, appendable);
    }

    public void flush() throws IOException {
        this.builder.flushBeginTable(this.appender);
        this.builder.flushEndTable(this.appender);
    }

    public void flushAllAvailableRows(XMLUtil util, Appendable appendable) throws IOException {
        this.appender.flushAllAvailableRows(util, appendable);
    }

    public void flushRemainingRowsFrom(XMLUtil util, Appendable appendable, int rowIndex) throws IOException {
        this.appender.flushRemainingRowsFrom(util, appendable, rowIndex);
    }

    public void flushSomeAvailableRowsFrom(XMLUtil util, Appendable appendable, int rowIndex) throws IOException {
        this.appender.flushSomeAvailableRowsFrom(util, appendable, rowIndex);
    }

    public ConfigItemMapEntry getConfigEntry() {
        return this.builder.getConfigEntry();
    }

    public int getRowCount() {
        return this.builder.getRowCount();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.appender.isPreambleWritten()) {
            throw new IllegalStateException();
        }
        this.name = name;
    }

    public TableRowImpl getRow(int rowIndex) throws IOException {
        return this.builder.getRow(this, this.appender, rowIndex);
    }

    public String getStyleName() {
        return this.builder.getStyleName();
    }

    @Deprecated
    public TableRowImpl nextRow() throws IOException {
        return this.builder.nextRow(this, this.appender);
    }

    public TableCellWalker getWalker() throws IOException {
        return new TableCellWalker(this);
    }

    public void setCellMerge(int rowIndex, int colIndex, int rowMerge, int columnMerge) throws IOException {
        this.builder.setCellMerge(this, this.appender, rowIndex, colIndex, rowMerge, columnMerge);
    }

    @Deprecated
    public void setCellMerge(String address, int rowMerge, int columnMerge) throws IOException, ParseException {
        this.builder.setCellMerge(this, this.appender, address, rowMerge, columnMerge);
    }

    public void setColumnStyle(int col, TableColumnStyle ts) {
        if (this.appender.isPreambleWritten()) {
            throw new IllegalStateException();
        }
        this.builder.setColumnStyle(col, ts);
    }

    public void setConfigItem(String name, String type, String value) {
        this.builder.setConfigItem(name, type, value);
    }

    public void updateConfigItem(String item, String value) {
        this.builder.updateConfigItem(item, value);
    }

    public void setStyle(TableStyle style) {
        this.builder.setStyle(style);
    }

    public void setRowsSpanned(int rowIndex, int colIndex, int n) throws IOException {
        this.builder.setRowsSpanned(this, this.appender, rowIndex, colIndex, n);
    }

    public TableCellStyle findDefaultCellStyle(int columnIndex) {
        return this.builder.findDefaultCellStyle(columnIndex);
    }

    public void addAutoFilter(int r1, int c1, int r2, int c2) {
        this.contentElement.addAutoFilter(this, r1, c1, r2, c2);
    }
}

