/*
 * Decompiled with CFR 0.152.
 */
package smile.feature.extraction;

import smile.data.DataFrame;
import smile.feature.extraction.Projection;
import smile.linalg.UPLO;
import smile.math.MathEx;
import smile.tensor.DenseMatrix;
import smile.tensor.EVD;
import smile.tensor.SVD;
import smile.tensor.Vector;

public class PCA
extends Projection {
    private static final long serialVersionUID = 2L;
    private final Vector mu;
    private final Vector pmu;
    private final DenseMatrix eigvectors;
    private final Vector eigvalues;
    private final Vector proportion;
    private final Vector cumulativeProportion;

    public PCA(Vector mu, Vector eigvalues, DenseMatrix loadings, DenseMatrix projection, String ... columns) {
        super(projection, "PCA", columns);
        this.mu = mu;
        this.eigvalues = eigvalues;
        this.eigvectors = loadings;
        this.proportion = eigvalues.copy();
        double norm1 = this.proportion.norm1();
        this.proportion.scale(1.0 / norm1);
        this.cumulativeProportion = this.proportion.copy();
        for (int i = 1; i < this.proportion.size(); ++i) {
            this.cumulativeProportion.set(i, this.cumulativeProportion.get(i - 1) + this.proportion.get(i));
        }
        this.pmu = projection.mv(mu);
    }

    public static PCA fit(DataFrame data, String ... columns) {
        double[][] x = data.toArray(columns);
        return PCA.fit(x, columns);
    }

    public static PCA cor(DataFrame data, String ... columns) {
        double[][] x = data.toArray(columns);
        return PCA.cor(x, columns);
    }

    public static PCA fit(double[][] data, String ... columns) {
        DenseMatrix eigvectors;
        Vector eigvalues;
        int m = data.length;
        int n = data[0].length;
        DenseMatrix X = DenseMatrix.of((double[][])data);
        Vector mu = X.colMeans();
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                X.sub(i, j, mu.get(j));
            }
        }
        if (m > n) {
            SVD svd = X.svd();
            eigvalues = svd.s();
            for (int i = 0; i < eigvalues.size(); ++i) {
                double si = eigvalues.get(i);
                eigvalues.set(i, si * si);
            }
            eigvectors = svd.Vt().transpose();
        } else {
            DenseMatrix cov = X.zeros(n, n);
            for (int k = 0; k < m; ++k) {
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j <= i; ++j) {
                        cov.add(i, j, X.get(k, i) * X.get(k, j));
                    }
                }
            }
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j <= i; ++j) {
                    cov.div(i, j, (double)m);
                    cov.set(j, i, cov.get(i, j));
                }
            }
            cov.withUplo(UPLO.LOWER);
            EVD eigen = cov.eigen().sort();
            eigvalues = eigen.wr();
            eigvectors = eigen.Vr();
        }
        DenseMatrix projection = PCA.getProjection(eigvalues, eigvectors, 0.95);
        return new PCA(mu, eigvalues, eigvectors, projection, columns);
    }

    public static PCA cor(double[][] data, String ... columns) {
        int j;
        int i;
        int i2;
        int m = data.length;
        int n = data[0].length;
        DenseMatrix X = DenseMatrix.of((double[][])data);
        Vector mu = X.colMeans();
        for (int j2 = 0; j2 < n; ++j2) {
            for (i2 = 0; i2 < m; ++i2) {
                X.sub(i2, j2, mu.get(j2));
            }
        }
        DenseMatrix cov = X.zeros(n, n);
        for (int k = 0; k < m; ++k) {
            for (i = 0; i < n; ++i) {
                for (j = 0; j <= i; ++j) {
                    cov.add(i, j, X.get(k, i) * X.get(k, j));
                }
            }
        }
        for (i2 = 0; i2 < n; ++i2) {
            for (int j3 = 0; j3 <= i2; ++j3) {
                cov.div(i2, j3, (double)m);
                cov.set(j3, i2, cov.get(i2, j3));
            }
        }
        double[] sd = new double[n];
        for (i = 0; i < n; ++i) {
            sd[i] = Math.sqrt(cov.get(i, i));
        }
        for (i = 0; i < n; ++i) {
            for (j = 0; j <= i; ++j) {
                cov.div(i, j, sd[i] * sd[j]);
                cov.set(j, i, cov.get(i, j));
            }
        }
        cov.withUplo(UPLO.LOWER);
        EVD eigen = cov.eigen().sort();
        DenseMatrix loadings = eigen.Vr();
        for (int i3 = 0; i3 < n; ++i3) {
            for (int j4 = 0; j4 < n; ++j4) {
                loadings.div(i3, j4, sd[i3]);
            }
        }
        DenseMatrix projection = PCA.getProjection(eigen.wr(), loadings, 0.95);
        return new PCA(mu, eigen.wr(), loadings, projection, columns);
    }

    public Vector center() {
        return this.mu;
    }

    public DenseMatrix loadings() {
        return this.eigvectors;
    }

    public Vector variance() {
        return this.eigvalues;
    }

    public Vector varianceProportion() {
        return this.proportion;
    }

    public Vector cumulativeVarianceProportion() {
        return this.cumulativeProportion;
    }

    private static DenseMatrix getProjection(Vector eigvalues, DenseMatrix loadings, double p) {
        int k;
        if (p <= 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Invalid percentage of variance: " + p);
        }
        double[] proportion = eigvalues.toArray(new double[0]);
        MathEx.unitize1((double[])proportion);
        double sum = 0.0;
        for (k = 0; k < proportion.length && !((sum += proportion[k]) >= p); ++k) {
        }
        return PCA.getProjection(loadings, k + 1);
    }

    private static DenseMatrix getProjection(DenseMatrix loadings, int p) {
        int n = loadings.nrow();
        if (p < 1 || p > n) {
            throw new IllegalArgumentException("Invalid dimension of feature space: " + p);
        }
        DenseMatrix projection = loadings.zeros(p, n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < p; ++j) {
                projection.set(j, i, loadings.get(i, j));
            }
        }
        return projection;
    }

    public PCA getProjection(int p) {
        DenseMatrix projection = PCA.getProjection(this.eigvectors, p);
        return new PCA(this.mu, this.eigvalues, this.eigvectors, projection, this.columns);
    }

    public PCA getProjection(double p) {
        int k;
        if (p <= 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Invalid percentage of variance: " + p);
        }
        for (k = 0; k < this.cumulativeProportion.size() && !(this.cumulativeProportion.get(k) >= p); ++k) {
        }
        return this.getProjection(k);
    }

    @Override
    protected double[] postprocess(double[] x) {
        for (int i = 0; i < x.length; ++i) {
            int n = i;
            x[n] = x[n] - this.pmu.get(i);
        }
        return x;
    }
}

