/*
 * Decompiled with CFR 0.152.
 */
package smile.math;

import java.util.Arrays;
import smile.math.MathEx;

public interface Histogram {
    public static double[][] of(int[] data) {
        return Histogram.of(data, Histogram.bins(data.length));
    }

    public static double[][] of(float[] data) {
        return Histogram.of(data, Histogram.bins(data.length));
    }

    public static double[][] of(double[] data) {
        return Histogram.of(data, Histogram.bins(data.length));
    }

    public static double[][] of(int[] data, int k) {
        if (k <= 1) {
            throw new IllegalArgumentException("Invalid number of bins: " + k);
        }
        int min = MathEx.min(data);
        int max = MathEx.max(data);
        int span = max - min + 1;
        int width = 1;
        int residual = 1;
        while (residual > 0) {
            width = span / k;
            if (width == 0) {
                width = 1;
            }
            if ((residual = span - k * width) <= 0) continue;
            ++k;
        }
        double center = (double)width / 2.0;
        double[] breaks = new double[k + 1];
        breaks[0] = (double)min - center;
        for (int i = 1; i <= k; ++i) {
            breaks[i] = breaks[i - 1] + (double)width;
        }
        return Histogram.of(data, breaks);
    }

    public static double[][] of(int[] data, double[] breaks) {
        int k = breaks.length - 1;
        if (k <= 1) {
            throw new IllegalArgumentException("Invalid number of bins: " + k);
        }
        double[][] freq = new double[3][k];
        for (int i = 0; i < k; ++i) {
            freq[0][i] = breaks[i];
            freq[1][i] = breaks[i + 1];
            freq[2][i] = 0.0;
        }
        for (int d : data) {
            int j = Arrays.binarySearch(breaks, (double)d);
            if (j >= k) {
                j = k - 1;
            }
            if (j < -1 && j >= -breaks.length) {
                j = -j - 2;
            }
            if (j < 0) continue;
            double[] dArray = freq[2];
            int n = j;
            dArray[n] = dArray[n] + 1.0;
        }
        return freq;
    }

    public static double[][] of(float[] data, int k) {
        if (k <= 1) {
            throw new IllegalArgumentException("Invalid number of bins: " + k);
        }
        float min = MathEx.min(data);
        float max = MathEx.max(data);
        float span = max - min;
        if (span == 0.0f) {
            span = k;
        }
        float width = span / (float)k;
        float[] breaks = new float[k + 1];
        breaks[0] = min;
        for (int i = 1; i < k; ++i) {
            breaks[i] = breaks[i - 1] + width;
        }
        breaks[k] = max;
        return Histogram.of(data, breaks);
    }

    public static double[][] of(float[] data, float[] breaks) {
        int k = breaks.length - 1;
        if (k <= 1) {
            throw new IllegalArgumentException("Invalid number of bins: " + k);
        }
        double[][] freq = new double[3][k];
        for (int i = 0; i < k; ++i) {
            freq[0][i] = breaks[i];
            freq[1][i] = breaks[i + 1];
            freq[2][i] = 0.0;
        }
        for (float d : data) {
            int j = Arrays.binarySearch(breaks, d);
            if (j >= k) {
                j = k - 1;
            }
            if (j < -1 && j >= -breaks.length) {
                j = -j - 2;
            }
            if (j < 0) continue;
            double[] dArray = freq[2];
            int n = j;
            dArray[n] = dArray[n] + 1.0;
        }
        return freq;
    }

    public static double[][] of(double[] data, int k) {
        double min = MathEx.min(data);
        double max = MathEx.max(data);
        double span = max - min;
        if (span == 0.0) {
            span = k;
        }
        double width = span / (double)k;
        double[] breaks = new double[k + 1];
        breaks[0] = min;
        for (int i = 1; i < k; ++i) {
            breaks[i] = breaks[i - 1] + width;
        }
        breaks[k] = max;
        return Histogram.of(data, breaks);
    }

    public static double[][] of(double[] data, double[] breaks) {
        int k = breaks.length - 1;
        if (k <= 1) {
            throw new IllegalArgumentException("Invalid number of bins: " + k);
        }
        double[][] freq = new double[3][k];
        for (int i = 0; i < k; ++i) {
            freq[0][i] = breaks[i];
            freq[1][i] = breaks[i + 1];
            freq[2][i] = 0.0;
        }
        for (double d : data) {
            int j = Arrays.binarySearch(breaks, d);
            if (j >= k) {
                j = k - 1;
            }
            if (j < -1 && j >= -breaks.length) {
                j = -j - 2;
            }
            if (j < 0) continue;
            double[] dArray = freq[2];
            int n = j;
            dArray[n] = dArray[n] + 1.0;
        }
        return freq;
    }

    public static double[] breaks(double[] x, double h) {
        return Histogram.breaks(MathEx.min(x), MathEx.max(x), h);
    }

    public static double[] breaks(double min, double max, double h) {
        if (h <= 0.0) {
            throw new IllegalArgumentException("Invalid bin width: " + h);
        }
        if (min > max) {
            throw new IllegalArgumentException("Invalid lower and upper bounds: " + min + " > " + max);
        }
        int k = (int)Math.ceil((max - min) / h);
        double[] breaks = new double[k + 1];
        double step = (h * (double)k - (max - min)) / 2.0;
        breaks[0] = min - step;
        breaks[k] = max + step;
        for (int i = 1; i < k; ++i) {
            breaks[i] = breaks[i - 1] + h;
        }
        return breaks;
    }

    public static double[] breaks(double[] x, int k) {
        return Histogram.breaks(MathEx.min(x), MathEx.max(x), k);
    }

    public static double[] breaks(double min, double max, int k) {
        if (k <= 1) {
            throw new IllegalArgumentException("Invalid number of bins: " + k);
        }
        if (min > max) {
            throw new IllegalArgumentException("Invalid lower and upper bounds: " + min + " > " + max);
        }
        double h = (max - min) / (double)k;
        return Histogram.breaks(min, max, h);
    }

    public static int bins(double[] x, double h) {
        if (h <= 0.0) {
            throw new IllegalArgumentException("Invalid bin width: " + h);
        }
        double max = MathEx.max(x);
        double min = MathEx.min(x);
        return (int)Math.ceil((max - min) / h);
    }

    public static int bins(int n) {
        int k = (int)Math.sqrt(n);
        if (k < 5) {
            k = 5;
        }
        return k;
    }

    public static int sturges(int n) {
        int k = (int)Math.ceil(MathEx.log2(n) + 1.0);
        if (k < 5) {
            k = 5;
        }
        return k;
    }

    public static int scott(double[] x) {
        double h = Math.ceil(3.5 * MathEx.stdev(x) / Math.pow(x.length, 0.3333333333333333));
        return Histogram.bins(x, h);
    }
}

