/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.util;

import java.util.Objects;
import java.util.function.Function;

public class Preconditions {
    public static <T> T checkArgument(T argument, Function<T, Boolean> predicate, Object errorMessage) {
        if (!predicate.apply(argument).booleanValue()) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
        return argument;
    }

    public static <T> T checkNotNull(T argument) {
        return Preconditions.checkNotNull(argument, "Argument should be not null");
    }

    public static <T> T checkNotNull(T argument, Object errorMessage) {
        return (T)Preconditions.checkArgument(argument, Objects::nonNull, errorMessage);
    }
}

