/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.model.positions;

import com.github.filosganga.geogson.model.positions.AbstractPositions;
import com.github.filosganga.geogson.model.positions.LinearPositions;
import com.github.filosganga.geogson.model.positions.Positions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SinglePosition
extends AbstractPositions<Positions> {
    private static final long serialVersionUID = 2L;
    private static final List<Positions> EMPTY_CHILDREN = new ArrayList<Positions>();
    private final double lon;
    private final double lat;
    private final double alt;
    private transient Integer cachedHashCode = null;

    public SinglePosition(double lon, double lat, double alt) {
        super(EMPTY_CHILDREN);
        this.lon = lon;
        this.lat = lat;
        this.alt = alt;
    }

    public double lon() {
        return this.lon;
    }

    public double lat() {
        return this.lat;
    }

    public double alt() {
        return this.alt;
    }

    @Override
    public Positions merge(Positions other) {
        if (other instanceof SinglePosition) {
            SinglePosition that = (SinglePosition)other;
            return LinearPositions.builder().addSinglePosition(this).addSinglePosition(that).build();
        }
        return other.merge(this);
    }

    @Override
    public int hashCode() {
        if (this.cachedHashCode == null) {
            this.cachedHashCode = Objects.hash(SinglePosition.class, this.lon, this.lat, this.alt);
        }
        return this.cachedHashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SinglePosition other = (SinglePosition)obj;
        return Objects.equals(this.lon, other.lon) && Objects.equals(this.lat, other.lat) && Objects.equals(this.alt, other.alt);
    }

    @Override
    public String toString() {
        return "SinglePosition{lon=" + this.lon + ", lat=" + this.lat + ", alt=" + this.alt + '}';
    }
}

