/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.model.positions;

import com.github.filosganga.geogson.model.positions.AbstractPositions;
import com.github.filosganga.geogson.model.positions.AreaPositions;
import com.github.filosganga.geogson.model.positions.LinearPositions;
import com.github.filosganga.geogson.model.positions.Positions;
import com.github.filosganga.geogson.model.positions.SinglePosition;
import java.util.LinkedList;
import java.util.List;

public class MultiDimensionalPositions
extends AbstractPositions<AreaPositions> {
    private static final long serialVersionUID = 1L;

    private MultiDimensionalPositions(List<AreaPositions> children) {
        super(children);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MultiDimensionalPositions positions) {
        return MultiDimensionalPositions.builder().addAreaPositions(positions.children);
    }

    @Override
    public Positions merge(Positions other) {
        if (other instanceof SinglePosition) {
            throw new IllegalArgumentException("Cannot merge single position and multidimensional positions");
        }
        if (other instanceof LinearPositions) {
            return this.merge(AreaPositions.builder().addLinearPosition((LinearPositions)other).build());
        }
        if (other instanceof AreaPositions) {
            AreaPositions that = (AreaPositions)other;
            return new Builder().addAreaPositions(this.children).addAreaPosition(that).build();
        }
        throw new IllegalArgumentException("Cannot merge with: " + other);
    }

    public static class Builder
    implements AbstractPositions.PositionsBuilder {
        private LinkedList<AreaPositions> areaPositions = new LinkedList();

        public Builder addAreaPosition(AreaPositions ap) {
            this.areaPositions.add(ap);
            return this;
        }

        public Builder addAreaPositions(Iterable<AreaPositions> aps) {
            aps.forEach(this::addAreaPosition);
            return this;
        }

        @Override
        public Builder addChild(Positions p) {
            if (p instanceof AreaPositions) {
                return this.addAreaPosition((AreaPositions)p);
            }
            if (p instanceof LinearPositions) {
                return this.addAreaPosition(AreaPositions.builder().addLinearPosition((LinearPositions)p).build());
            }
            throw new IllegalArgumentException("The position " + p + "cannot be a child of MultiDimensionalPositions");
        }

        @Override
        public MultiDimensionalPositions build() {
            return new MultiDimensionalPositions(this.areaPositions);
        }
    }
}

