/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.model.positions;

import com.github.filosganga.geogson.model.positions.AbstractPositions;
import com.github.filosganga.geogson.model.positions.AreaPositions;
import com.github.filosganga.geogson.model.positions.Positions;
import com.github.filosganga.geogson.model.positions.SinglePosition;
import java.util.LinkedList;
import java.util.List;

public class LinearPositions
extends AbstractPositions<SinglePosition> {
    private static final long serialVersionUID = 1L;
    private final Boolean isClosed;

    private LinearPositions(List<SinglePosition> children, boolean isClosed) {
        super(children);
        this.isClosed = isClosed;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(LinearPositions positions) {
        return LinearPositions.builder().addSinglePositions(positions.children);
    }

    @Override
    public Positions merge(Positions other) {
        if (other instanceof SinglePosition) {
            SinglePosition that = (SinglePosition)other;
            return LinearPositions.builder().addSinglePosition(that).build();
        }
        if (other instanceof LinearPositions) {
            LinearPositions that = (LinearPositions)other;
            return AreaPositions.builder().addLinearPosition(this).addLinearPosition(that).build();
        }
        return other.merge(this);
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public static class Builder
    implements AbstractPositions.PositionsBuilder {
        private LinkedList<SinglePosition> singlePositions = new LinkedList();
        private SinglePosition first = null;
        private SinglePosition last = null;
        private int size = 0;

        public Builder addSinglePosition(SinglePosition sp) {
            this.singlePositions.add(sp);
            if (this.first == null) {
                this.first = sp;
            }
            this.last = sp;
            ++this.size;
            return this;
        }

        public Builder addSinglePositions(Iterable<SinglePosition> sps) {
            sps.forEach(this::addSinglePosition);
            return this;
        }

        @Override
        public AbstractPositions.PositionsBuilder addChild(Positions p) {
            if (p instanceof SinglePosition) {
                return this.addSinglePosition((SinglePosition)p);
            }
            if (p instanceof LinearPositions) {
                return AreaPositions.builder().addChild(this.build()).addChild(p);
            }
            throw new IllegalArgumentException("The position " + p + "cannot be a child of LinearPositions");
        }

        @Override
        public LinearPositions build() {
            Boolean isClosed = this.size >= 4 && this.first.equals(this.last);
            return new LinearPositions(this.singlePositions, isClosed);
        }
    }
}

