/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.model.positions;

import com.github.filosganga.geogson.model.positions.AbstractPositions;
import com.github.filosganga.geogson.model.positions.LinearPositions;
import com.github.filosganga.geogson.model.positions.MultiDimensionalPositions;
import com.github.filosganga.geogson.model.positions.Positions;
import com.github.filosganga.geogson.model.positions.SinglePosition;
import java.util.LinkedList;
import java.util.List;

public class AreaPositions
extends AbstractPositions<LinearPositions> {
    private static final long serialVersionUID = 1L;
    private final Boolean allChildrenAreClosed;

    private AreaPositions(List<LinearPositions> children, Boolean allChildrenAreClosed) {
        super(children);
        this.allChildrenAreClosed = allChildrenAreClosed;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(AreaPositions positions) {
        return AreaPositions.builder().addLinearPositions(positions.children);
    }

    public Boolean areAllChildrenClosed() {
        return this.allChildrenAreClosed;
    }

    @Override
    public Positions merge(Positions other) {
        if (other instanceof SinglePosition) {
            throw new IllegalArgumentException("Cannot merge single position and area children");
        }
        if (other instanceof LinearPositions) {
            LinearPositions that = (LinearPositions)other;
            return AreaPositions.builder().addLinearPosition(that).build();
        }
        if (other instanceof AreaPositions) {
            AreaPositions that = (AreaPositions)other;
            return MultiDimensionalPositions.builder().addAreaPosition(this).addAreaPosition(that).build();
        }
        return other.merge(this);
    }

    public static class Builder
    implements AbstractPositions.PositionsBuilder {
        private LinkedList<LinearPositions> linearPositions = new LinkedList();
        private boolean allChildrenAreClosed = true;

        public Builder addLinearPosition(LinearPositions lp) {
            this.linearPositions.add(lp);
            this.allChildrenAreClosed = this.allChildrenAreClosed && lp.isClosed();
            return this;
        }

        public Builder addLinearPositions(Iterable<LinearPositions> lps) {
            lps.forEach(this::addLinearPosition);
            return this;
        }

        @Override
        public AbstractPositions.PositionsBuilder addChild(Positions p) {
            if (p instanceof LinearPositions) {
                return this.addLinearPosition((LinearPositions)p);
            }
            if (p instanceof SinglePosition) {
                return this.addLinearPosition(LinearPositions.builder().addSinglePosition((SinglePosition)p).build());
            }
            if (p instanceof AreaPositions) {
                return MultiDimensionalPositions.builder().addAreaPosition(this.build()).addChild(p);
            }
            throw new IllegalArgumentException("The position " + p + "cannot be a child of AreaPosition");
        }

        @Override
        public AreaPositions build() {
            return new AreaPositions(this.linearPositions, this.allChildrenAreClosed);
        }
    }
}

