/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.model.positions;

import com.github.filosganga.geogson.model.positions.AreaPositions;
import com.github.filosganga.geogson.model.positions.LinearPositions;
import com.github.filosganga.geogson.model.positions.MultiDimensionalPositions;
import com.github.filosganga.geogson.model.positions.Positions;
import com.github.filosganga.geogson.model.positions.SinglePosition;
import com.github.filosganga.geogson.util.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class AbstractPositions<T extends Positions>
implements Positions {
    private static final long serialVersionUID = 1L;
    protected final List<T> children;
    private transient Integer cachedSize = null;
    private transient Integer cachedHashCode = null;

    AbstractPositions(List<T> children) {
        this.children = Preconditions.checkArgument(children, Objects::nonNull, "The children cannot be null");
    }

    public List<T> children() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public int size() {
        if (this.cachedSize == null) {
            this.cachedSize = this.children.size();
        }
        return this.cachedSize;
    }

    public int hashCode() {
        if (this.cachedHashCode == null) {
            this.cachedHashCode = Objects.hash(this.getClass(), this.children);
        }
        return this.cachedHashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractPositions other = (AbstractPositions)obj;
        return Objects.equals(this.children, other.children);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{children=" + this.children + '}';
    }

    public static interface PositionsBuilder {
        public static PositionsBuilder builderOf(Positions p) {
            if (p instanceof SinglePosition) {
                return LinearPositions.builder();
            }
            if (p instanceof LinearPositions) {
                return AreaPositions.builder();
            }
            if (p instanceof AreaPositions) {
                return MultiDimensionalPositions.builder();
            }
            throw new IllegalArgumentException("No builder can be supplied for Positions " + p);
        }

        public PositionsBuilder addChild(Positions var1);

        public Positions build();
    }
}

