/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.model;

import com.github.filosganga.geogson.model.AbstractGeometry;
import com.github.filosganga.geogson.model.Geometry;
import com.github.filosganga.geogson.model.LinearGeometry;
import com.github.filosganga.geogson.model.LinearRing;
import com.github.filosganga.geogson.model.MultiLineString;
import com.github.filosganga.geogson.model.positions.AreaPositions;
import com.github.filosganga.geogson.model.positions.LinearPositions;
import com.github.filosganga.geogson.util.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Polygon
extends MultiLineString {
    private static final long serialVersionUID = 1L;

    public Polygon(AreaPositions positions) {
        super(Preconditions.checkArgument(positions, AreaPositions::areAllChildrenClosed, "In a Polygon all the linear position must be closed"));
    }

    public static Polygon of(LinearRing perimeter, LinearRing ... holes) {
        return Polygon.of(perimeter, Arrays.asList(holes));
    }

    public static Polygon of(LinearRing perimeter, Iterable<LinearRing> holes) {
        return Polygon.of(perimeter, StreamSupport.stream(holes.spliterator(), false));
    }

    public static Polygon of(LinearRing perimeter, Stream<LinearRing> holes) {
        return new Polygon(AreaPositions.builder().addLinearPosition((LinearPositions)perimeter.positions()).addLinearPositions(holes.map(AbstractGeometry::positions)::iterator).build());
    }

    @Override
    public Geometry.Type type() {
        return Geometry.Type.POLYGON;
    }

    public List<LinearRing> linearRings() {
        return this.lineStrings().stream().map(LinearGeometry::toLinearRing).collect(Collectors.toList());
    }

    public LinearRing perimeter() {
        return this.linearRings().iterator().next();
    }

    public List<LinearRing> holes() {
        return this.linearRings().stream().skip(1L).collect(Collectors.toList());
    }
}

