/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.model;

import com.github.filosganga.geogson.model.AbstractGeometry;
import com.github.filosganga.geogson.model.Geometry;
import com.github.filosganga.geogson.model.LineString;
import com.github.filosganga.geogson.model.Polygon;
import com.github.filosganga.geogson.model.positions.AreaPositions;
import com.github.filosganga.geogson.model.positions.LinearPositions;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MultiLineString
extends AbstractGeometry<AreaPositions> {
    private static final long serialVersionUID = 1L;

    public MultiLineString(AreaPositions positions) {
        super(positions);
    }

    public static MultiLineString of(LineString ... lineStrings) {
        return MultiLineString.of(Arrays.asList(lineStrings));
    }

    public static MultiLineString of(Iterable<LineString> lineStrings) {
        AreaPositions.Builder positionsBuilder = AreaPositions.builder();
        for (LineString lineString : lineStrings) {
            positionsBuilder.addLinearPosition((LinearPositions)lineString.positions());
        }
        return new MultiLineString(positionsBuilder.build());
    }

    public static MultiLineString of(Stream<LineString> lineStrings) {
        return MultiLineString.of(lineStrings.collect(Collectors.toList()));
    }

    @Override
    public Geometry.Type type() {
        return Geometry.Type.MULTI_LINE_STRING;
    }

    public Polygon toPolygon() {
        return new Polygon((AreaPositions)this.positions());
    }

    public MultiLineString toMultiLineString() {
        return new MultiLineString((AreaPositions)this.positions());
    }

    public List<LineString> lineStrings() {
        return ((AreaPositions)this.positions()).children().stream().map(LineString::new).collect(Collectors.toList());
    }
}

