/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.model;

import com.github.filosganga.geogson.model.Geometry;
import com.github.filosganga.geogson.model.LineString;
import com.github.filosganga.geogson.model.Point;
import com.github.filosganga.geogson.model.positions.LinearPositions;
import com.github.filosganga.geogson.model.positions.SinglePosition;
import com.github.filosganga.geogson.util.Preconditions;
import java.util.Arrays;
import java.util.stream.Stream;

public class LinearRing
extends LineString {
    private static final long serialVersionUID = 1L;

    public LinearRing(LinearPositions positions) {
        super(Preconditions.checkArgument(positions, LinearPositions::isClosed, "LinearRing must be composed by a minimum of 4 points with the first and the last that are the same."));
    }

    public static LinearRing of(Point ... points) {
        return LinearRing.of(Arrays.asList(points));
    }

    public static LinearRing of(Iterable<Point> points) {
        LinearPositions.Builder builder = LinearPositions.builder();
        for (Point point : points) {
            builder.addSinglePosition((SinglePosition)point.positions());
        }
        return new LinearRing(builder.build());
    }

    public static LinearRing of(Stream<Point> points) {
        return LinearRing.of(points::iterator);
    }

    @Override
    public Geometry.Type type() {
        return Geometry.Type.LINEAR_RING;
    }
}

