/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.model;

import com.github.filosganga.geogson.model.Geometry;
import com.github.filosganga.geogson.model.positions.Positions;
import com.github.filosganga.geogson.model.positions.SinglePosition;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class GeometryCollection
implements Geometry<Positions>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Geometry<?>> geometries;

    private GeometryCollection(List<Geometry<?>> geometries) {
        this.geometries = geometries;
    }

    public static GeometryCollection of(Geometry<?> ... geometries) {
        return new GeometryCollection(Arrays.asList(geometries));
    }

    public static GeometryCollection of(Iterable<Geometry<?>> geometries) {
        if (geometries instanceof List) {
            return new GeometryCollection((List)geometries);
        }
        return GeometryCollection.of(StreamSupport.stream(geometries.spliterator(), false).collect(Collectors.toList()));
    }

    public static GeometryCollection of(Stream<Geometry<?>> geometries) {
        return new GeometryCollection(geometries.collect(Collectors.toList()));
    }

    public List<Geometry<?>> getGeometries() {
        return Collections.unmodifiableList(this.geometries);
    }

    @Override
    public Geometry.Type type() {
        return Geometry.Type.GEOMETRY_COLLECTION;
    }

    @Override
    public Positions positions() {
        SinglePosition positions = new SinglePosition(Double.NaN, Double.NaN, Double.NaN);
        for (Geometry<?> geometry : this.geometries) {
            positions.merge((Positions)geometry.positions());
        }
        return positions;
    }

    @Override
    public int size() {
        return this.geometries.size();
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.geometries);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GeometryCollection other = (GeometryCollection)obj;
        return Objects.equals(this.geometries, other.geometries);
    }

    public String toString() {
        return "GeometryCollection{geometries: " + Objects.toString(this.geometries) + "}";
    }
}

