/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.model;

import com.github.filosganga.geogson.model.Geometry;
import com.github.filosganga.geogson.model.positions.Positions;
import com.github.filosganga.geogson.util.Preconditions;
import java.io.Serializable;
import java.util.Objects;

public abstract class AbstractGeometry<P extends Positions>
implements Geometry<P>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final P positions;
    private transient Integer cachedHashCode = null;

    AbstractGeometry(P positions) {
        this.positions = Preconditions.checkArgument(positions, Objects::nonNull, "Postitions is mandatory");
    }

    @Override
    public P positions() {
        return this.positions;
    }

    @Override
    public int size() {
        return this.positions.size();
    }

    public int hashCode() {
        if (this.cachedHashCode == null) {
            this.cachedHashCode = Objects.hash(this.getClass(), this.positions);
        }
        return this.cachedHashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractGeometry other = (AbstractGeometry)obj;
        return Objects.equals(this.positions, other.positions);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{type: " + (Object)((Object)this.type()) + ", positions: " + Objects.toString(this.positions) + "}";
    }
}

