/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.gson;

import com.github.filosganga.geogson.model.Feature;
import com.github.filosganga.geogson.model.FeatureCollection;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.LinkedList;

public final class FeatureCollectionAdapter
extends TypeAdapter<FeatureCollection> {
    private final Gson gson;
    private final TypeAdapter<Feature> featureAdapter;

    public FeatureCollectionAdapter(Gson gson) {
        this.gson = gson;
        this.featureAdapter = gson.getAdapter(Feature.class);
    }

    public void write(JsonWriter out, FeatureCollection value) throws IOException {
        if (value == null) {
            out.nullValue();
        } else {
            out.beginObject();
            out.name("type").value("FeatureCollection");
            out.name("features");
            out.beginArray();
            for (Feature feature : value.features()) {
                this.featureAdapter.write(out, (Object)feature);
            }
            out.endArray();
            out.endObject();
        }
    }

    public FeatureCollection read(JsonReader in) throws IOException {
        FeatureCollection featureCollection = null;
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
        } else if (in.peek() == JsonToken.BEGIN_OBJECT) {
            in.beginObject();
            LinkedList<Feature> features = null;
            while (in.hasNext()) {
                String name = in.nextName();
                if ("features".equalsIgnoreCase(name)) {
                    in.beginArray();
                    features = new LinkedList<Feature>();
                    while (in.peek() == JsonToken.BEGIN_OBJECT) {
                        Feature feature = (Feature)this.gson.fromJson(in, Feature.class);
                        features.add(feature);
                    }
                    in.endArray();
                    continue;
                }
                in.skipValue();
            }
            if (features == null) {
                throw new IllegalArgumentException("Required field 'features' is missing");
            }
            featureCollection = new FeatureCollection(features);
            in.endObject();
        } else {
            throw new IllegalArgumentException("The given json is not a valid FeatureCollection: " + in.peek());
        }
        return featureCollection;
    }
}

