/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.codec;

import com.github.filosganga.geogson.codec.Codec;
import com.github.filosganga.geogson.model.Geometry;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CodecRegistry<T, S extends Geometry<?>>
implements Codec<T, S> {
    private final Map<Type, Codec<T, S>> codecsByS = new ConcurrentHashMap<Type, Codec<T, S>>();
    private final Map<Type, Codec<T, S>> codecsByT = new ConcurrentHashMap<Type, Codec<T, S>>();

    public CodecRegistry() {
        this(new ArrayList<Codec<? extends T, ? extends S>>());
    }

    public CodecRegistry(Iterable<Codec<? extends T, ? extends S>> codecs) {
        for (Codec<T, S> codec : codecs) {
            this.addCodec(codec);
        }
    }

    public void addCodec(Codec<? extends T, ? extends S> codec) {
        ParameterizedType type = (ParameterizedType)codec.getClass().getGenericSuperclass();
        Type t = type.getActualTypeArguments()[0];
        Type s = type.getActualTypeArguments()[1];
        this.codecsByS.put(s, codec);
        this.codecsByT.put(t, codec);
    }

    @Override
    public S toGeometry(T src) {
        return this.codecsByT.get(src.getClass()).toGeometry(src);
    }

    @Override
    public T fromGeometry(S src) {
        return this.codecsByS.get(src.getClass()).fromGeometry(src);
    }
}

