/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.mojo;

import com.github.eirslett.maven.plugins.frontend.lib.CorepackInstaller;
import com.github.eirslett.maven.plugins.frontend.lib.FrontendPluginFactory;
import com.github.eirslett.maven.plugins.frontend.lib.InstallationException;
import com.github.eirslett.maven.plugins.frontend.lib.NodeInstaller;
import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import com.github.eirslett.maven.plugins.frontend.mojo.AbstractFrontendMojo;
import com.github.eirslett.maven.plugins.frontend.mojo.MojoUtils;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.crypto.SettingsDecrypter;

@Mojo(name="install-node-and-corepack", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public final class InstallNodeAndCorepackMojo
extends AbstractFrontendMojo {
    @Parameter(property="nodeDownloadRoot", required=false)
    private String nodeDownloadRoot;
    @Parameter(property="corepackDownloadRoot", required=false, defaultValue="https://registry.npmjs.org/corepack/-/")
    private String corepackDownloadRoot;
    @Parameter(property="nodeVersion", required=true)
    private String nodeVersion;
    @Parameter(property="corepackVersion", required=false, defaultValue="provided")
    private String corepackVersion;
    @Parameter(property="serverId", defaultValue="")
    private String serverId;
    @Parameter(property="session", defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(property="skip.installnodecorepack", defaultValue="${skip.installnodecorepack}")
    private boolean skip;
    @Component(role=SettingsDecrypter.class)
    private SettingsDecrypter decrypter;

    @Override
    protected boolean skipExecution() {
        return this.skip;
    }

    @Override
    public void execute(FrontendPluginFactory factory) throws InstallationException {
        ProxyConfig proxyConfig = MojoUtils.getProxyConfig(this.session, this.decrypter);
        String resolvedNodeDownloadRoot = this.getNodeDownloadRoot();
        String resolvedCorepackDownloadRoot = this.getCorepackDownloadRoot();
        NodeInstaller nodeInstaller = factory.getNodeInstaller(proxyConfig);
        nodeInstaller.setNodeVersion(this.nodeVersion).setNodeDownloadRoot(resolvedNodeDownloadRoot);
        if ("provided".equals(this.corepackVersion)) {
            nodeInstaller.setNpmVersion("provided");
        }
        CorepackInstaller corepackInstaller = factory.getCorepackInstaller(proxyConfig);
        corepackInstaller.setCorepackVersion(this.corepackVersion).setCorepackDownloadRoot(resolvedCorepackDownloadRoot);
        Server server = MojoUtils.decryptServer(this.serverId, this.session, this.decrypter);
        if (null != server) {
            Map<String, String> httpHeaders = this.getHttpHeaders(server);
            nodeInstaller.setUserName(server.getUsername()).setPassword(server.getPassword()).setHttpHeaders(httpHeaders);
            corepackInstaller.setUserName(server.getUsername()).setPassword(server.getPassword()).setHttpHeaders(httpHeaders);
        }
        nodeInstaller.install();
        corepackInstaller.install();
    }

    private String getNodeDownloadRoot() {
        return this.nodeDownloadRoot;
    }

    private String getCorepackDownloadRoot() {
        return this.corepackDownloadRoot;
    }
}

