/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.web.job;

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.persistence.entities.AttachmentImpl;
import com.franciaflex.faxtomail.persistence.entities.Client;
import com.franciaflex.faxtomail.persistence.entities.DemandStatus;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.EmailAccount;
import com.franciaflex.faxtomail.persistence.entities.EmailImpl;
import com.franciaflex.faxtomail.persistence.entities.EmailProtocol;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.services.DecoratorService;
import com.franciaflex.faxtomail.services.FaxToMailServiceContext;
import com.franciaflex.faxtomail.services.service.ClientService;
import com.franciaflex.faxtomail.services.service.ConfigurationService;
import com.franciaflex.faxtomail.services.service.EmailService;
import com.franciaflex.faxtomail.services.service.MailFolderService;
import com.franciaflex.faxtomail.web.job.AbstractFaxToMailJob;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class MailFilterJob
extends AbstractFaxToMailJob {
    private static final Log log = LogFactory.getLog(MailFilterJob.class);
    protected FaxToMailServiceContext serviceContext;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        this.serviceContext = this.getServiceContext(jobExecutionContext);
        ConfigurationService configurationService = (ConfigurationService)this.serviceContext.newService(ConfigurationService.class);
        List emailAccounts = configurationService.getEmailAccounts();
        for (EmailAccount account : emailAccounts) {
            if (account.getProtocol() != EmailProtocol.POP3) continue;
            this.checkEmailsOnPop3(account);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkEmailsOnPop3(EmailAccount account) {
        Properties properties = new Properties();
        properties.setProperty("mail.store.protocol", "pop3");
        properties.setProperty("mail.pop3.host", account.getHost());
        properties.setProperty("mail.pop3.user", account.getLogin());
        properties.setProperty("mail.pop3.port", String.valueOf(account.getPort()));
        Session session = Session.getInstance((Properties)properties);
        Store store = null;
        Folder defaultFolder = null;
        Folder inbox = null;
        try {
            store = session.getStore(new URLName("pop3://" + account.getHost()));
            store.connect(account.getLogin(), account.getPassword());
            defaultFolder = store.getDefaultFolder();
            inbox = defaultFolder.getFolder("INBOX");
            this.checkEmailsOfFolder(inbox);
            this.close(inbox);
        }
        catch (Exception e) {
            log.error((Object)"Error while getting emails from the mailbox", (Throwable)e);
            return;
        }
        this.close(defaultFolder);
        try {
            if (store == null) return;
            if (!store.isConnected()) return;
            store.close();
            return;
        }
        catch (MessagingException e) {
            log.error((Object)"Error while closing the store", (Throwable)e);
            return;
        }
        finally {
            this.close(inbox);
            this.close(defaultFolder);
            try {
                if (store != null && store.isConnected()) {
                    store.close();
                }
            }
            catch (MessagingException e) {
                log.error((Object)"Error while closing the store", (Throwable)e);
            }
        }
    }

    protected void close(Folder folder) {
        if (folder != null && folder.isOpen()) {
            try {
                folder.close(false);
            }
            catch (Exception e) {
                log.error((Object)"Error while closing the folder", (Throwable)e);
            }
        }
    }

    protected void checkEmailsOfFolder(Folder folder) {
        try {
            folder.open(2);
            int count = folder.getMessageCount();
            int unread = folder.getUnreadMessageCount();
            log.debug((Object)(count + " messages, " + unread + " unread"));
            EmailService emailService = (EmailService)this.serviceContext.newService(EmailService.class);
            for (int i = 0; i < count; ++i) {
                Date receivedDate;
                Address[] ccRecipients;
                EmailImpl email = new EmailImpl();
                int messageNumber = count - i;
                Message message = folder.getMessage(messageNumber);
                Charset charset = this.getCharset((Part)message);
                ArrayList<String> modifiedProperties = new ArrayList<String>();
                ArrayList<Address> recipients = new ArrayList<Address>();
                Address[] toRecipients = message.getRecipients(Message.RecipientType.TO);
                if (toRecipients != null) {
                    recipients.addAll(Arrays.asList(toRecipients));
                }
                if ((ccRecipients = message.getRecipients(Message.RecipientType.CC)) != null) {
                    recipients.addAll(Arrays.asList(ccRecipients));
                }
                for (Address address : recipients) {
                    String recipient = address.toString();
                    MailFolder mailFolder = ((MailFolderService)this.serviceContext.newService(MailFolderService.class)).getFolderForRecipient(recipient);
                    if (mailFolder == null) continue;
                    log.debug((Object)("\tTo : " + address + " -> " + (mailFolder != null ? mailFolder.getName() : "none")));
                    email.setRecipient(recipient);
                    email.setMailFolder(mailFolder);
                    modifiedProperties.add("recipient");
                    modifiedProperties.add("mailFolder");
                    break;
                }
                if (email.getMailFolder() == null) continue;
                emailService.saveEmail((Email)email, null, new String[0]);
                Address[] addresses = message.getFrom();
                if (addresses != null && addresses.length > 0) {
                    String sender = addresses[0].toString();
                    email.setSender(sender);
                    modifiedProperties.add("sender");
                    Client client = ((ClientService)this.serviceContext.newService(ClientService.class)).getClientForEmailAddress(sender, email.getMailFolder());
                    if (client != null) {
                        String object = client.getCaracteristic1() + " / " + client.getCode() + " / " + client.getName() + " / " + client.getFaxNumber() + " / " + DateFormat.getDateInstance(2).format(new Date());
                        email.setObject(object);
                        modifiedProperties.add("object");
                        modifiedProperties.add("client");
                    }
                    email.setClient(client);
                }
                if ((receivedDate = message.getReceivedDate()) == null) {
                    receivedDate = message.getSentDate();
                }
                email.setReceptionDate(receivedDate);
                modifiedProperties.add("receptionDate");
                Date now = new Date();
                DecoratorService decoratorService = (DecoratorService)this.serviceContext.newService(DecoratorService.class);
                Decorator dateDecorator = decoratorService.getDecoratorByType(Date.class, "date");
                String projectRef = I18n.t((String)"faxtomail.email.projectReference.default", (Object[])new Object[]{dateDecorator.toString((Object)now)});
                email.setProjectReference(projectRef);
                modifiedProperties.add("projectReference");
                email.setDemandStatus(DemandStatus.UNTREATED);
                modifiedProperties.add("demandStatus");
                StringBuilder emailSource = new StringBuilder();
                Enumeration headerLines = ((MimeMessage)message).getAllHeaderLines();
                while (headerLines.hasMoreElements()) {
                    String headerLine = (String)headerLines.nextElement();
                    emailSource.append(headerLine).append("\n");
                }
                String originalContent = IOUtils.toString((InputStream)message.getInputStream(), (Charset)charset);
                emailSource.append("\n").append(originalContent);
                email.setOriginalEmail(emailSource.toString());
                ArrayList attachements = new ArrayList();
                if (message.isMimeType("multipart/*")) {
                    this.decomposeMultipartEmail(attachements, (Part)message, (Email)email, emailService);
                }
                emailService.saveEmail((Email)email, attachements, email.getClient() != null ? email.getClient().getCode() : null, null, modifiedProperties.toArray(new String[modifiedProperties.size()]));
                message.setFlag(Flags.Flag.DELETED, true);
            }
            log.debug((Object)"End of emails");
        }
        catch (Exception e) {
            log.error((Object)"Error while reading the emails", (Throwable)e);
        }
    }

    protected void decomposeMultipartEmail(List<Attachment> attachments, Part part, Email email, EmailService emailService) throws Exception {
        DataSource dataSource = part.getDataHandler().getDataSource();
        MimeMultipart mimeMultipart = new MimeMultipart(dataSource);
        int multiPartCount = mimeMultipart.getCount();
        for (int j = 0; j < multiPartCount; ++j) {
            String fileName;
            BodyPart bp;
            block6: {
                bp = mimeMultipart.getBodyPart(j);
                Charset charset = this.getCharset((Part)bp);
                String disposition = bp.getDisposition();
                if (bp.isMimeType("text/*") && !"attachment".equals(disposition)) continue;
                if (bp.isMimeType("multipart/*")) {
                    this.decomposeMultipartEmail(attachments, (Part)bp, email, emailService);
                    continue;
                }
                fileName = bp.getFileName();
                if (fileName == null) {
                    String[] headers = bp.getHeader("Content-ID");
                    if (headers == null) break;
                    fileName = headers[0];
                    fileName = fileName.replaceFirst("^<(.*)>$", "$1");
                }
                try {
                    fileName = MimeUtility.decodeText((String)fileName);
                    log.debug((Object)("FileName : " + fileName));
                }
                catch (UnsupportedEncodingException ex) {
                    if (!log.isWarnEnabled()) break block6;
                    log.warn((Object)"Can't debug email file name", (Throwable)ex);
                }
            }
            File dir = new File(FileUtils.getTempDirectory(), email.getTopiaId());
            if (!dir.exists()) {
                dir.mkdir();
            }
            File file = new File(dir, fileName);
            FileOutputStream fos = new FileOutputStream(file);
            DataHandler dh = bp.getDataHandler();
            dh.writeTo((OutputStream)fos);
            AttachmentImpl attachment = new AttachmentImpl();
            attachment.setAddedByUser(false);
            AttachmentFile attachmentFile = emailService.getAttachmentFileFromStream(dh.getInputStream());
            attachmentFile.setFilename(fileName);
            attachment.setOriginalFile(attachmentFile);
            attachments.add((Attachment)attachment);
        }
    }

    protected Charset getCharset(Part part) throws MessagingException {
        ContentType contentType = new ContentType(part.getContentType());
        String charsetName = contentType.getParameter("charset");
        Charset charset = Charsets.toCharset((String)charsetName);
        return charset;
    }
}

