/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.web;

import com.franciaflex.faxtomail.FaxToMailApplicationContext;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailTopiaPersistenceContext;
import com.franciaflex.faxtomail.services.FaxToMailServiceContext;
import com.franciaflex.faxtomail.services.service.InitFaxToMailService;
import com.franciaflex.faxtomail.web.job.EDIManagementJob;
import com.franciaflex.faxtomail.web.job.MailFilterJob;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class FaxToMailApplicationListener
implements ServletContextListener {
    private static final Log log = LogFactory.getLog(FaxToMailApplicationListener.class);
    protected FaxToMailApplicationContext applicationContext;
    protected Scheduler scheduler;

    public void contextInitialized(ServletContextEvent sce) {
        if (log.isInfoEnabled()) {
            log.info((Object)"init FaxToMail web ui");
        }
        log.debug((Object)"scheduler launched");
        this.applicationContext = new FaxToMailApplicationContext();
        this.applicationContext.init();
        sce.getServletContext().setAttribute("faxToMailApplicationContext", (Object)this.applicationContext);
        JobDataMap data = new JobDataMap();
        FaxToMailTopiaPersistenceContext persistenceContext = this.applicationContext.newPersistenceContext();
        FaxToMailServiceContext serviceContext = this.applicationContext.newServiceContext(persistenceContext);
        ((InitFaxToMailService)serviceContext.newService(InitFaxToMailService.class)).init();
        data.put("serviceContext", (Object)serviceContext);
        JobDetail mailFilteringJob = JobBuilder.newJob(MailFilterJob.class).usingJobData(data).withIdentity("faxToMailJobs", "mailFilteringJob").build();
        JobDetail ediManagementJob = JobBuilder.newJob(EDIManagementJob.class).usingJobData(data).withIdentity("faxToMailJobs", "ediManagementJob").build();
        try {
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity("mailFiltering", "mailFilteringTrigger").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)"0 0/20 * * * ?")).build();
            Scheduler scheduler = new StdSchedulerFactory().getScheduler();
            scheduler.start();
            scheduler.scheduleJob(mailFilteringJob, trigger);
            trigger = TriggerBuilder.newTrigger().withIdentity("ediManagement", "ediManagementTrigger").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)"0 0 0/5 * * ?")).build();
            scheduler = new StdSchedulerFactory().getScheduler();
            scheduler.start();
            scheduler.scheduleJob(ediManagementJob, trigger);
            log.debug((Object)"schedulers launched");
        }
        catch (SchedulerException e) {
            log.error((Object)"Error while launching the mail filter job", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        block5: {
            if (this.scheduler != null) {
                if (log.isInfoEnabled() && log.isInfoEnabled()) {
                    log.info((Object)"Stopping quartz sheduler");
                }
                try {
                    this.scheduler.shutdown();
                }
                catch (SchedulerException e) {
                    if (!log.isWarnEnabled()) break block5;
                    log.warn((Object)"Can't stop quartz", (Throwable)e);
                }
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"Closing web ui application context");
        }
        this.applicationContext.close();
    }
}

