/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.xml.mocker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.source.annotations.xml.filter.IndexedAnnotationFilter;
import org.hibernate.metamodel.source.annotations.xml.mocker.DefaultConfigurationHelper;
import org.hibernate.metamodel.source.annotations.xml.mocker.EntityMappingsMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.GlobalAnnotations;
import org.hibernate.metamodel.source.annotations.xml.mocker.MockHelper;
import org.hibernate.service.ServiceRegistry;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.logging.Logger;

public class IndexBuilder {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)IndexBuilder.class.getName());
    private Map<DotName, List<AnnotationInstance>> annotations;
    private Map<DotName, List<ClassInfo>> subclasses;
    private Map<DotName, List<ClassInfo>> implementors;
    private Map<DotName, ClassInfo> classes;
    private Index index;
    private Map<DotName, Map<DotName, List<AnnotationInstance>>> classInfoAnnotationsMap;
    private Map<DotName, Map<DotName, List<AnnotationInstance>>> indexedClassInfoAnnotationsMap;
    private ServiceRegistry serviceRegistry;

    IndexBuilder(Index index, ServiceRegistry serviceRegistry) {
        this.index = index;
        this.serviceRegistry = serviceRegistry;
        this.annotations = new HashMap<DotName, List<AnnotationInstance>>();
        this.subclasses = new HashMap<DotName, List<ClassInfo>>();
        this.implementors = new HashMap<DotName, List<ClassInfo>>();
        this.classes = new HashMap<DotName, ClassInfo>();
        this.classInfoAnnotationsMap = new HashMap<DotName, Map<DotName, List<AnnotationInstance>>>();
        this.indexedClassInfoAnnotationsMap = new HashMap<DotName, Map<DotName, List<AnnotationInstance>>>();
    }

    Index build(EntityMappingsMocker.Default globalDefaults) {
        for (ClassInfo ci : this.index.getKnownClasses()) {
            DotName name = ci.name();
            if (this.indexedClassInfoAnnotationsMap.containsKey(name) || ci.annotations() == null || ci.annotations().isEmpty()) continue;
            HashMap<DotName, List<AnnotationInstance>> tmp = new HashMap<DotName, List<AnnotationInstance>>(ci.annotations());
            DefaultConfigurationHelper.INSTANCE.applyDefaults(tmp, globalDefaults);
            this.mergeAnnotationMap(tmp, this.annotations);
            this.classes.put(name, ci);
            if (ci.superName() != null) {
                this.addSubClasses(ci.superName(), ci);
            }
            if (ci.interfaces() == null || ci.interfaces().length <= 0) continue;
            this.addImplementors(ci.interfaces(), ci);
        }
        return Index.create(this.annotations, this.subclasses, this.implementors, this.classes);
    }

    Map<DotName, List<AnnotationInstance>> getAnnotations() {
        return Collections.unmodifiableMap(this.annotations);
    }

    void mappingMetadataComplete() {
        LOG.debug("xml-mapping-metadata-complete is specified in persistence-unit-metadata, ignore JPA annotations.");
        this.index = Index.create(new HashMap(), new HashMap(), new HashMap(), new HashMap());
    }

    void metadataComplete(DotName name) {
        LOG.debug("metadata-complete is specified in " + name + ", ignore JPA annotations.");
        this.getIndexedAnnotations(name).clear();
    }

    public Map<DotName, List<AnnotationInstance>> getIndexedAnnotations(DotName name) {
        Map<Object, List<Object>> map = this.indexedClassInfoAnnotationsMap.get(name);
        if (map == null) {
            ClassInfo ci = this.index.getClassByName(name);
            if (ci == null || ci.annotations() == null) {
                map = Collections.emptyMap();
            } else {
                map = new HashMap<DotName, List<AnnotationInstance>>(ci.annotations());
                for (DotName globalAnnotationName : DefaultConfigurationHelper.GLOBAL_ANNOTATIONS) {
                    if (!map.containsKey(globalAnnotationName)) continue;
                    map.put(globalAnnotationName, Collections.emptyList());
                }
            }
            this.indexedClassInfoAnnotationsMap.put(name, map);
        }
        return map;
    }

    public Map<DotName, List<AnnotationInstance>> getClassInfoAnnotationsMap(DotName name) {
        return this.classInfoAnnotationsMap.get(name);
    }

    public ClassInfo getClassInfo(DotName name) {
        return this.classes.get(name);
    }

    public ClassInfo getIndexedClassInfo(DotName name) {
        return this.index.getClassByName(name);
    }

    void collectGlobalConfigurationFromIndex(GlobalAnnotations globalAnnotations) {
        for (DotName annName : DefaultConfigurationHelper.GLOBAL_ANNOTATIONS) {
            List annotationInstanceList = this.index.getAnnotations(annName);
            if (!MockHelper.isNotEmpty(annotationInstanceList)) continue;
            globalAnnotations.addIndexedAnnotationInstance(annotationInstanceList);
        }
        globalAnnotations.filterIndexedAnnotations();
    }

    void finishGlobalConfigurationMocking(GlobalAnnotations globalAnnotations) {
        this.annotations.putAll(globalAnnotations.getAnnotationInstanceMap());
    }

    void finishEntityObject(DotName name, EntityMappingsMocker.Default defaults) {
        Map<DotName, List<AnnotationInstance>> map = this.classInfoAnnotationsMap.get(name);
        if (map == null) {
            throw new AssertionFailure("Calling finish entity object " + name + " before create it.");
        }
        if (this.indexedClassInfoAnnotationsMap.containsKey(name)) {
            Map<DotName, List<AnnotationInstance>> tmp = this.getIndexedAnnotations(name);
            this.mergeAnnotationMap(tmp, map);
        }
        DefaultConfigurationHelper.INSTANCE.applyDefaults(map, defaults);
        this.mergeAnnotationMap(map, this.annotations);
    }

    void addAnnotationInstance(DotName targetClassName, AnnotationInstance annotationInstance) {
        if (annotationInstance == null) {
            return;
        }
        for (IndexedAnnotationFilter indexedAnnotationFilter : IndexedAnnotationFilter.ALL_FILTERS) {
            indexedAnnotationFilter.beforePush(this, targetClassName, annotationInstance);
        }
        Map<DotName, List<AnnotationInstance>> map = this.classInfoAnnotationsMap.get(targetClassName);
        if (map == null) {
            throw new AssertionFailure("Can't find " + targetClassName + " in internal cache, should call createClassInfo first");
        }
        List<AnnotationInstance> annotationInstanceList = map.get(annotationInstance.name());
        if (annotationInstanceList == null) {
            annotationInstanceList = new ArrayList<AnnotationInstance>();
            map.put(annotationInstance.name(), annotationInstanceList);
        }
        annotationInstanceList.add(annotationInstance);
    }

    ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    ClassInfo createClassInfo(String className) {
        short access_flag;
        if (StringHelper.isEmpty(className)) {
            throw new AssertionFailure("Class Name used to create ClassInfo is empty.");
        }
        DotName classDotName = DotName.createSimple((String)className);
        if (this.classes.containsKey(classDotName)) {
            return this.classes.get(classDotName);
        }
        Class clazz = this.serviceRegistry.getService(ClassLoaderService.class).classForName(className);
        DotName superName = null;
        DotName[] interfaces = null;
        ClassInfo annClassInfo = this.index.getClassByName(classDotName);
        if (annClassInfo != null) {
            superName = annClassInfo.superName();
            interfaces = annClassInfo.interfaces();
            access_flag = annClassInfo.flags();
        } else {
            Class<?>[] classInterfaces;
            Class superClass = clazz.getSuperclass();
            if (superClass != null) {
                superName = DotName.createSimple((String)superClass.getName());
            }
            if ((classInterfaces = clazz.getInterfaces()) != null && classInterfaces.length > 0) {
                interfaces = new DotName[classInterfaces.length];
                for (int i = 0; i < classInterfaces.length; ++i) {
                    interfaces[i] = DotName.createSimple((String)classInterfaces[i].getName());
                }
            }
            access_flag = (short)(clazz.getModifiers() | 0x20);
        }
        HashMap map = new HashMap();
        this.classInfoAnnotationsMap.put(classDotName, map);
        ClassInfo classInfo = ClassInfo.create((DotName)classDotName, (DotName)superName, (short)access_flag, (DotName[])interfaces, map);
        this.classes.put(classDotName, classInfo);
        this.addSubClasses(superName, classInfo);
        this.addImplementors(interfaces, classInfo);
        return classInfo;
    }

    private void addSubClasses(DotName superClassDotName, ClassInfo classInfo) {
        if (superClassDotName != null) {
            List<ClassInfo> classInfoList = this.subclasses.get(superClassDotName);
            if (classInfoList == null) {
                classInfoList = new ArrayList<ClassInfo>();
                this.subclasses.put(superClassDotName, classInfoList);
            }
            classInfoList.add(classInfo);
        }
    }

    private void addImplementors(DotName[] dotNames, ClassInfo classInfo) {
        if (dotNames != null && dotNames.length > 0) {
            for (DotName dotName : dotNames) {
                List<ClassInfo> classInfoList = this.implementors.get(dotName);
                if (classInfoList == null) {
                    classInfoList = new ArrayList<ClassInfo>();
                    this.implementors.put(dotName, classInfoList);
                }
                classInfoList.add(classInfo);
            }
        }
    }

    private void mergeAnnotationMap(Map<DotName, List<AnnotationInstance>> source, Map<DotName, List<AnnotationInstance>> target) {
        if (source != null) {
            for (Map.Entry<DotName, List<AnnotationInstance>> el : source.entrySet()) {
                if (el.getValue().isEmpty()) continue;
                DotName annotationName = el.getKey();
                List<AnnotationInstance> value = el.getValue();
                List<AnnotationInstance> annotationInstanceList = target.get(annotationName);
                if (annotationInstanceList == null) {
                    annotationInstanceList = new ArrayList<AnnotationInstance>();
                    target.put(annotationName, annotationInstanceList);
                }
                annotationInstanceList.addAll(value);
            }
        }
    }
}

