/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.services.service;

import com.franciaflex.faxtomail.persistence.entities.Client;
import com.franciaflex.faxtomail.persistence.entities.ClientTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.services.FaxToMailServiceSupport;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientService
extends FaxToMailServiceSupport {
    private static final Log log = LogFactory.getLog(ClientService.class);

    public Client getClientForEmailAddress(String emailAddress, MailFolder folder) {
        ClientTopiaDao clientDao = this.getPersistenceContext().getClientDao();
        Client client = null;
        if (StringUtils.isNotBlank((CharSequence)emailAddress)) {
            List clients = clientDao.forEmailAddressEquals(emailAddress).findAll();
            if (CollectionUtils.isEmpty((Collection)clients)) {
                clients = clientDao.forFaxNumberEquals(emailAddress).findAll();
            }
            if (CollectionUtils.isNotEmpty((Collection)clients)) {
                if (clients.size() == 1) {
                    client = (Client)clients.get(0);
                } else if (folder != null) {
                    ImmutableListMultimap clientsByBrand = Multimaps.index((Iterable)clients, (Function)new Function<Client, String>(){

                        public String apply(Client client) {
                            return client.getBrand();
                        }
                    });
                    Set brands = clientsByBrand.keySet();
                    while (client == null && folder != null) {
                        if (brands.contains(folder.getName())) {
                            client = (Client)new ArrayList(clientsByBrand.get((Object)folder.getName())).get(0);
                        }
                        folder = folder.getParent();
                    }
                }
            }
        }
        return client;
    }

    public Client getClientForCode(String code) {
        ClientTopiaDao clientDao = this.getPersistenceContext().getClientDao();
        Client client = null;
        if (StringUtils.isNotBlank((CharSequence)code)) {
            client = (Client)clientDao.forCodeEquals(code).findAnyOrNull();
        }
        return client;
    }
}

