package com.franciaflex.faxtomail.ui.swing.content.demande.demandgroup;

/*
 * #%L
 * FaxToMail :: UI
 * $Id: DemandGroupUIHandler.java 68 2014-05-12 20:23:24Z kmorin $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.1/faxtomail-ui-swing/src/main/java/com/franciaflex/faxtomail/ui/swing/content/demande/demandgroup/DemandGroupUIHandler.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.ui.swing.FaxToMailScreen;
import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.actions.ShowDemandeAction;
import com.franciaflex.faxtomail.ui.swing.content.MainUI;
import com.franciaflex.faxtomail.ui.swing.content.MainUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandesUI;
import com.franciaflex.faxtomail.ui.swing.util.AbstractToolbarPopupHandler;
import com.google.common.collect.Iterables;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;

import javax.swing.*;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import java.awt.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import static org.nuiton.i18n.I18n.t;

/**
 * @author Kevin Morin (Code Lutin)
 * @since x.x
 */
public class DemandGroupUIHandler extends AbstractToolbarPopupHandler<DemandeUIModel, DemandGroupUI> {

    private final static Log log = LogFactory.getLog(DemandGroupUIHandler.class);

    @Override
    public void beforeInit(DemandGroupUI ui) {
        super.beforeInit(ui);

        DemandeUIModel currentEmail = getContext().getCurrentEmail();
        this.ui.setContextValue(currentEmail);
    }

    @Override
    public void afterInit(DemandGroupUI ui) {
        super.afterInit(ui);

        initTable(ui.getDemandGroup());

        getModel().addPropertyChangeListener(DemandeUIModel.PROPERTY_GROUPED_DEMANDES, new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AbstractTableModel tableModel = (AbstractTableModel) getUI().getDemandGroup().getModel();
                tableModel.fireTableDataChanged();
            }
        });
    }

    protected void initTable(JXTable table) {

        TableModel demandGroupTableModel = new AbstractTableModel() {
            @Override
            public int getRowCount() {
                return getModel().sizeGroupedDemandes() + 1;
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (rowIndex == 0) {
                    return getModel();
                }
                return Iterables.get(getModel().getGroupedDemandes(), rowIndex - 1);
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return true;
            }
        };

        demandGroupTableModel.addTableModelListener(new TableModelListener() {
            @Override
            public void tableChanged(TableModelEvent e) {
                getUI().pack();
            }
        });

        TableColumnModel columnModel = new DefaultTableColumnModel();
        TableColumn column = new TableColumn();
        column.setCellRenderer(new DemandGroupItemRenderer());
        column.setCellEditor(new DemandGroupItemEditor());
        columnModel.addColumn(column);

        table.setModel(demandGroupTableModel);
        table.setColumnModel(columnModel);
        table.addHighlighter(HighlighterFactory.createAlternateStriping());
    }

    @Override
    public void onCloseUI() {
    }

    @Override
    public SwingValidator<DemandeUIModel> getValidator() {
        return null;
    }

    @Override
    protected JComponent getComponentToFocus() {
        return null;
    }

    public void openDemande(DemandeUIModel demande) {
        closeEditor();

        FaxToMailUIContext context = getContext();
        demande.setCloseable(true);
//        context.setCurrentEmail(demande);
//        context.getActionEngine().runAction(new ShowDemandeAction(context.getMainUI().getHandler()));

        FaxToMailUser takenBy = demande.getTakenBy();
        FaxToMailUser currentUser = getContext().getCurrentUser();

        //TODO kmorin 20140512 put this in an action
        if (demande.getArchiveDate() != null) {
            demande.setEditable(false);

        } else if (takenBy != null && !currentUser.equals(takenBy)) {
            String htmlMessage = String.format(
                    AbstractApplicationUIHandler.CONFIRMATION_FORMAT,
                    t("faxtomail.alert.alreadyTakenBy.message", decorate(takenBy)),
                    t("faxtomail.alert.alreadyTakenBy.help"));

            int result = JOptionPane.showConfirmDialog(getTopestUI(),
                                                       htmlMessage,
                                                       t("faxtomail.alert.alreadyTakenBy.title"),
                                                       JOptionPane.YES_NO_CANCEL_OPTION,
                                                       JOptionPane.QUESTION_MESSAGE);

            switch (result) {
                case JOptionPane.CANCEL_OPTION:
                    return;

                case JOptionPane.NO_OPTION:
                    demande.setEditable(false);
                    break;

                case JOptionPane.YES_OPTION:
                    Email email = getContext().getEmailService().takeEmail(demande.getTopiaId(), currentUser);
                    demande.fromEntity(email);
                    demande.setEditable(true);
                    break;
            }
        }

        MainUIHandler mainUIHandler = context.getMainUI().getHandler();
        DemandesUI parentContainer = (DemandesUI) mainUIHandler.getCurrentBody();
        parentContainer.getModel().addDemand(demande);
    }

    protected class DemandGroupItemRenderer extends DemandGroupItem
                                            implements TableCellRenderer {

        public DemandGroupItemRenderer() {
            super(DemandGroupUIHandler.this);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value,
                                                       boolean isSelected, boolean hasFocus, int row, int column) {
            DemandeUIModel demand = (DemandeUIModel) value;
            setDemande(demand);
            return this;
        }
    }

    protected class DemandGroupItemEditor extends AbstractCellEditor implements TableCellEditor {

        protected DemandGroupItem demandGroupItem;

        public DemandGroupItemEditor() {
            demandGroupItem = new DemandGroupItem(DemandGroupUIHandler.this);
        }

        public Component getTableCellEditorComponent(JTable table, Object value,
                                                     boolean isSelected, int row, int column) {
            DemandeUIModel demand = (DemandeUIModel) value;
            demandGroupItem.setDemande(demand);

            return demandGroupItem;
        }

        @Override
        public Object getCellEditorValue() {
            return demandGroupItem.getDemande();
        }

        public boolean stopCellEditing() {
            return super.stopCellEditing();
        }

        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }
    }
}
