package com.franciaflex.faxtomail.services;

/*
 * #%L
 * FaxToMail :: Service
 * $Id: DecoratorService.java 82 2014-05-20 14:25:32Z echatellier $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.1/faxtomail-service/src/main/java/com/franciaflex/faxtomail/services/DecoratorService.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.text.DateFormat;
import java.util.Date;

import org.nuiton.decorator.Decorator;
import org.nuiton.decorator.DecoratorProvider;

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.HasLabel;
import com.franciaflex.faxtomail.persistence.entities.Reply;

/**
 * FaxToMail decorator service.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class DecoratorService extends FaxToMailServiceSupport {

    public static final String SEPARATOR = "#";

    public static final String DATE = "date";

    /** Delegate decorator provider. */
    protected DecoratorProvider decoratorProvider;

    public <O> Decorator<O> getDecorator(O object) {
        return decoratorProvider.getDecorator(object);
    }

    public <O> Decorator<O> getDecorator(O object, String name) {
        return decoratorProvider.getDecorator(object, name);
    }

    public <O> Decorator<O> getDecoratorByType(Class<O> type) {
        return decoratorProvider.getDecoratorByType(type);
    }

    public <O> Decorator<O> getDecoratorByType(Class<O> type, String name) {
        return decoratorProvider.getDecoratorByType(type, name);
    }

    @Override
    public void setServiceContext(FaxToMailServiceContext context) {
        super.setServiceContext(context);

        decoratorProvider = new DecoratorProvider() {
            @Override
            protected void loadDecorators() {

                registerDecorator(new Decorator<Float>(Float.class) {
                    private static final long serialVersionUID = 1L;

                    @Override
                    public String toString(Object bean) {
                        return bean == null ? "" : String.valueOf(bean);
                    }
                });
                registerDecorator(new Decorator<Number>(Number.class) {
                    private static final long serialVersionUID = 1L;

                    @Override
                    public String toString(Object bean) {
                        return bean == null ? "" : String.valueOf(bean);
                    }
                });
                registerDecorator(new Decorator<Date>(Date.class) {
                    private static final long serialVersionUID = 1L;

                    @Override
                    public String toString(Object bean) {
                        if (bean == null) {
                            return "";
                        }
                        return DateFormat.getDateTimeInstance(DateFormat.SHORT, DateFormat.SHORT).format(bean);
                    }
                });
                registerDecorator(DATE, new Decorator<Date>(Date.class) {
                    private static final long serialVersionUID = 1L;

                    @Override
                    public String toString(Object bean) {
                        if (bean == null) {
                            return "";
                        }
                        return DateFormat.getDateInstance(DateFormat.MEDIUM).format(bean);
                    }
                });
                /*registerDecorator(new Decorator<File>(File.class) {
                    private static final long serialVersionUID = 1L;

                    @Override
                    public String toString(Object bean) {
                        if (bean == null) {
                            return "";
                        }
                        return ((File) bean).getName();
                    }
                });*/
                /*registerDecorator(new Decorator<AttachmentFile>(AttachmentFile.class) {
                    private static final long serialVersionUID = 1L;

                    @Override
                    public String toString(Object bean) {
                        if (bean == null) {
                            return "";
                        }
                        return ((AttachmentFile) bean).getFilename();
                    }
                });*/
                registerMultiJXPathDecorator(HasLabel.class, "${label}$s", SEPARATOR, " - ");
                //registerMultiJXPathDecorator(Attachment.class, "${originalFile}$s", SEPARATOR, " - ");
                registerDecorator(new Decorator<Attachment>(Attachment.class) {
                    private static final long serialVersionUID = 1L;

                    @Override
                    public String toString(Object bean) {
                        if (bean == null) {
                            return "";
                        }
                        return ((Attachment) bean).getOriginalFile().getFilename();
                    }
                });
                registerDecorator(new Decorator<AttachmentFile>(AttachmentFile.class) {
                    private static final long serialVersionUID = 1L;

                    @Override
                    public String toString(Object bean) {
                        if (bean == null) {
                            return "";
                        }
                        return ((AttachmentFile) bean).getFilename();
                    }
                });
                registerMultiJXPathDecorator(Reply.class, "${sentDate}$s#${subject}$s", SEPARATOR, " - ");
                registerMultiJXPathDecorator(FaxToMailUser.class, "${trigraph}$s#${firstName}$s#${lastName}$s", SEPARATOR, " ");
            }
        };
    }
}
