package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Thu Sep 17 12:43:41 CEST 2015")
public abstract class EmailGroupAbstract extends AbstractTopiaEntity implements EmailGroup {

    /**
     * Nom de l'attribut en BD : email
     */
    protected Set<Email> email;

    private static final long serialVersionUID = 7075266499924539238L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_EMAIL, Set.class, Email.class, email);
    }

    @Override
    public void addEmail(Email email) {
        if (this.email == null) {
            this.email = new HashSet<Email>();
        }
        email.setEmailGroup(this);
        this.email.add(email);
    }

    @Override
    public void addAllEmail(Set<Email> email) {
        if (email == null) {
            return;
        }
        for (Email item : email) {
            addEmail(item);
        }
    }

    @Override
    public void setEmail(Set<Email> email) {
        this.email = email;
    }

    @Override
    public void removeEmail(Email email) {
        if (this.email == null || !this.email.remove(email)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        email.setEmailGroup(null);
    }

    @Override
    public void clearEmail() {
        if (this.email == null) {
            return;
        }
        for (Email item : this.email) {
            item.setEmailGroup(null);
        }
        this.email.clear();
    }

    @Override
    public Set<Email> getEmail() {
        return email;
    }

    @Override
    public Email getEmailByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(email, topiaId);
    }

    @Override
    public Set<String> getEmailTopiaIds() {
        Set<String> topiaIds = new HashSet<String>();
        Set<com.franciaflex.faxtomail.persistence.entities.Email> tmp = getEmail();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeEmail() {
        if (email == null) {
            return 0;
        }
        return email.size();
    }

    @Override
    public boolean isEmailEmpty() {
        int size = sizeEmail();
        return size == 0;
    }

    @Override
    public boolean isEmailNotEmpty() {
        boolean empty = isEmailEmpty();
        return ! empty;
    }

    @Override
    public boolean containsEmail(Email email) {
        boolean contains = this.email !=null && this.email.contains(email);
        return contains;
    }

} //EmailGroupAbstract
