/* The following code was generated by JFlex 1.4.1 on 1/21/09 4:27 PM */

/*
 * 11/13/2004
 *
 * CSharpTokenMaker.java - An object that can take a chunk of text and return
 * a linked list of tokens representing it in the C# programming language.
 * 
 * This library is distributed under a modified BSD license.  See the included
 * RSyntaxTextArea.License.txt file for details.
 */
package org.fife.ui.rsyntaxtextarea.modes;

import java.io.*;
import javax.swing.text.Segment;

import org.fife.ui.rsyntaxtextarea.*;


/**
 * A lexer for the C# programming language.
 *
 * This implementation was created using
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1; however, the generated file
 * was modified for performance.  Memory allocation needs to be almost
 * completely removed to be competitive with the handwritten lexers (subclasses
 * of <code>AbstractTokenMaker</code>, so this class has been modified so that
 * Strings are never allocated (via yytext()), and the scanner never has to
 * worry about refilling its buffer (needlessly copying chars around).
 * We can achieve this because RText always scans exactly 1 line of tokens at a
 * time, and hands the scanner this line as an array of characters (a Segment
 * really).  Since tokens contain pointers to char arrays instead of Strings
 * holding their contents, there is no need for allocating new memory for
 * Strings.<p>
 *
 * The actual algorithm generated for scanning has, of course, not been
 * modified.<p>
 *
 * If you wish to regenerate this file yourself, keep in mind the following:
 * <ul>
 *   <li>The generated CSharpTokenMaker.java</code> file will contain two
 *       definitions of both <code>zzRefill</code> and <code>yyreset</code>.
 *       You should hand-delete the second of each definition (the ones
 *       generated by the lexer), as these generated methods modify the input
 *       buffer, which we'll never have to do.</li>
 *   <li>You should also change the declaration/definition of zzBuffer to NOT
 *       be initialized.  This is a needless memory allocation for us since we
 *       will be pointing the array somewhere else anyway.</li>
 *   <li>You should NOT call <code>yylex()</code> on the generated scanner
 *       directly; rather, you should use <code>getTokenList</code> as you would
 *       with any other <code>TokenMaker</code> instance.</li>
 * </ul>
 *
 * @author Robert Futrell
 * @version 0.5
 *
 */

public class CSharpTokenMaker extends AbstractJFlexCTokenMaker {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** lexical states */
  public static final int VERBATIMSTRING = 3;
  public static final int DOCUMENTCOMMENT = 2;
  public static final int YYINITIAL = 0;
  public static final int DELIMITEDCOMMENT = 1;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\2\1\1\1\0\2\15\22\0\1\2\1\45\1\41\1\16"+
    "\1\66\1\45\1\46\1\37\2\65\1\4\1\32\1\56\1\12\1\36"+
    "\1\3\1\30\11\11\1\44\1\56\1\53\1\52\1\54\1\51\1\14"+
    "\3\27\1\35\1\33\1\35\5\10\1\26\1\34\7\10\1\7\2\10"+
    "\1\31\2\10\1\65\1\5\1\65\1\50\1\13\1\0\1\23\1\42"+
    "\1\71\1\57\1\21\1\22\1\64\1\67\1\60\1\75\1\72\1\24"+
    "\1\73\1\61\1\62\1\70\1\10\1\20\1\25\1\17\1\6\1\40"+
    "\1\63\1\43\1\74\1\76\1\55\1\47\1\55\1\51\uff81\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\2\0\2\1\1\2\1\3\1\4\2\5\2\6\1\7"+
    "\1\5\3\2\7\6\1\7\1\5\1\2\1\10\1\6"+
    "\1\11\1\6\5\5\1\12\11\6\1\1\1\13\5\1"+
    "\1\14\1\1\1\15\3\1\1\16\1\17\1\0\1\20"+
    "\1\21\5\6\1\22\1\7\1\22\1\23\1\7\1\0"+
    "\1\24\7\2\14\6\1\25\10\6\1\22\1\23\1\26"+
    "\1\10\1\27\2\6\2\11\1\30\4\6\2\25\21\6"+
    "\1\31\7\0\1\32\2\0\1\1\7\0\1\20\1\33"+
    "\5\6\1\7\1\23\1\0\7\2\1\34\1\2\17\6"+
    "\1\25\10\6\1\35\1\10\1\36\2\10\1\26\1\10"+
    "\3\6\1\11\1\37\3\11\7\6\1\40\20\6\20\0"+
    "\1\6\1\40\2\6\6\2\1\41\12\6\2\35\2\10"+
    "\1\26\2\6\2\11\16\6\1\0\1\42\2\0\1\43"+
    "\7\0\3\2\10\6\1\35\2\10\1\26\1\6\2\11"+
    "\10\6\7\0\2\2\3\6\2\10\1\26\1\11\5\6"+
    "\2\0\1\2\3\6\1\0\1\6";

  private static int [] zzUnpackAction() {
    int [] result = new int[364];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\77\0\176\0\275\0\374\0\u013b\0\u017a\0\u01b9"+
    "\0\u01f8\0\u0237\0\u0276\0\u02b5\0\u02f4\0\u0333\0\u013b\0\u0372"+
    "\0\u03b1\0\u03f0\0\u042f\0\u046e\0\u04ad\0\u04ec\0\u052b\0\u056a"+
    "\0\u05a9\0\u05e8\0\u0627\0\u0666\0\u06a5\0\u06e4\0\u013b\0\u0723"+
    "\0\u0762\0\u07a1\0\u07e0\0\u013b\0\u013b\0\u081f\0\u085e\0\u089d"+
    "\0\u08dc\0\u091b\0\u095a\0\u0999\0\u09d8\0\u0a17\0\u013b\0\u0a56"+
    "\0\u0a95\0\u0ad4\0\u0b13\0\u0b52\0\u013b\0\u0b91\0\u0bd0\0\u0c0f"+
    "\0\u0c4e\0\u0c8d\0\u013b\0\u0ccc\0\u0d0b\0\u0d4a\0\u013b\0\u0d89"+
    "\0\u0dc8\0\u0e07\0\u0e46\0\u0e85\0\u0ec4\0\u0f03\0\u0f42\0\u0ec4"+
    "\0\u0f81\0\u05e8\0\u013b\0\u0fc0\0\u0fff\0\u103e\0\u107d\0\u10bc"+
    "\0\u10fb\0\u113a\0\u1179\0\u11b8\0\u11f7\0\u1236\0\u1275\0\u12b4"+
    "\0\u12f3\0\u1332\0\u1371\0\u13b0\0\u13ef\0\u142e\0\u0276\0\u146d"+
    "\0\u14ac\0\u14eb\0\u152a\0\u1569\0\u15a8\0\u15e7\0\u1626\0\u1665"+
    "\0\u16a4\0\u16e3\0\u1722\0\u013b\0\u1761\0\u17a0\0\u17df\0\u181e"+
    "\0\u013b\0\u185d\0\u189c\0\u18db\0\u191a\0\u1959\0\u1998\0\u19d7"+
    "\0\u1a16\0\u1a55\0\u1a94\0\u1ad3\0\u1b12\0\u1b51\0\u1b90\0\u1bcf"+
    "\0\u1c0e\0\u1c4d\0\u1c8c\0\u1ccb\0\u1d0a\0\u1d49\0\u1d88\0\u1dc7"+
    "\0\u013b\0\u1e06\0\u1e45\0\u1e84\0\u1ec3\0\u1f02\0\u1f41\0\u0bd0"+
    "\0\u013b\0\u1f80\0\u1fbf\0\u013b\0\u1ffe\0\u203d\0\u207c\0\u20bb"+
    "\0\u20fa\0\u2139\0\u2178\0\u21b7\0\u013b\0\u21f6\0\u2235\0\u2274"+
    "\0\u22b3\0\u22f2\0\u0ec4\0\u2331\0\u2370\0\u23af\0\u23ee\0\u242d"+
    "\0\u246c\0\u24ab\0\u24ea\0\u2529\0\u2568\0\u25a7\0\u25e6\0\u2625"+
    "\0\u2664\0\u26a3\0\u26e2\0\u2721\0\u2760\0\u279f\0\u27de\0\u281d"+
    "\0\u285c\0\u289b\0\u28da\0\u2919\0\u2958\0\u2997\0\u29d6\0\u2a15"+
    "\0\u2a54\0\u2a93\0\u2ad2\0\u2b11\0\u2b50\0\u2b8f\0\u2bce\0\u2c0d"+
    "\0\u013b\0\u2c4c\0\u2c8b\0\u2cca\0\u2d09\0\u2d48\0\u2d87\0\u2dc6"+
    "\0\u2e05\0\u013b\0\u2e44\0\u2e83\0\u2ec2\0\u2f01\0\u2f40\0\u2f7f"+
    "\0\u2fbe\0\u2ffd\0\u303c\0\u307b\0\u30ba\0\u30f9\0\u3138\0\u3177"+
    "\0\u31b6\0\u31f5\0\u3234\0\u3273\0\u32b2\0\u32f1\0\u3330\0\u336f"+
    "\0\u33ae\0\u33ed\0\u342c\0\u346b\0\u34aa\0\u34e9\0\u3528\0\u3567"+
    "\0\u35a6\0\u35e5\0\u3624\0\u3663\0\u36a2\0\u36e1\0\u3720\0\u375f"+
    "\0\u379e\0\u37dd\0\u381c\0\u385b\0\u389a\0\u38d9\0\u0276\0\u3918"+
    "\0\u3957\0\u3996\0\u39d5\0\u3a14\0\u3a53\0\u3a92\0\u3ad1\0\u0276"+
    "\0\u3b10\0\u3b4f\0\u3b8e\0\u3bcd\0\u3c0c\0\u3c4b\0\u3c8a\0\u3cc9"+
    "\0\u3d08\0\u3d47\0\u3d86\0\u3dc5\0\u3e04\0\u3e43\0\u3e82\0\u3ec1"+
    "\0\u3f00\0\u3f3f\0\u3f7e\0\u3fbd\0\u3ffc\0\u403b\0\u407a\0\u40b9"+
    "\0\u40f8\0\u4137\0\u4176\0\u41b5\0\u41f4\0\u4233\0\u4272\0\u42b1"+
    "\0\u42f0\0\u432f\0\u436e\0\u43ad\0\u43ec\0\u442b\0\u446a\0\u44a9"+
    "\0\u44e8\0\u4527\0\u4566\0\u45a5\0\u45e4\0\u4623\0\u4662\0\u46a1"+
    "\0\u46e0\0\u471f\0\u475e\0\u479d\0\u47dc\0\u481b\0\u485a\0\u4899"+
    "\0\u0ec4\0\u48d8\0\u4917\0\u4956\0\u4995\0\u49d4\0\u4a13\0\u4a52"+
    "\0\u4a91\0\u4ad0\0\u4b0f\0\u4b4e\0\u4b8d\0\u4bcc\0\u4c0b\0\u4c4a"+
    "\0\u436e\0\u4c89\0\u442b\0\u4cc8\0\u4d07\0\u4d46\0\u4d85\0\u4dc4"+
    "\0\u4e03\0\u4e42\0\u4e81\0\u4ec0\0\u4eff\0\u4f3e\0\u4f7d\0\u4fbc"+
    "\0\u4ffb\0\u503a\0\u5079\0\u50b8\0\u50f7\0\u5136\0\u5175\0\u51b4"+
    "\0\u51f3\0\u5232\0\u5271\0\u52b0";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[364];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\5\1\6\1\7\1\10\1\11\1\5\1\12\2\13"+
    "\1\14\1\15\1\13\1\16\1\17\1\20\1\21\1\22"+
    "\1\23\1\24\1\25\1\26\1\27\2\13\1\30\1\13"+
    "\1\31\3\13\1\32\1\33\1\34\1\35\1\36\1\13"+
    "\1\37\1\11\1\40\1\41\1\11\1\37\1\11\1\42"+
    "\1\43\1\44\1\45\1\46\1\47\1\50\1\51\1\52"+
    "\1\53\1\44\1\5\1\13\1\54\1\55\5\13\1\56"+
    "\1\57\2\56\1\60\15\56\1\61\40\56\1\62\3\56"+
    "\1\63\7\56\1\64\1\65\20\64\1\66\30\64\1\67"+
    "\7\64\1\70\3\64\1\71\7\64\1\72\1\73\37\72"+
    "\1\74\35\72\1\5\4\0\5\5\1\0\2\5\1\0"+
    "\14\5\1\0\3\5\2\0\1\5\1\0\2\5\13\0"+
    "\6\5\1\0\11\5\101\0\1\7\13\0\1\75\63\0"+
    "\1\76\1\77\45\0\1\37\76\0\1\37\24\0\1\5"+
    "\4\0\1\5\4\13\1\100\1\13\1\5\1\0\1\5"+
    "\5\13\1\101\1\102\4\13\1\0\3\13\2\0\1\13"+
    "\1\0\2\13\13\0\1\13\1\103\1\104\3\13\1\0"+
    "\1\5\10\13\1\5\4\0\1\5\4\13\1\100\1\13"+
    "\1\5\1\0\1\5\13\13\1\0\3\13\2\0\1\13"+
    "\1\0\2\13\13\0\6\13\1\0\1\5\10\13\1\105"+
    "\4\0\1\105\2\106\1\105\1\14\1\0\2\105\1\0"+
    "\3\105\1\107\1\110\1\105\1\111\1\105\1\111\1\105"+
    "\1\14\1\105\1\0\1\107\2\110\1\112\1\0\1\105"+
    "\1\0\2\105\13\0\1\110\5\105\1\0\5\105\1\110"+
    "\3\105\12\0\1\37\37\0\1\37\1\0\1\37\22\0"+
    "\1\5\4\0\1\5\3\13\1\5\1\0\1\13\1\5"+
    "\1\0\1\5\11\13\1\5\1\13\1\0\3\13\2\0"+
    "\1\13\1\113\2\13\13\0\6\13\1\0\1\5\10\13"+
    "\1\5\1\0\1\75\2\0\1\5\1\114\3\5\1\0"+
    "\2\5\1\0\2\5\1\115\1\116\2\5\1\117\5\5"+
    "\1\0\3\5\2\0\1\5\1\0\2\5\13\0\1\120"+
    "\1\121\2\5\1\122\1\5\1\0\12\5\4\0\1\5"+
    "\4\13\1\100\1\13\1\5\1\0\1\5\1\13\1\123"+
    "\11\13\1\0\3\13\2\0\1\13\1\0\2\13\13\0"+
    "\6\13\1\0\1\5\1\124\4\13\1\125\2\13\1\5"+
    "\4\0\1\5\4\13\1\100\1\13\1\5\1\0\1\5"+
    "\2\13\1\126\10\13\1\0\3\13\2\0\1\13\1\0"+
    "\2\13\13\0\6\13\1\0\1\5\10\13\1\5\4\0"+
    "\1\5\4\13\1\100\1\13\1\5\1\0\1\5\5\13"+
    "\1\127\5\13\1\0\3\13\2\0\1\130\1\0\1\13"+
    "\1\131\13\0\2\13\1\132\3\13\1\0\1\5\10\13"+
    "\1\5\4\0\1\5\4\13\1\100\1\13\1\5\1\0"+
    "\1\5\4\13\1\133\1\134\5\13\1\0\3\13\2\0"+
    "\1\13\1\0\2\13\13\0\1\13\1\135\1\13\1\136"+
    "\2\13\1\0\1\5\10\13\1\5\4\0\1\5\4\13"+
    "\1\100\1\13\1\5\1\0\1\5\6\13\1\137\4\13"+
    "\1\0\3\13\2\0\1\13\1\0\1\140\1\13\13\0"+
    "\6\13\1\0\1\5\10\13\1\5\4\0\1\5\4\13"+
    "\1\100\1\13\1\5\1\0\1\5\13\13\1\0\3\13"+
    "\2\0\1\13\1\0\2\13\13\0\3\13\1\141\2\13"+
    "\1\0\1\5\10\13\1\5\4\0\1\5\4\13\1\100"+
    "\1\13\1\5\1\0\1\5\1\142\1\13\1\143\10\13"+
    "\1\0\3\13\2\0\1\13\1\0\1\144\1\13\13\0"+
    "\1\13\1\145\2\13\1\146\1\13\1\0\1\5\1\147"+
    "\7\13\1\105\4\0\1\105\2\106\1\105\1\14\1\0"+
    "\2\105\1\0\3\105\1\107\1\110\1\105\1\111\1\105"+
    "\1\111\1\105\1\14\1\150\1\0\1\107\2\110\1\112"+
    "\1\0\1\105\1\0\1\105\1\150\13\0\1\110\5\105"+
    "\1\0\5\105\1\110\3\105\32\0\1\37\17\0\1\37"+
    "\35\0\1\151\16\0\1\151\46\0\1\152\1\0\3\152"+
    "\1\153\31\152\1\154\37\152\1\5\4\0\1\5\4\13"+
    "\1\100\1\13\1\5\1\0\1\5\13\13\1\0\3\13"+
    "\2\0\1\13\1\0\2\13\13\0\1\13\1\155\1\13"+
    "\1\156\2\13\1\0\1\5\10\13\1\35\1\157\3\35"+
    "\1\160\33\35\1\161\35\35\1\5\4\0\1\5\4\13"+
    "\1\100\1\13\1\5\1\0\1\5\1\13\1\162\2\13"+
    "\1\127\6\13\1\0\3\13\2\0\1\13\1\0\2\13"+
    "\13\0\3\13\1\163\2\13\1\0\1\5\5\13\1\164"+
    "\2\13\46\0\1\37\3\0\1\37\73\0\1\37\2\0"+
    "\1\37\76\0\1\37\1\11\75\0\1\37\1\0\1\11"+
    "\22\0\1\5\4\0\1\5\4\13\1\100\1\13\1\5"+
    "\1\0\1\5\2\13\1\165\10\13\1\0\3\13\2\0"+
    "\1\13\1\0\2\13\13\0\3\13\1\166\2\13\1\0"+
    "\1\5\10\13\1\5\4\0\1\5\4\13\1\100\1\13"+
    "\1\5\1\0\1\5\3\13\1\137\2\13\1\137\4\13"+
    "\1\0\3\13\2\0\1\13\1\0\2\13\13\0\2\13"+
    "\1\167\3\13\1\0\1\5\4\13\1\170\3\13\1\5"+
    "\4\0\1\5\1\171\3\13\1\100\1\13\1\5\1\0"+
    "\1\5\2\13\1\172\1\13\1\173\6\13\1\0\3\13"+
    "\2\0\1\13\1\0\2\13\13\0\6\13\1\0\1\5"+
    "\10\13\1\5\4\0\1\5\1\174\3\13\1\100\1\13"+
    "\1\5\1\0\1\5\13\13\1\0\3\13\2\0\1\175"+
    "\1\0\1\176\1\13\13\0\6\13\1\0\1\5\1\13"+
    "\1\177\6\13\1\5\4\0\1\5\4\13\1\100\1\13"+
    "\1\5\1\0\1\5\13\13\1\0\3\13\2\0\1\13"+
    "\1\0\2\13\13\0\6\13\1\0\1\5\1\200\7\13"+
    "\1\5\4\0\1\5\4\13\1\100\1\13\1\5\1\0"+
    "\1\5\13\13\1\0\3\13\2\0\1\13\1\0\2\13"+
    "\13\0\3\13\1\201\2\13\1\0\1\5\10\13\1\5"+
    "\4\0\1\5\1\202\3\13\1\100\1\13\1\5\1\0"+
    "\1\5\1\13\1\203\2\13\1\204\6\13\1\0\3\13"+
    "\2\0\1\13\1\0\2\13\13\0\6\13\1\0\1\5"+
    "\10\13\1\5\4\0\1\5\4\13\1\100\1\13\1\5"+
    "\1\0\1\5\4\13\1\205\1\206\5\13\1\0\3\13"+
    "\2\0\1\13\1\0\2\13\13\0\3\13\1\207\2\13"+
    "\1\0\1\5\1\210\7\13\1\56\1\0\2\56\1\0"+
    "\15\56\1\0\40\56\1\0\3\56\1\0\7\56\3\0"+
    "\1\211\112\0\1\212\40\0\1\213\101\0\1\214\32\0"+
    "\1\215\57\0\1\64\1\0\20\64\1\0\30\64\1\0"+
    "\7\64\1\0\3\64\1\0\7\64\17\0\1\216\40\0"+
    "\1\217\16\0\54\220\1\221\22\220\63\0\1\222\32\0"+
    "\1\223\57\0\1\72\1\0\37\72\1\0\35\72\41\0"+
    "\1\224\37\0\1\75\3\0\1\225\11\0\1\226\1\227"+
    "\2\0\1\230\32\0\1\231\1\232\2\0\1\233\13\0"+
    "\3\234\1\235\73\234\6\0\6\100\3\0\13\100\1\0"+
    "\3\100\2\0\1\100\1\0\2\100\13\0\6\100\2\0"+
    "\10\100\1\5\4\0\1\5\4\13\1\100\1\13\1\5"+
    "\1\0\1\5\13\13\1\0\3\13\2\0\1\13\1\0"+
    "\2\13\13\0\3\13\1\236\2\13\1\0\1\5\10\13"+
    "\1\5\4\0\1\5\4\13\1\100\1\13\1\5\1\0"+
    "\1\5\13\13\1\0\3\13\2\0\1\13\1\0\2\13"+
    "\13\0\1\13\1\237\4\13\1\0\1\5\1\147\7\13"+
    "\1\5\4\0\1\5\4\13\1\100\1\13\1\5\1\0"+
    "\1\5\13\13\1\0\3\13\2\0\1\13\1\0\2\13"+
    "\13\0\2\13\1\240\3\13\1\0\1\5\10\13\1\5"+
    "\4\0\1\5\4\13\1\100\1\13\1\5\1\0\1\5"+
    "\6\13\1\241\4\13\1\0\3\13\2\0\1\13\1\0"+
    "\2\13\13\0\6\13\1\0\1\5\2\13\1\242\5\13"+
    "\1\105\4\0\5\105\1\0\2\105\1\0\14\105\1\0"+
    "\3\105\2\0\1\105\1\0\2\105\13\0\6\105\1\0"+
    "\12\105\4\0\5\105\1\0\2\105\1\0\6\105\1\243"+
    "\1\105\1\243\3\105\1\0\3\105\2\0\1\105\1\0"+
    "\2\105\13\0\6\105\1\0\12\105\4\0\4\105\1\244"+
    "\1\245\2\105\1\0\12\105\1\244\1\105\1\245\3\105"+
    "\2\0\1\105\1\0\2\105\13\0\6\105\1\0\12\105"+
    "\4\0\1\105\2\243\2\105\1\0\2\105\1\0\14\105"+
    "\1\0\3\105\2\0\1\105\1\0\2\105\13\0\6\105"+
    "\1\0\11\105\1\5\4\0\5\5\1\0\2\5\1\0"+
    "\14\5\1\0\3\5\2\0\1\5\1\0\2\5\13\0"+
    "\2\5\1\246\3\5\1\0\12\5\4\0\5\5\1\0"+
    "\2\5\1\0\3\5\1\247\10\5\1\0\3\5\2\0"+
    "\1\5\1\0\2\5\13\0\6\5\1\0\12\5\4\0"+
    "\5\5\1\0\2\5\1\0\2\5\1\250\3\5\1\251"+
    "\5\5\1\0\3\5\2\0\1\5\1\0\2\5\13\0"+
    "\2\5\1\252\3\5\1\0\12\5\4\0\5\5\1\0"+
    "\2\5\1\0\14\5\1\0\3\5\2\0\1\5\1\0"+
    "\2\5\13\0\1\5\1\253\4\5\1\0\12\5\4\0"+
    "\5\5\1\0\2\5\1\0\3\5\1\254\10\5\1\0"+
    "\3\5\2\0\1\5\1\0\2\5\13\0\6\5\1\0"+
    "\12\5\4\0\5\5\1\0\2\5\1\0\4\5\1\255"+
    "\7\5\1\0\3\5\2\0\1\5\1\0\2\5\13\0"+
    "\6\5\1\0\12\5\4\0\5\5\1\0\2\5\1\0"+
    "\5\5\1\256\6\5\1\0\3\5\2\0\1\5\1\0"+
    "\2\5\13\0\6\5\1\0\12\5\4\0\1\5\1\257"+
    "\3\13\1\100\1\13\1\5\1\0\1\5\13\13\1\0"+
    "\3\13\2\0\1\13\1\0\2\13\13\0\6\13\1\0"+
    "\1\5\5\13\1\137\2\13\1\5\4\0\1\5\4\13"+
    "\1\100\1\13\1\5\1\0\1\5\1\13\1\260\11\13"+
    "\1\0\3\13\2\0\1\13\1\0\2\13\13\0\1\13"+
    "\1\261\4\13\1\0\1\5\10\13\1\5\4\0\1\5"+
    "\4\13\1\100\1\13\1\5\1\0\1\5\13\13\1\0"+
    "\3\13\2\0\1\13\1\0\2\13\13\0\6\13\1\0"+
    "\1\5\1\13\1\262\6\13\1\5\4\0\1\5\4\13"+
    "\1\100\1\13\1\5\1\0\1\5\1\263\2\13\1\137"+
    "\1\264\6\13\1\0\3\13\2\0\1\13\1\0\2\13"+
    "\13\0\6\13\1\0\1\5\10\13\1\5\4\0\1\5"+
    "\4\13\1\100\1\13\1\5\1\0\1\5\6\13\1\265"+
    "\4\13\1\0\3\13\2\0\1\13\1\0\2\13\13\0"+
    "\6\13\1\0\1\5\10\13\1\5\4\0\1\5\4\13"+
    "\1\100\1\13\1\5\1\0\1\5\2\13\1\266\10\13"+
    "\1\0\3\13\2\0\1\13\1\0\2\13\13\0\6\13"+
    "\1\0\1\5\10\13\1\5\4\0\1\5\4\13\1\100"+
    "\1\13\1\5\1\0\1\5\1\267\12\13\1\0\3\13"+
    "\2\0\1\13\1\0\2\13\13\0\6\13\1\0\1\5"+
    "\1\13\1\270\6\13\1\5\4\0\1\5\1\271\3\13"+
    "\1\100\1\13\1\5\1\0\1\5\13\13\1\0\3\13"+
    "\2\0\1\13\1\0\2\13\13\0\6\13\1\0\1\5"+
    "\10\13\1\5\4\0\1\5\4\13\1\100\1\13\1\5"+
    "\1\0\1\5\5\13\1\272\5\13\1\0\3\13\2\0"+
    "\1\13\1\0\2\13\13\0\6\13\1\0\1\5\10\13"+
    "\1\5\4\0\1\5\4\13\1\100\1\13\1\5\1\0"+
    "\1\5\13\13\1\0\3\13\2\0\1\13\1\0\2\13"+
    "\13\0\3\13\1\273\2\13\1\0\1\5\10\13\1\5"+
    "\4\0\1\5\4\13\1\100\1\13\1\5\1\0\1\5"+
    "\13\13\1\0\3\13\2\0\1\13\1\0\1\13\1\274"+
    "\13\0\2\13\1\275\3\13\1\0\1\5\10\13\1\5"+
    "\4\0\1\5\4\13\1\100\1\13\1\5\1\0\1\5"+
    "\1\13\1\276\11\13\1\0\3\13\2\0\1\13\1\0"+
    "\2\13\13\0\6\13\1\0\1\5\10\13\1\5\4\0"+
    "\1\5\4\13\1\100\1\13\1\5\1\0\1\5\6\13"+
    "\1\277\4\13\1\0\3\13\2\0\1\13\1\0\2\13"+
    "\13\0\6\13\1\0\1\5\10\13\1\5\4\0\1\5"+
    "\4\13\1\100\1\13\1\5\1\0\1\5\13\13\1\0"+
    "\3\13\2\0\1\13\1\0\2\13\13\0\2\13\1\300"+
    "\3\13\1\0\1\5\2\13\1\301\5\13\1\5\4\0"+
    "\1\5\4\13\1\100\1\13\1\5\1\0\1\5\1\13"+
    "\1\302\2\13\1\303\6\13\1\0\3\13\2\0\1\13"+
    "\1\0\2\13\13\0\6\13\1\0\1\5\10\13\1\5"+
    "\4\0\1\5\4\13\1\100\1\13\1\5\1\0\1\5"+
    "\4\13\1\304\6\13\1\0\3\13\2\0\1\13\1\0"+
    "\2\13\13\0\6\13\1\0\1\5\10\13\1\5\4\0"+
    "\1\5\4\13\1\100\1\13\1\5\1\0\1\5\13\13"+
    "\1\0\3\13\2\0\1\13\1\0\2\13\13\0\6\13"+
    "\1\0\1\5\5\13\1\164\2\13\1\5\4\0\1\5"+
    "\4\13\1\100\1\13\1\5\1\0\1\5\13\13\1\0"+
    "\3\13\2\0\1\13\1\0\2\13\13\0\6\13\1\0"+
    "\1\5\7\13\1\262\1\5\4\0\1\5\4\13\1\100"+
    "\1\13\1\5\1\0\1\5\13\13\1\0\3\13\2\0"+
    "\1\13\1\0\2\13\13\0\1\13\1\305\4\13\1\0"+
    "\1\5\10\13\1\5\4\0\1\5\4\13\1\100\1\13"+
    "\1\5\1\0\1\5\13\13\1\0\3\13\2\0\1\13"+
    "\1\0\2\13\13\0\3\13\1\306\2\13\1\0\1\5"+
    "\10\13\1\105\4\0\4\105\1\307\1\0\2\105\1\0"+
    "\3\105\3\307\3\105\2\307\1\105\1\0\1\307\1\105"+
    "\1\307\2\0\1\105\1\0\1\307\1\105\13\0\1\307"+
    "\5\105\1\0\3\105\1\307\6\105\4\0\4\105\1\151"+
    "\1\0\2\105\1\0\3\105\1\107\1\110\5\105\1\151"+
    "\1\105\1\0\1\107\2\110\2\0\1\105\1\0\2\105"+
    "\13\0\1\110\5\105\1\0\5\105\1\110\3\105\1\310"+
    "\1\0\35\310\1\311\40\310\1\0\3\310\1\152\1\312"+
    "\1\313\7\310\2\152\1\310\2\152\4\310\1\152\6\310"+
    "\1\314\3\152\1\315\15\310\1\152\15\310\1\5\4\0"+
    "\1\5\4\13\1\100\1\13\1\5\1\0\1\5\1\13"+
    "\1\316\11\13\1\0\3\13\2\0\1\13\1\0\2\13"+
    "\13\0\6\13\1\0\1\5\10\13\1\5\4\0\1\5"+
    "\4\13\1\100\1\13\1\5\1\0\1\5\5\13\1\317"+
    "\5\13\1\0\3\13\2\0\1\13\1\0\2\13\13\0"+
    "\1\13\1\320\4\13\1\0\1\5\10\13\5\157\1\321"+
    "\33\157\1\322\36\157\1\0\3\157\1\35\1\323\1\324"+
    "\7\157\2\35\1\157\2\35\4\157\1\35\6\157\4\35"+
    "\1\325\15\157\1\35\15\157\1\5\4\0\1\5\4\13"+
    "\1\100\1\13\1\5\1\0\1\5\2\13\1\326\10\13"+
    "\1\0\3\13\2\0\1\13\1\0\2\13\13\0\6\13"+
    "\1\0\1\5\10\13\1\5\4\0\1\5\4\13\1\100"+
    "\1\13\1\5\1\0\1\5\13\13\1\0\3\13\2\0"+
    "\1\13\1\0\2\13\13\0\3\13\1\327\2\13\1\0"+
    "\1\5\10\13\1\5\4\0\1\5\4\13\1\100\1\13"+
    "\1\5\1\0\1\5\1\330\12\13\1\0\3\13\2\0"+
    "\1\13\1\0\2\13\13\0\6\13\1\0\1\5\10\13"+
    "\1\5\4\0\1\5\4\13\1\100\1\13\1\5\1\0"+
    "\1\5\3\13\1\331\1\13\1\332\5\13\1\0\3\13"+
    "\2\0\1\13\1\0\2\13\13\0\6\13\1\0\1\5"+
    "\2\13\1\333\5\13\1\5\4\0\1\5\1\334\3\13"+
    "\1\100\1\13\1\5\1\0\1\5\13\13\1\0\3\13"+
    "\2\0\1\13\1\0\2\13\13\0\6\13\1\0\1\5"+
    "\10\13\1\5\4\0\1\5\4\13\1\100\1\13\1\5"+
    "\1\0\1\5\1\335\12\13\1\0\3\13\2\0\1\13"+
    "\1\0\2\13\13\0\6\13\1\0\1\5\10\13\1\5"+
    "\4\0\1\5\4\13\1\100\1\13\1\5\1\0\1\5"+
    "\13\13\1\0\3\13\2\0\1\13\1\0\2\13\13\0"+
    "\6\13\1\0\1\5\1\13\1\270\6\13\1\5\4\0"+
    "\1\5\4\13\1\100\1\13\1\5\1\0\1\5\5\13"+
    "\1\336\5\13\1\0\3\13\2\0\1\13\1\0\2\13"+
    "\13\0\6\13\1\0\1\5\10\13\1\5\4\0\1\5"+
    "\4\13\1\100\1\13\1\5\1\0\1\5\13\13\1\0"+
    "\3\13\2\0\1\13\1\0\2\13\13\0\4\13\1\137"+
    "\1\13\1\0\1\5\10\13\1\5\4\0\1\5\4\13"+
    "\1\100\1\13\1\5\1\0\1\5\13\13\1\0\3\13"+
    "\2\0\1\13\1\0\2\13\13\0\6\13\1\0\1\5"+
    "\4\13\1\337\3\13\1\5\4\0\1\5\4\13\1\100"+
    "\1\13\1\5\1\0\1\5\1\137\12\13\1\0\3\13"+
    "\2\0\1\13\1\0\2\13\13\0\6\13\1\0\1\5"+
    "\10\13\1\5\4\0\1\5\4\13\1\100\1\13\1\5"+
    "\1\0\1\5\2\13\1\340\10\13\1\0\3\13\2\0"+
    "\1\13\1\0\2\13\13\0\6\13\1\0\1\5\10\13"+
    "\1\5\4\0\1\5\4\13\1\100\1\13\1\5\1\0"+
    "\1\5\13\13\1\0\3\13\2\0\1\13\1\0\2\13"+
    "\13\0\6\13\1\0\1\5\6\13\1\341\1\13\1\5"+
    "\4\0\1\5\4\13\1\100\1\13\1\5\1\0\1\5"+
    "\2\13\1\342\10\13\1\0\3\13\2\0\1\13\1\0"+
    "\2\13\13\0\6\13\1\0\1\5\10\13\1\5\4\0"+
    "\1\5\4\13\1\100\1\13\1\5\1\0\1\5\13\13"+
    "\1\0\3\13\2\0\1\13\1\0\2\13\13\0\1\13"+
    "\1\343\4\13\1\0\1\5\10\13\1\5\4\0\1\5"+
    "\4\13\1\100\1\13\1\5\1\0\1\5\1\344\12\13"+
    "\1\0\3\13\2\0\1\13\1\0\2\13\13\0\6\13"+
    "\1\0\1\5\10\13\1\5\4\0\1\5\4\13\1\100"+
    "\1\13\1\5\1\0\1\5\13\13\1\0\3\13\2\0"+
    "\1\13\1\0\1\345\1\13\13\0\6\13\1\0\1\5"+
    "\10\13\1\5\4\0\1\5\4\13\1\100\1\13\1\5"+
    "\1\0\1\5\13\13\1\0\3\13\2\0\1\13\1\0"+
    "\2\13\13\0\1\13\1\346\1\13\1\347\2\13\1\0"+
    "\1\5\10\13\1\5\4\0\1\5\4\13\1\100\1\13"+
    "\1\5\1\0\1\5\1\13\1\350\11\13\1\0\3\13"+
    "\2\0\1\13\1\0\2\13\13\0\6\13\1\0\1\5"+
    "\10\13\1\5\4\0\1\5\4\13\1\100\1\13\1\5"+
    "\1\0\1\5\1\351\5\13\1\265\4\13\1\0\3\13"+
    "\2\0\1\13\1\0\2\13\13\0\6\13\1\0\1\5"+
    "\10\13\1\5\4\0\1\5\4\13\1\100\1\13\1\5"+
    "\1\0\1\5\4\13\1\352\6\13\1\0\3\13\2\0"+
    "\1\13\1\0\2\13\13\0\6\13\1\0\1\5\10\13"+
    "\1\5\4\0\1\5\4\13\1\100\1\13\1\5\1\0"+
    "\1\5\13\13\1\0\3\13\2\0\1\13\1\0\2\13"+
    "\13\0\2\13\1\353\3\13\1\0\1\5\10\13\1\5"+
    "\4\0\1\5\4\13\1\100\1\13\1\5\1\0\1\5"+
    "\2\13\1\354\1\13\1\355\6\13\1\0\3\13\2\0"+
    "\1\13\1\0\2\13\13\0\6\13\1\0\1\5\10\13"+
    "\70\0\1\356\32\0\1\357\135\0\1\360\32\0\1\361"+
    "\147\0\1\362\32\0\1\363\135\0\1\364\32\0\1\365"+
    "\140\0\1\366\36\0\1\367\75\0\1\370\3\0\1\371"+
    "\34\0\1\372\75\0\1\373\37\0\1\374\77\0\1\255"+
    "\77\0\1\375\53\0\1\234\1\0\75\234\1\5\4\0"+
    "\1\5\4\13\1\100\1\13\1\5\1\0\1\5\13\13"+
    "\1\0\3\13\2\0\1\13\1\0\2\13\13\0\2\13"+
    "\1\300\3\13\1\0\1\5\10\13\1\5\4\0\1\5"+
    "\4\13\1\100\1\13\1\5\1\0\1\5\13\13\1\0"+
    "\3\13\2\0\1\13\1\0\2\13\13\0\2\13\1\376"+
    "\3\13\1\0\1\5\10\13\1\5\4\0\1\5\4\13"+
    "\1\100\1\13\1\5\1\0\1\5\1\377\12\13\1\0"+
    "\3\13\2\0\1\13\1\0\2\13\13\0\6\13\1\0"+
    "\1\5\10\13\1\5\4\0\1\5\4\13\1\100\1\13"+
    "\1\5\1\0\1\5\4\13\1\u0100\6\13\1\0\3\13"+
    "\2\0\1\13\1\0\2\13\13\0\6\13\1\0\1\5"+
    "\10\13\1\5\4\0\1\5\4\13\1\100\1\13\1\5"+
    "\1\0\1\5\13\13\1\0\3\13\2\0\1\13\1\0"+
    "\2\13\13\0\6\13\1\0\1\5\1\u0101\7\13\1\105"+
    "\4\0\4\105\1\244\1\0\2\105\1\0\4\105\1\110"+
    "\5\105\1\244\1\105\1\0\1\105\2\110\2\0\1\105"+
    "\1\0\2\105\13\0\1\110\5\105\1\0\5\105\1\110"+
    "\3\105\11\0\1\244\16\0\1\244\46\0\1\5\4\0"+
    "\5\5\1\0\2\5\1\0\14\5\1\0\3\5\2\0"+
    "\1\5\1\0\2\5\13\0\1\u0102\5\5\1\0\12\5"+
    "\4\0\5\5\1\0\2\5\1\0\14\5\1\0\3\5"+
    "\2\0\1\5\1\0\2\5\13\0\5\5\1\u0103\1\0"+
    "\12\5\4\0\5\5\1\0\2\5\1\0\2\5\1\u0104"+
    "\11\5\1\0\3\5\2\0\1\5\1\0\2\5\13\0"+
    "\6\5\1\0\12\5\4\0\5\5\1\0\2\5\1\0"+
    "\7\5\1\u0105\4\5\1\0\3\5\2\0\1\5\1\0"+
    "\2\5\13\0\1\5\1\121\4\5\1\0\12\5\4\0"+
    "\5\5\1\0\2\5\1\0\14\5\1\0\3\5\2\0"+
    "\1\5\1\0\2\5\13\0\1\u0106\5\5\1\0\12\5"+
    "\4\0\5\5\1\0\2\5\1\0\14\5\1\0\3\5"+
    "\2\0\1\5\1\0\2\5\13\0\2\5\1\u0105\3\5"+
    "\1\0\12\5\4\0\5\5\1\0\2\5\1\0\4\5"+
    "\1\117\7\5\1\0\3\5\2\0\1\5\1\0\2\5"+
    "\13\0\6\5\1\0\11\5\1\255\1\0\75\255\1\5"+
    "\4\0\5\5\1\0\2\5\1\0\2\5\1\u0107\11\5"+
    "\1\0\3\5\2\0\1\5\1\0\2\5\13\0\6\5"+
    "\1\0\12\5\4\0\1\5\4\13\1\100\1\13\1\5"+
    "\1\0\1\5\2\13\1\u0108\10\13\1\0\3\13\2\0"+
    "\1\13\1\0\2\13\13\0\6\13\1\0\1\5\10\13"+
    "\1\5\4\0\1\5\4\13\1\100\1\13\1\5\1\0"+
    "\1\5\13\13\1\0\3\13\2\0\1\13\1\0\2\13"+
    "\13\0\3\13\1\172\2\13\1\0\1\5\10\13\1\5"+
    "\4\0\1\5\4\13\1\100\1\13\1\5\1\0\1\5"+
    "\6\13\1\137\4\13\1\0\3\13\2\0\1\13\1\0"+
    "\2\13\13\0\6\13\1\0\1\5\10\13\1\5\4\0"+
    "\1\5\4\13\1\100\1\13\1\5\1\0\1\5\2\13"+
    "\1\u0109\10\13\1\0\3\13\2\0\1\13\1\0\2\13"+
    "\13\0\6\13\1\0\1\5\10\13\1\5\4\0\1\5"+
    "\1\u010a\3\13\1\100\1\13\1\5\1\0\1\5\13\13"+
    "\1\0\3\13\2\0\1\13\1\0\2\13\13\0\6\13"+
    "\1\0\1\5\10\13\1\5\4\0\1\5\4\13\1\100"+
    "\1\13\1\5\1\0\1\5\13\13\1\0\3\13\2\0"+
    "\1\13\1\0\2\13\13\0\1\u010b\5\13\1\0\1\5"+
    "\10\13\1\5\4\0\1\5\4\13\1\100\1\13\1\5"+
    "\1\0\1\5\2\13\1\137\10\13\1\0\3\13\2\0"+
    "\1\13\1\0\2\13\13\0\6\13\1\0\1\5\10\13"+
    "\1\5\4\0\1\5\4\13\1\100\1\13\1\5\1\0"+
    "\1\5\13\13\1\0\3\13\2\0\1\13\1\0\2\13"+
    "\13\0\2\13\1\174\3\13\1\0\1\5\10\13\1\5"+
    "\4\0\1\5\4\13\1\100\1\13\1\5\1\0\1\5"+
    "\2\13\1\u010a\10\13\1\0\3\13\2\0\1\13\1\0"+
    "\2\13\13\0\6\13\1\0\1\5\10\13\1\5\4\0"+
    "\1\5\4\13\1\100\1\13\1\5\1\0\1\5\5\13"+
    "\1\u010c\5\13\1\0\3\13\2\0\1\13\1\0\2\13"+
    "\13\0\6\13\1\0\1\5\10\13\1\5\4\0\1\5"+
    "\4\13\1\100\1\13\1\5\1\0\1\5\13\13\1\0"+
    "\3\13\2\0\1\13\1\0\2\13\13\0\6\13\1\0"+
    "\1\5\4\13\1\137\3\13\1\5\4\0\1\5\4\13"+
    "\1\100\1\13\1\5\1\0\1\5\6\13\1\257\4\13"+
    "\1\0\3\13\2\0\1\13\1\0\2\13\13\0\6\13"+
    "\1\0\1\5\10\13\1\5\4\0\1\5\4\13\1\100"+
    "\1\13\1\5\1\0\1\5\4\13\1\240\6\13\1\0"+
    "\3\13\2\0\1\13\1\0\2\13\13\0\6\13\1\0"+
    "\1\5\10\13\1\5\4\0\1\5\4\13\1\100\1\13"+
    "\1\5\1\0\1\5\2\13\1\320\10\13\1\0\3\13"+
    "\2\0\1\13\1\0\2\13\13\0\6\13\1\0\1\5"+
    "\10\13\1\5\4\0\1\5\4\13\1\100\1\13\1\5"+
    "\1\0\1\5\4\13\1\u010d\6\13\1\0\3\13\2\0"+
    "\1\13\1\0\2\13\13\0\6\13\1\0\1\5\10\13"+
    "\1\5\4\0\1\5\4\13\1\100\1\13\1\5\1\0"+
    "\1\5\2\13\1\u010e\10\13\1\0\3\13\2\0\1\13"+
    "\1\0\2\13\13\0\6\13\1\0\1\5\10\13\1\5"+
    "\4\0\1\5\4\13\1\100\1\13\1\5\1\0\1\5"+
    "\1\u010f\12\13\1\0\3\13\2\0\1\13\1\0\2\13"+
    "\13\0\6\13\1\0\1\5\10\13\1\5\4\0\1\5"+
    "\4\13\1\100\1\13\1\5\1\0\1\5\13\13\1\0"+
    "\3\13\2\0\1\13\1\0\2\13\13\0\5\13\1\377"+
    "\1\0\1\5\10\13\1\5\4\0\1\5\4\13\1\100"+
    "\1\13\1\5\1\0\1\5\13\13\1\0\3\13\2\0"+
    "\1\13\1\0\2\13\13\0\6\13\1\0\1\5\3\13"+
    "\1\137\4\13\1\5\4\0\1\5\1\u0110\3\13\1\100"+
    "\1\13\1\5\1\0\1\5\13\13\1\0\3\13\2\0"+
    "\1\13\1\0\2\13\13\0\1\13\1\237\4\13\1\0"+
    "\1\5\10\13\1\5\4\0\1\5\4\13\1\100\1\13"+
    "\1\5\1\0\1\5\1\u0111\12\13\1\0\3\13\2\0"+
    "\1\13\1\0\2\13\13\0\6\13\1\0\1\5\2\13"+
    "\1\u0112\5\13\1\5\4\0\1\5\4\13\1\100\1\13"+
    "\1\5\1\0\1\5\5\13\1\274\5\13\1\0\3\13"+
    "\2\0\1\13\1\0\2\13\13\0\6\13\1\0\1\5"+
    "\10\13\1\5\4\0\1\5\4\13\1\100\1\13\1\5"+
    "\1\0\1\5\1\351\12\13\1\0\3\13\2\0\1\13"+
    "\1\0\2\13\13\0\6\13\1\0\1\5\10\13\1\5"+
    "\4\0\1\5\4\13\1\100\1\13\1\5\1\0\1\5"+
    "\1\13\1\240\11\13\1\0\3\13\2\0\1\13\1\0"+
    "\2\13\13\0\6\13\1\0\1\5\10\13\1\105\4\0"+
    "\1\105\2\u0113\1\105\1\307\1\0\2\105\1\0\3\105"+
    "\3\307\1\u0114\1\105\1\u0114\2\307\1\105\1\0\1\307"+
    "\1\105\1\307\2\0\1\105\1\0\1\307\1\105\13\0"+
    "\1\307\5\105\1\0\3\105\1\307\5\105\1\310\1\0"+
    "\35\310\1\154\40\310\1\0\7\310\1\u0115\7\310\3\u0115"+
    "\3\310\2\u0115\2\310\1\u0115\1\310\1\u0115\1\310\1\154"+
    "\2\310\1\u0115\14\310\1\u0115\11\310\1\u0115\6\310\1\0"+
    "\7\310\1\u0116\7\310\3\u0116\3\310\2\u0116\2\310\1\u0116"+
    "\1\310\1\u0116\1\310\1\154\2\310\1\u0116\14\310\1\u0116"+
    "\11\310\1\u0116\5\310\37\0\1\311\37\0\1\310\1\0"+
    "\7\310\1\u0117\7\310\3\u0117\3\310\2\u0117\2\310\1\u0117"+
    "\1\310\1\u0117\1\310\1\154\2\310\1\u0117\14\310\1\u0117"+
    "\11\310\1\u0117\5\310\1\5\4\0\1\5\4\13\1\100"+
    "\1\13\1\5\1\0\1\5\1\u0118\12\13\1\0\3\13"+
    "\2\0\1\13\1\0\2\13\13\0\6\13\1\0\1\5"+
    "\10\13\1\5\4\0\1\5\4\13\1\100\1\13\1\5"+
    "\1\0\1\5\4\13\1\u0119\6\13\1\0\3\13\2\0"+
    "\1\13\1\0\2\13\13\0\6\13\1\0\1\5\10\13"+
    "\1\5\4\0\1\5\4\13\1\100\1\13\1\5\1\0"+
    "\1\5\13\13\1\0\3\13\2\0\1\13\1\0\2\13"+
    "\13\0\1\137\5\13\1\0\1\5\10\13\1\157\1\0"+
    "\102\157\1\321\3\157\1\u011a\7\157\3\u011a\3\157\2\u011a"+
    "\2\157\1\u011a\1\157\1\u011a\3\157\1\322\1\u011a\14\157"+
    "\1\u011a\11\157\1\u011a\12\157\1\321\3\157\1\u011b\7\157"+
    "\3\u011b\3\157\2\u011b\2\157\1\u011b\1\157\1\u011b\3\157"+
    "\1\322\1\u011b\14\157\1\u011b\11\157\1\u011b\12\157\1\321"+
    "\3\157\1\35\7\157\3\35\3\157\2\35\2\157\1\35"+
    "\1\157\1\35\3\157\1\322\1\35\14\157\1\35\11\157"+
    "\1\35\5\157\1\5\4\0\1\5\4\13\1\100\1\13"+
    "\1\5\1\0\1\5\4\13\1\301\6\13\1\0\3\13"+
    "\2\0\1\13\1\0\2\13\13\0\6\13\1\0\1\5"+
    "\10\13\1\5\4\0\1\5\4\13\1\100\1\13\1\5"+
    "\1\0\1\5\5\13\1\377\5\13\1\0\3\13\2\0"+
    "\1\13\1\0\2\13\13\0\6\13\1\0\1\5\10\13"+
    "\1\5\4\0\1\5\4\13\1\100\1\13\1\5\1\0"+
    "\1\5\2\13\1\377\10\13\1\0\3\13\2\0\1\13"+
    "\1\0\2\13\13\0\6\13\1\0\1\5\10\13\1\5"+
    "\4\0\1\5\4\13\1\100\1\13\1\5\1\0\1\5"+
    "\4\13\1\u011c\6\13\1\0\3\13\2\0\1\13\1\0"+
    "\2\13\13\0\6\13\1\0\1\5\10\13\1\5\4\0"+
    "\1\5\4\13\1\100\1\13\1\5\1\0\1\5\2\13"+
    "\1\u011d\10\13\1\0\3\13\2\0\1\13\1\0\2\13"+
    "\13\0\6\13\1\0\1\5\10\13\1\5\4\0\1\5"+
    "\4\13\1\100\1\13\1\5\1\0\1\5\13\13\1\0"+
    "\3\13\2\0\1\13\1\0\2\13\13\0\1\13\1\u011e"+
    "\4\13\1\0\1\5\10\13\1\5\4\0\1\5\4\13"+
    "\1\100\1\13\1\5\1\0\1\5\13\13\1\0\3\13"+
    "\2\0\1\13\1\0\1\u011f\1\13\13\0\6\13\1\0"+
    "\1\5\10\13\1\5\4\0\1\5\4\13\1\100\1\13"+
    "\1\5\1\0\1\5\2\13\1\u0120\10\13\1\0\3\13"+
    "\2\0\1\13\1\0\2\13\13\0\6\13\1\0\1\5"+
    "\10\13\1\5\4\0\1\5\4\13\1\100\1\13\1\5"+
    "\1\0\1\5\5\13\1\137\5\13\1\0\3\13\2\0"+
    "\1\13\1\0\2\13\13\0\6\13\1\0\1\5\10\13"+
    "\1\5\4\0\1\5\4\13\1\100\1\13\1\5\1\0"+
    "\1\5\2\13\1\u0121\10\13\1\0\3\13\2\0\1\13"+
    "\1\0\2\13\13\0\6\13\1\0\1\5\10\13\1\5"+
    "\4\0\1\5\4\13\1\100\1\13\1\5\1\0\1\5"+
    "\1\13\1\u0122\11\13\1\0\3\13\2\0\1\13\1\0"+
    "\2\13\13\0\6\13\1\0\1\5\10\13\1\5\4\0"+
    "\1\5\4\13\1\100\1\13\1\5\1\0\1\5\2\13"+
    "\1\u0110\10\13\1\0\3\13\2\0\1\13\1\0\2\13"+
    "\13\0\6\13\1\0\1\5\10\13\1\5\4\0\1\5"+
    "\4\13\1\100\1\13\1\5\1\0\1\5\1\13\1\u0123"+
    "\11\13\1\0\3\13\2\0\1\13\1\0\2\13\13\0"+
    "\6\13\1\0\1\5\10\13\1\5\4\0\1\5\4\13"+
    "\1\100\1\13\1\5\1\0\1\5\5\13\1\265\5\13"+
    "\1\0\3\13\2\0\1\13\1\0\2\13\13\0\6\13"+
    "\1\0\1\5\10\13\1\5\4\0\1\5\4\13\1\100"+
    "\1\13\1\5\1\0\1\5\13\13\1\0\3\13\2\0"+
    "\1\13\1\0\2\13\13\0\3\13\1\137\2\13\1\0"+
    "\1\5\10\13\1\5\4\0\1\5\4\13\1\100\1\13"+
    "\1\5\1\0\1\5\5\13\1\u0111\5\13\1\0\3\13"+
    "\2\0\1\13\1\0\2\13\13\0\6\13\1\0\1\5"+
    "\10\13\1\5\4\0\1\5\4\13\1\100\1\13\1\5"+
    "\1\0\1\5\13\13\1\0\3\13\2\0\1\u0124\1\0"+
    "\2\13\13\0\6\13\1\0\1\5\10\13\1\5\4\0"+
    "\1\5\4\13\1\100\1\13\1\5\1\0\1\5\1\u0125"+
    "\12\13\1\0\3\13\2\0\1\13\1\0\2\13\13\0"+
    "\6\13\1\0\1\5\10\13\1\5\4\0\1\5\4\13"+
    "\1\100\1\13\1\5\1\0\1\5\4\13\1\u0126\6\13"+
    "\1\0\3\13\2\0\1\13\1\0\2\13\13\0\6\13"+
    "\1\0\1\5\10\13\1\5\4\0\1\5\4\13\1\100"+
    "\1\13\1\5\1\0\1\5\13\13\1\0\3\13\2\0"+
    "\1\13\1\0\2\13\13\0\6\13\1\0\1\5\2\13"+
    "\1\u0127\5\13\1\5\4\0\1\5\4\13\1\100\1\13"+
    "\1\5\1\0\1\5\6\13\1\261\4\13\1\0\3\13"+
    "\2\0\1\13\1\0\2\13\13\0\6\13\1\0\1\5"+
    "\10\13\1\5\4\0\1\5\4\13\1\100\1\13\1\5"+
    "\1\0\1\5\1\u0128\5\13\1\174\4\13\1\0\3\13"+
    "\2\0\1\13\1\0\2\13\13\0\6\13\1\0\1\5"+
    "\10\13\1\5\4\0\1\5\4\13\1\100\1\13\1\5"+
    "\1\0\1\5\13\13\1\0\3\13\2\0\1\13\1\0"+
    "\2\13\13\0\6\13\1\0\1\5\2\13\1\u0129\5\13"+
    "\1\5\4\0\1\5\4\13\1\100\1\13\1\5\1\0"+
    "\1\5\1\13\1\377\11\13\1\0\3\13\2\0\1\13"+
    "\1\0\2\13\13\0\6\13\1\0\1\5\10\13\44\0"+
    "\1\u012a\53\0\1\356\113\0\1\u012b\130\0\1\u012c\52\0"+
    "\1\u012d\53\0\1\362\113\0\1\u012e\130\0\1\u012f\65\0"+
    "\1\u0130\103\0\1\u0131\32\0\1\u0132\103\0\1\u0133\32\0"+
    "\1\232\75\0\1\u0134\100\0\1\u0133\37\0\1\230\74\0"+
    "\1\u0135\56\0\1\5\4\0\1\5\4\13\1\100\1\13"+
    "\1\5\1\0\1\5\13\13\1\0\3\13\2\0\1\13"+
    "\1\0\2\13\13\0\5\13\1\137\1\0\1\5\10\13"+
    "\1\5\4\0\1\5\4\13\1\100\1\13\1\5\1\0"+
    "\1\5\3\13\1\265\7\13\1\0\3\13\2\0\1\13"+
    "\1\0\2\13\13\0\6\13\1\0\1\5\10\13\1\5"+
    "\4\0\1\5\4\13\1\100\1\13\1\5\1\0\1\5"+
    "\2\13\1\354\10\13\1\0\3\13\2\0\1\13\1\0"+
    "\2\13\13\0\6\13\1\0\1\5\10\13\1\5\4\0"+
    "\5\5\1\0\2\5\1\0\3\5\1\121\10\5\1\0"+
    "\3\5\2\0\1\5\1\0\2\5\13\0\6\5\1\0"+
    "\12\5\4\0\5\5\1\0\2\5\1\0\14\5\1\0"+
    "\3\5\2\0\1\5\1\0\2\5\13\0\1\5\1\u0136"+
    "\4\5\1\0\12\5\4\0\5\5\1\0\2\5\1\0"+
    "\14\5\1\0\3\5\2\0\1\5\1\0\2\5\13\0"+
    "\3\5\1\u0137\2\5\1\0\12\5\4\0\5\5\1\0"+
    "\2\5\1\0\3\5\1\255\10\5\1\0\3\5\2\0"+
    "\1\5\1\0\2\5\13\0\6\5\1\0\12\5\4\0"+
    "\5\5\1\0\2\5\1\0\2\5\1\115\11\5\1\0"+
    "\3\5\2\0\1\5\1\0\2\5\13\0\1\5\1\121"+
    "\4\5\1\0\12\5\4\0\5\5\1\0\2\5\1\0"+
    "\14\5\1\0\3\5\2\0\1\5\1\0\2\5\13\0"+
    "\2\5\1\u0138\3\5\1\0\12\5\4\0\1\5\4\13"+
    "\1\100\1\13\1\5\1\0\1\5\13\13\1\0\3\13"+
    "\2\0\1\13\1\0\2\13\13\0\3\13\1\u0139\2\13"+
    "\1\0\1\5\10\13\1\5\4\0\1\5\4\13\1\100"+
    "\1\13\1\5\1\0\1\5\1\13\1\u013a\11\13\1\0"+
    "\3\13\2\0\1\13\1\0\2\13\13\0\6\13\1\0"+
    "\1\5\10\13\1\5\4\0\1\5\4\13\1\100\1\13"+
    "\1\5\1\0\1\5\13\13\1\0\3\13\2\0\1\13"+
    "\1\0\2\13\13\0\3\13\1\u013b\2\13\1\0\1\5"+
    "\10\13\1\5\4\0\1\5\4\13\1\100\1\13\1\5"+
    "\1\0\1\5\13\13\1\0\3\13\2\0\1\13\1\0"+
    "\2\13\13\0\1\13\1\u013c\4\13\1\0\1\5\10\13"+
    "\1\5\4\0\1\5\4\13\1\100\1\13\1\5\1\0"+
    "\1\5\5\13\1\u013d\5\13\1\0\3\13\2\0\1\13"+
    "\1\0\2\13\13\0\6\13\1\0\1\5\10\13\1\5"+
    "\4\0\1\5\4\13\1\100\1\13\1\5\1\0\1\5"+
    "\4\13\1\351\6\13\1\0\3\13\2\0\1\13\1\0"+
    "\2\13\13\0\6\13\1\0\1\5\10\13\1\5\4\0"+
    "\1\5\4\13\1\100\1\13\1\5\1\0\1\5\1\13"+
    "\1\u013e\11\13\1\0\3\13\2\0\1\13\1\0\2\13"+
    "\13\0\6\13\1\0\1\5\10\13\1\5\4\0\1\5"+
    "\4\13\1\100\1\13\1\5\1\0\1\5\13\13\1\0"+
    "\3\13\2\0\1\13\1\0\2\13\13\0\6\13\1\0"+
    "\1\5\2\13\1\174\5\13\1\5\4\0\1\5\4\13"+
    "\1\100\1\13\1\5\1\0\1\5\13\13\1\0\3\13"+
    "\2\0\1\13\1\0\2\13\13\0\1\13\1\u013f\4\13"+
    "\1\0\1\5\10\13\1\5\4\0\1\5\4\13\1\100"+
    "\1\13\1\5\1\0\1\5\13\13\1\0\3\13\2\0"+
    "\1\13\1\0\2\13\13\0\6\13\1\0\1\5\3\13"+
    "\1\u0140\4\13\1\105\4\0\5\105\1\0\2\105\1\0"+
    "\6\105\1\u0141\1\105\1\u0141\3\105\1\0\3\105\2\0"+
    "\1\105\1\0\2\105\13\0\6\105\1\0\12\105\4\0"+
    "\1\105\2\u0141\2\105\1\0\2\105\1\0\14\105\1\0"+
    "\3\105\2\0\1\105\1\0\2\105\13\0\6\105\1\0"+
    "\11\105\1\310\1\0\7\310\1\u0142\7\310\3\u0142\3\310"+
    "\2\u0142\2\310\1\u0142\1\310\1\u0142\1\310\1\154\2\310"+
    "\1\u0142\14\310\1\u0142\11\310\1\u0142\6\310\1\0\7\310"+
    "\1\u0143\7\310\3\u0143\3\310\2\u0143\2\310\1\u0143\1\310"+
    "\1\u0143\1\310\1\154\2\310\1\u0143\14\310\1\u0143\11\310"+
    "\1\u0143\6\310\1\0\7\310\1\u0144\7\310\3\u0144\3\310"+
    "\2\u0144\2\310\1\u0144\1\310\1\u0144\1\310\1\311\2\310"+
    "\1\u0144\14\310\1\u0144\11\310\1\u0144\5\310\1\5\4\0"+
    "\1\5\1\u0145\3\13\1\100\1\13\1\5\1\0\1\5"+
    "\13\13\1\0\3\13\2\0\1\13\1\0\2\13\13\0"+
    "\6\13\1\0\1\5\10\13\1\5\4\0\1\5\4\13"+
    "\1\100\1\13\1\5\1\0\1\5\1\200\12\13\1\0"+
    "\3\13\2\0\1\13\1\0\2\13\13\0\6\13\1\0"+
    "\1\5\10\13\5\157\1\321\3\157\1\u0146\7\157\3\u0146"+
    "\3\157\2\u0146\2\157\1\u0146\1\157\1\u0146\3\157\1\322"+
    "\1\u0146\14\157\1\u0146\11\157\1\u0146\12\157\1\321\3\157"+
    "\1\u0147\7\157\3\u0147\3\157\2\u0147\2\157\1\u0147\1\157"+
    "\1\u0147\3\157\1\322\1\u0147\14\157\1\u0147\11\157\1\u0147"+
    "\5\157\1\5\4\0\1\5\1\u0148\3\13\1\100\1\13"+
    "\1\5\1\0\1\5\13\13\1\0\3\13\2\0\1\13"+
    "\1\0\2\13\13\0\6\13\1\0\1\5\10\13\1\5"+
    "\4\0\1\5\4\13\1\100\1\13\1\5\1\0\1\5"+
    "\13\13\1\0\3\13\2\0\1\13\1\0\2\13\13\0"+
    "\5\13\1\u0124\1\0\1\5\10\13\1\5\4\0\1\5"+
    "\4\13\1\100\1\13\1\5\1\0\1\5\13\13\1\0"+
    "\3\13\2\0\1\13\1\0\2\13\13\0\6\13\1\0"+
    "\1\5\4\13\1\u0145\3\13\1\5\4\0\1\5\4\13"+
    "\1\100\1\13\1\5\1\0\1\5\5\13\1\330\5\13"+
    "\1\0\3\13\2\0\1\13\1\0\2\13\13\0\6\13"+
    "\1\0\1\5\10\13\1\5\4\0\1\5\4\13\1\100"+
    "\1\13\1\5\1\0\1\5\1\13\1\u0149\11\13\1\0"+
    "\3\13\2\0\1\13\1\0\2\13\13\0\6\13\1\0"+
    "\1\5\10\13\1\5\4\0\1\5\4\13\1\100\1\13"+
    "\1\5\1\0\1\5\6\13\1\u014a\4\13\1\0\3\13"+
    "\2\0\1\13\1\0\2\13\13\0\6\13\1\0\1\5"+
    "\10\13\1\5\4\0\1\5\4\13\1\100\1\13\1\5"+
    "\1\0\1\5\1\13\1\u014b\11\13\1\0\3\13\2\0"+
    "\1\13\1\0\2\13\13\0\6\13\1\0\1\5\10\13"+
    "\1\5\4\0\1\5\4\13\1\100\1\13\1\5\1\0"+
    "\1\5\4\13\1\u014c\6\13\1\0\3\13\2\0\1\13"+
    "\1\0\2\13\13\0\6\13\1\0\1\5\10\13\1\5"+
    "\4\0\1\5\4\13\1\100\1\13\1\5\1\0\1\5"+
    "\4\13\1\u014d\6\13\1\0\3\13\2\0\1\13\1\0"+
    "\2\13\13\0\6\13\1\0\1\5\10\13\1\5\4\0"+
    "\1\5\4\13\1\100\1\13\1\5\1\0\1\5\2\13"+
    "\1\u014e\10\13\1\0\3\13\2\0\1\13\1\0\2\13"+
    "\13\0\6\13\1\0\1\5\10\13\1\5\4\0\1\5"+
    "\4\13\1\100\1\13\1\5\1\0\1\5\13\13\1\0"+
    "\3\13\2\0\1\13\1\0\2\13\13\0\6\13\1\0"+
    "\1\5\4\13\1\261\3\13\1\5\4\0\1\5\4\13"+
    "\1\100\1\13\1\5\1\0\1\5\13\13\1\0\3\13"+
    "\2\0\1\13\1\0\2\13\13\0\6\13\1\0\1\5"+
    "\1\137\7\13\1\5\4\0\1\5\4\13\1\100\1\13"+
    "\1\5\1\0\1\5\13\13\1\0\3\13\2\0\1\13"+
    "\1\0\2\13\13\0\1\13\1\u014f\4\13\1\0\1\5"+
    "\10\13\1\5\4\0\1\5\4\13\1\100\1\13\1\5"+
    "\1\0\1\5\13\13\1\0\3\13\2\0\1\13\1\0"+
    "\2\13\13\0\6\13\1\0\1\5\3\13\1\274\4\13"+
    "\3\0\1\u0150\76\0\1\u012b\1\u0151\1\0\4\u012b\3\u0151"+
    "\1\0\1\u0151\13\u012b\1\u0151\3\u012b\2\u0151\1\u012b\1\0"+
    "\2\u012b\3\u0151\2\0\2\u0151\3\0\1\u0151\6\u012b\1\u0151"+
    "\11\u012b\25\0\1\356\16\0\1\u012a\35\0\1\u0152\76\0"+
    "\1\u012e\1\u0153\1\0\4\u012e\3\u0153\1\0\1\u0153\13\u012e"+
    "\1\u0153\3\u012e\2\u0153\1\u012e\1\0\2\u012e\3\u0153\2\0"+
    "\2\u0153\3\0\1\u0153\6\u012e\1\u0153\11\u012e\25\0\1\362"+
    "\16\0\1\u012d\53\0\1\232\135\0\1\u0154\100\0\1\u0155"+
    "\35\0\1\255\75\0\1\226\37\0\1\232\77\0\1\u0156"+
    "\15\0\1\5\4\0\5\5\1\0\2\5\1\0\14\5"+
    "\1\0\3\5\2\0\1\5\1\0\2\5\13\0\3\5"+
    "\1\u0157\2\5\1\0\12\5\4\0\5\5\1\0\2\5"+
    "\1\0\2\5\1\255\11\5\1\0\3\5\2\0\1\5"+
    "\1\0\2\5\13\0\6\5\1\0\12\5\4\0\5\5"+
    "\1\0\2\5\1\0\14\5\1\0\3\5\2\0\1\5"+
    "\1\0\2\5\13\0\1\5\1\u0158\4\5\1\0\12\5"+
    "\4\0\1\5\4\13\1\100\1\13\1\5\1\0\1\5"+
    "\3\13\1\137\7\13\1\0\3\13\2\0\1\13\1\0"+
    "\2\13\13\0\6\13\1\0\1\5\10\13\1\5\4\0"+
    "\1\5\4\13\1\100\1\13\1\5\1\0\1\5\13\13"+
    "\1\0\3\13\2\0\1\13\1\0\2\13\13\0\2\13"+
    "\1\137\3\13\1\0\1\5\10\13\1\5\4\0\1\5"+
    "\4\13\1\100\1\13\1\5\1\0\1\5\13\13\1\0"+
    "\3\13\2\0\1\13\1\0\2\13\13\0\2\13\1\u013d"+
    "\3\13\1\0\1\5\10\13\1\5\4\0\1\5\4\13"+
    "\1\100\1\13\1\5\1\0\1\5\13\13\1\0\3\13"+
    "\2\0\1\13\1\0\2\13\13\0\6\13\1\0\1\5"+
    "\2\13\1\u0159\5\13\1\5\4\0\1\5\4\13\1\100"+
    "\1\13\1\5\1\0\1\5\5\13\1\u015a\5\13\1\0"+
    "\3\13\2\0\1\13\1\0\2\13\13\0\6\13\1\0"+
    "\1\5\10\13\1\5\4\0\1\5\4\13\1\100\1\13"+
    "\1\5\1\0\1\5\4\13\1\u0110\6\13\1\0\3\13"+
    "\2\0\1\13\1\0\2\13\13\0\6\13\1\0\1\5"+
    "\10\13\1\5\4\0\1\5\4\13\1\100\1\13\1\5"+
    "\1\0\1\5\13\13\1\0\3\13\2\0\1\13\1\0"+
    "\2\13\13\0\6\13\1\0\1\5\2\13\1\137\5\13"+
    "\1\5\4\0\1\5\4\13\1\100\1\13\1\5\1\0"+
    "\1\5\4\13\1\u015b\6\13\1\0\3\13\2\0\1\13"+
    "\1\0\2\13\13\0\6\13\1\0\1\5\10\13\1\310"+
    "\1\0\7\310\1\u015c\7\310\3\u015c\3\310\2\u015c\2\310"+
    "\1\u015c\1\310\1\u015c\1\310\1\154\2\310\1\u015c\14\310"+
    "\1\u015c\11\310\1\u015c\6\310\1\0\7\310\1\u015d\7\310"+
    "\3\u015d\3\310\2\u015d\2\310\1\u015d\1\310\1\u015d\1\310"+
    "\1\154\2\310\1\u015d\14\310\1\u015d\11\310\1\u015d\6\310"+
    "\1\0\7\310\1\u015e\7\310\3\u015e\3\310\2\u015e\2\310"+
    "\1\u015e\1\310\1\u015e\1\310\1\311\2\310\1\u015e\14\310"+
    "\1\u015e\11\310\1\u015e\5\310\1\5\4\0\1\5\4\13"+
    "\1\100\1\13\1\5\1\0\1\5\4\13\1\336\6\13"+
    "\1\0\3\13\2\0\1\13\1\0\2\13\13\0\6\13"+
    "\1\0\1\5\10\13\5\157\1\321\3\157\1\325\7\157"+
    "\3\325\3\157\2\325\2\157\1\325\1\157\1\325\3\157"+
    "\1\322\1\325\14\157\1\325\11\157\1\325\12\157\1\321"+
    "\3\157\1\u015f\7\157\3\u015f\3\157\2\u015f\2\157\1\u015f"+
    "\1\157\1\u015f\3\157\1\322\1\u015f\14\157\1\u015f\11\157"+
    "\1\u015f\5\157\1\5\4\0\1\5\4\13\1\100\1\13"+
    "\1\5\1\0\1\5\5\13\1\174\5\13\1\0\3\13"+
    "\2\0\1\13\1\0\2\13\13\0\6\13\1\0\1\5"+
    "\10\13\1\5\4\0\1\5\4\13\1\100\1\13\1\5"+
    "\1\0\1\5\3\13\1\u0160\7\13\1\0\3\13\2\0"+
    "\1\13\1\0\2\13\13\0\2\13\1\u0145\3\13\1\0"+
    "\1\5\10\13\1\5\4\0\1\5\4\13\1\100\1\13"+
    "\1\5\1\0\1\5\13\13\1\0\3\13\2\0\1\13"+
    "\1\0\2\13\13\0\6\13\1\0\1\5\1\13\1\u0160"+
    "\6\13\1\5\4\0\1\5\4\13\1\100\1\13\1\5"+
    "\1\0\1\5\13\13\1\0\3\13\2\0\1\13\1\0"+
    "\2\13\13\0\1\13\1\u0161\4\13\1\0\1\5\10\13"+
    "\1\5\4\0\1\5\4\13\1\100\1\13\1\5\1\0"+
    "\1\5\1\u0162\12\13\1\0\3\13\2\0\1\13\1\0"+
    "\2\13\13\0\6\13\1\0\1\5\10\13\1\5\4\0"+
    "\1\5\4\13\1\100\1\13\1\5\1\0\1\5\1\265"+
    "\12\13\1\0\3\13\2\0\1\13\1\0\2\13\13\0"+
    "\6\13\1\0\1\5\10\13\1\5\4\0\1\5\4\13"+
    "\1\100\1\13\1\5\1\0\1\5\13\13\1\0\3\13"+
    "\2\0\1\13\1\0\2\13\13\0\6\13\1\0\1\5"+
    "\2\13\1\u0163\5\13\1\5\4\0\1\5\4\13\1\100"+
    "\1\13\1\5\1\0\1\5\13\13\1\0\3\13\2\0"+
    "\1\13\1\0\2\13\13\0\2\13\1\u0164\3\13\1\0"+
    "\1\5\10\13\3\0\1\u012b\76\0\1\u012e\155\0\1\u0165"+
    "\34\0\1\255\136\0\1\u0166\16\0\1\5\4\0\5\5"+
    "\1\0\2\5\1\0\14\5\1\0\3\5\2\0\1\5"+
    "\1\0\2\5\13\0\2\5\1\255\3\5\1\0\12\5"+
    "\4\0\5\5\1\0\2\5\1\0\14\5\1\0\3\5"+
    "\2\0\1\5\1\0\2\5\13\0\2\5\1\u0167\3\5"+
    "\1\0\12\5\4\0\1\5\4\13\1\100\1\13\1\5"+
    "\1\0\1\5\13\13\1\0\3\13\2\0\1\13\1\0"+
    "\2\13\13\0\1\13\1\174\4\13\1\0\1\5\10\13"+
    "\1\5\4\0\1\5\4\13\1\100\1\13\1\5\1\0"+
    "\1\5\13\13\1\0\3\13\2\0\1\13\1\0\2\13"+
    "\13\0\6\13\1\0\1\5\5\13\1\137\2\13\1\5"+
    "\4\0\1\5\4\13\1\100\1\13\1\5\1\0\1\5"+
    "\5\13\1\u0168\5\13\1\0\3\13\2\0\1\13\1\0"+
    "\2\13\13\0\6\13\1\0\1\5\10\13\1\310\1\0"+
    "\7\310\1\152\7\310\3\152\3\310\2\152\2\310\1\152"+
    "\1\310\1\152\1\310\1\154\2\310\1\152\14\310\1\152"+
    "\11\310\1\152\6\310\1\0\7\310\1\312\7\310\3\312"+
    "\3\310\2\312\2\310\1\312\1\310\1\312\1\310\1\154"+
    "\2\310\1\312\14\310\1\312\11\310\1\312\6\310\1\0"+
    "\7\310\1\152\7\310\3\152\3\310\2\152\2\310\1\152"+
    "\1\310\1\152\1\310\1\311\2\310\1\152\14\310\1\152"+
    "\11\310\1\152\5\310\5\157\1\321\3\157\1\323\7\157"+
    "\3\323\3\157\2\323\2\157\1\323\1\157\1\323\3\157"+
    "\1\322\1\323\14\157\1\323\11\157\1\323\5\157\1\5"+
    "\4\0\1\5\4\13\1\100\1\13\1\5\1\0\1\5"+
    "\4\13\1\u0169\6\13\1\0\3\13\2\0\1\13\1\0"+
    "\2\13\13\0\6\13\1\0\1\5\10\13\1\5\4\0"+
    "\1\5\4\13\1\100\1\13\1\5\1\0\1\5\13\13"+
    "\1\0\3\13\2\0\1\13\1\0\2\13\13\0\1\265"+
    "\5\13\1\0\1\5\10\13\1\5\4\0\1\5\4\13"+
    "\1\100\1\13\1\5\1\0\1\5\13\13\1\0\3\13"+
    "\2\0\1\13\1\0\2\13\13\0\3\13\1\u016a\2\13"+
    "\1\0\1\5\10\13\1\5\4\0\1\5\4\13\1\100"+
    "\1\13\1\5\1\0\1\5\1\274\12\13\1\0\3\13"+
    "\2\0\1\13\1\0\2\13\13\0\6\13\1\0\1\5"+
    "\10\13\1\5\4\0\1\5\1\265\3\13\1\100\1\13"+
    "\1\5\1\0\1\5\13\13\1\0\3\13\2\0\1\13"+
    "\1\0\2\13\13\0\6\13\1\0\1\5\10\13\61\0"+
    "\1\255\76\0\1\u016b\15\0\1\5\4\0\5\5\1\0"+
    "\2\5\1\0\14\5\1\0\3\5\2\0\1\5\1\0"+
    "\2\5\13\0\5\5\1\255\1\0\12\5\4\0\1\5"+
    "\4\13\1\100\1\13\1\5\1\0\1\5\5\13\1\u016c"+
    "\5\13\1\0\3\13\2\0\1\13\1\0\2\13\13\0"+
    "\6\13\1\0\1\5\10\13\1\5\4\0\1\5\4\13"+
    "\1\100\1\13\1\5\1\0\1\5\13\13\1\0\3\13"+
    "\2\0\1\13\1\0\2\13\13\0\6\13\1\0\1\5"+
    "\2\13\1\265\5\13\1\5\4\0\1\5\4\13\1\100"+
    "\1\13\1\5\1\0\1\5\1\13\1\137\11\13\1\0"+
    "\3\13\2\0\1\13\1\0\2\13\13\0\6\13\1\0"+
    "\1\5\10\13\64\0\1\255\12\0\1\5\4\0\1\5"+
    "\4\13\1\100\1\13\1\5\1\0\1\5\13\13\1\0"+
    "\3\13\2\0\1\13\1\0\2\13\13\0\3\13\1\u013f"+
    "\2\13\1\0\1\5\10\13";

  private static int [] zzUnpackTrans() {
    int [] result = new int[21231];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\2\0\3\1\1\11\10\1\1\11\17\1\1\11\4\1"+
    "\2\11\11\1\1\11\5\1\1\11\5\1\1\11\1\1"+
    "\1\0\1\1\1\11\12\1\1\0\1\11\40\1\1\11"+
    "\4\1\1\11\27\1\1\11\7\0\1\11\2\0\1\11"+
    "\7\0\1\1\1\11\7\1\1\0\43\1\1\11\10\1"+
    "\1\11\33\1\20\0\54\1\1\0\1\1\2\0\1\1"+
    "\7\0\32\1\7\0\16\1\2\0\4\1\1\0\1\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[364];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */


	/**
	 * Constructor.  This must be here because JFlex does not generate a
	 * no-parameter constructor.
	 */
	public CSharpTokenMaker() {
		super();
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 * @see #addToken(int, int, int)
	 */
	private void addHyperlinkToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so, true);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int tokenType) {
		addToken(zzStartRead, zzMarkedPos-1, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param array The character array.
	 * @param start The starting offset in the array.
	 * @param end The ending offset in the array.
	 * @param tokenType The token's type.
	 * @param startOffset The offset in the document at which this token
	 *                    occurs.
	 */
	public void addToken(char[] array, int start, int end, int tokenType, int startOffset) {
		super.addToken(array, start,end, tokenType, startOffset);
		zzStartRead = zzMarkedPos;
	}


	/**
	 * Returns the text to place at the beginning and end of a
	 * line to "comment" it in a this programming language.
	 *
	 * @return The start and end strings to add to a line to "comment"
	 *         it out.
	 */
	public String[] getLineCommentStartAndEnd() {
		return new String[] { "//", null };
	}


	/**
	 * Returns the first token in the linked list of tokens generated
	 * from <code>text</code>.  This method must be implemented by
	 * subclasses so they can correctly implement syntax highlighting.
	 *
	 * @param text The text from which to get tokens.
	 * @param initialTokenType The token type we should start with.
	 * @param startOffset The offset into the document at which
	 *        <code>text</code> starts.
	 * @return The first <code>Token</code> in a linked list representing
	 *         the syntax highlighted text.
	 */
	public Token getTokenList(Segment text, int initialTokenType, int startOffset) {

		resetTokenList();
		this.offsetShift = -text.offset + startOffset;

		// Start off in the proper state.
		int state = Token.NULL;
		switch (initialTokenType) {
			case Token.LITERAL_STRING_DOUBLE_QUOTE:
				state = VERBATIMSTRING;
				start = text.offset;
				break;
			case Token.COMMENT_MULTILINE:
				state = DELIMITEDCOMMENT;
				start = text.offset;
				break;
			default:
				state = Token.NULL;
		}

		s = text;
		try {
			yyreset(zzReader);
			yybegin(state);
			return yylex();
		} catch (IOException ioe) {
			ioe.printStackTrace();
			return new DefaultToken();
		}

	}


	/**
	 * Refills the input buffer.
	 *
	 * @return      <code>true</code> if EOF was reached, otherwise
	 *              <code>false</code>.
	 */
	private boolean zzRefill() {
		return zzCurrentPos>=s.offset+s.count;
	}


	/**
	 * Resets the scanner to read from a new input stream.
	 * Does not close the old reader.
	 *
	 * All internal variables are reset, the old input stream 
	 * <b>cannot</b> be reused (internal buffer is discarded and lost).
	 * Lexical state is set to <tt>YY_INITIAL</tt>.
	 *
	 * @param reader   the new input stream 
	 */
	public final void yyreset(java.io.Reader reader) {
		// 's' has been updated.
		zzBuffer = s.array;
		/*
		 * We replaced the line below with the two below it because zzRefill
		 * no longer "refills" the buffer (since the way we do it, it's always
		 * "full" the first time through, since it points to the segment's
		 * array).  So, we assign zzEndRead here.
		 */
		//zzStartRead = zzEndRead = s.offset;
		zzStartRead = s.offset;
		zzEndRead = zzStartRead + s.count - 1;
		zzCurrentPos = zzMarkedPos = s.offset;
		zzLexicalState = YYINITIAL;
		zzReader = reader;
		zzAtEOF  = false;
	}




  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public CSharpTokenMaker(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public CSharpTokenMaker(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 158) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public org.fife.ui.rsyntaxtextarea.Token yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 35: 
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_DOCUMENTATION); addHyperlinkToken(temp,zzMarkedPos-1, Token.COMMENT_DOCUMENTATION); start = zzMarkedPos;
          }
        case 36: break;
        case 28: 
          { addToken(Token.PREPROCESSOR);
          }
        case 37: break;
        case 3: 
          { addNullToken(); return firstToken;
          }
        case 38: break;
        case 30: 
          { addToken(Token.LITERAL_CHAR);
          }
        case 39: break;
        case 25: 
          { yybegin(YYINITIAL); addToken(start,zzStartRead+1, Token.COMMENT_MULTILINE);
          }
        case 40: break;
        case 4: 
          { addToken(Token.WHITESPACE);
          }
        case 41: break;
        case 29: 
          { addToken(Token.LITERAL_NUMBER_HEXADECIMAL);
          }
        case 42: break;
        case 22: 
          { addToken(Token.ERROR_CHAR); /*addNullToken(); return firstToken;*/
          }
        case 43: break;
        case 31: 
          { addToken(Token.ERROR_STRING_DOUBLE);
          }
        case 44: break;
        case 19: 
          { addToken(Token.LITERAL_NUMBER_FLOAT);
          }
        case 45: break;
        case 21: 
          { addToken(Token.RESERVED_WORD);
          }
        case 46: break;
        case 10: 
          { addToken(Token.SEPARATOR);
          }
        case 47: break;
        case 12: 
          { addToken(start,zzStartRead-1, Token.COMMENT_DOCUMENTATION); addNullToken(); return firstToken;
          }
        case 48: break;
        case 6: 
          { addToken(Token.IDENTIFIER);
          }
        case 49: break;
        case 13: 
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_DOCUMENTATION); addToken(temp,zzEndRead, Token.PREPROCESSOR); addNullToken(); return firstToken;
          }
        case 50: break;
        case 8: 
          { addToken(Token.ERROR_CHAR); addNullToken(); return firstToken;
          }
        case 51: break;
        case 9: 
          { addToken(Token.ERROR_STRING_DOUBLE); addNullToken(); return firstToken;
          }
        case 52: break;
        case 32: 
          { addToken(Token.DATA_TYPE);
          }
        case 53: break;
        case 2: 
          { addToken(Token.ERROR_IDENTIFIER);
          }
        case 54: break;
        case 23: 
          { addToken(Token.ERROR_CHAR);
          }
        case 55: break;
        case 33: 
          { addToken(Token.LITERAL_BOOLEAN);
          }
        case 56: break;
        case 20: 
          { start = zzMarkedPos-2; yybegin(VERBATIMSTRING);
          }
        case 57: break;
        case 24: 
          { addToken(Token.LITERAL_STRING_DOUBLE_QUOTE);
          }
        case 58: break;
        case 14: 
          { addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); return firstToken;
          }
        case 59: break;
        case 34: 
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); addHyperlinkToken(temp,zzMarkedPos-1, Token.COMMENT_MULTILINE); start = zzMarkedPos;
          }
        case 60: break;
        case 16: 
          { addToken(Token.COMMENT_EOL); addNullToken(); return firstToken;
          }
        case 61: break;
        case 18: 
          { addToken(Token.ERROR_NUMBER_FORMAT);
          }
        case 62: break;
        case 27: 
          { start = zzMarkedPos-3; yybegin(DOCUMENTCOMMENT);
          }
        case 63: break;
        case 17: 
          { start = zzMarkedPos-2; yybegin(DELIMITEDCOMMENT);
          }
        case 64: break;
        case 7: 
          { addToken(Token.LITERAL_NUMBER_DECIMAL_INT);
          }
        case 65: break;
        case 5: 
          { addToken(Token.OPERATOR);
          }
        case 66: break;
        case 26: 
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_DOCUMENTATION); addToken(temp,zzMarkedPos-1, Token.PREPROCESSOR); start = zzMarkedPos;
          }
        case 67: break;
        case 15: 
          { yybegin(YYINITIAL); addToken(start,zzStartRead, Token.LITERAL_STRING_DOUBLE_QUOTE);
          }
        case 68: break;
        case 1: 
          { 
          }
        case 69: break;
        case 11: 
          { addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); return firstToken;
          }
        case 70: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case VERBATIMSTRING: {
              addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); return firstToken;
            }
            case 365: break;
            case DOCUMENTCOMMENT: {
              addToken(start,zzStartRead-1, Token.COMMENT_DOCUMENTATION); addNullToken(); return firstToken;
            }
            case 366: break;
            case YYINITIAL: {
              addNullToken(); return firstToken;
            }
            case 367: break;
            case DELIMITEDCOMMENT: {
              addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); return firstToken;
            }
            case 368: break;
            default:
            return null;
            }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
