/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.sort.util;

import java.util.Arrays;

public class SegmentedBuffer {
    static final int INITIAL_CHUNK_SIZE = 1024;
    static final int MAX_CHUNK_SIZE = 16384;
    private Node _bufferHead;
    private Node _bufferTail;
    private int _bufferedEntryCount;
    private Object[] _freeBuffer;

    public Object[] resetAndStart() {
        if (this._bufferedEntryCount > 0) {
            this._reset();
        }
        if (this._freeBuffer == null) {
            return new Object[1024];
        }
        return this._freeBuffer;
    }

    public Object[] appendCompletedChunk(Object[] fullChunk) {
        Node next = new Node(fullChunk);
        if (this._bufferHead == null) {
            this._bufferHead = this._bufferTail = next;
        } else {
            this._bufferTail.linkNext(next);
            this._bufferTail = next;
        }
        int len = fullChunk.length;
        this._bufferedEntryCount += len;
        len = len < 16384 ? (len += len) : (len += len >> 2);
        return new Object[len];
    }

    public Object[] completeAndClearBuffer(Object[] lastChunk, int lastChunkEntries) {
        int totalSize = lastChunkEntries + this._bufferedEntryCount;
        Object[] result = new Object[totalSize];
        this._copyTo(result, totalSize, lastChunk, lastChunkEntries);
        this._reset();
        return result;
    }

    public int initialCapacity() {
        return this._freeBuffer == null ? 0 : this._freeBuffer.length;
    }

    public int bufferedSize() {
        return this._bufferedEntryCount;
    }

    private void _reset() {
        if (this._bufferedEntryCount > 0) {
            if (this._bufferTail != null) {
                Object[] obs = this._bufferTail.getData();
                Arrays.fill(obs, null);
                this._freeBuffer = obs;
            }
            this._bufferTail = null;
            this._bufferHead = null;
            this._bufferedEntryCount = 0;
        }
    }

    private final void _copyTo(Object resultArray, int totalSize, Object[] lastChunk, int lastChunkEntries) {
        int ptr = 0;
        for (Node n = this._bufferHead; n != null; n = n.next()) {
            Object[] curr = n.getData();
            int len = curr.length;
            System.arraycopy(curr, 0, resultArray, ptr, len);
            ptr += len;
        }
        System.arraycopy(lastChunk, 0, resultArray, ptr, lastChunkEntries);
        if ((ptr += lastChunkEntries) != totalSize) {
            throw new IllegalStateException("Should have gotten " + totalSize + " entries, got " + ptr);
        }
    }

    private static final class Node {
        private final Object[] _data;
        private Node _next;

        public Node(Object[] data) {
            this._data = data;
        }

        public Object[] getData() {
            return this._data;
        }

        public Node next() {
            return this._next;
        }

        public void linkNext(Node next) {
            if (this._next != null) {
                throw new IllegalStateException();
            }
            this._next = next;
        }
    }
}

