/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.sort.std;

import com.fasterxml.sort.DataReader;
import com.fasterxml.sort.DataReaderFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class RawTextLineReader
extends DataReader<byte[]> {
    protected static final byte BYTE_CR = 13;
    protected static final byte BYTE_LF = 10;
    protected final InputStream _in;
    protected boolean _closed = false;
    protected byte[] _inputBuffer = new byte[16000];
    protected int _inputPtr = 0;
    protected int _inputEnd = 0;
    protected boolean _hadCR = false;
    protected ByteArrayOutputStream _tmpBytes;

    public RawTextLineReader(InputStream in) {
        this._in = in;
    }

    public static Factory factory() {
        return new Factory();
    }

    @Override
    public void close() throws IOException {
        if (!this._closed) {
            this._closed = true;
            this._in.close();
        }
    }

    @Override
    public int estimateSizeInBytes(byte[] item) {
        int bytes = item.length;
        bytes = bytes + 3 >> 2 << 2;
        return 16 + bytes;
    }

    @Override
    public byte[] readNext() throws IOException {
        if (this._closed) {
            return null;
        }
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            this.close();
            return null;
        }
        if (this._hadCR && !this._skipLF()) {
            return null;
        }
        int start = this._inputPtr;
        int end = this._inputEnd;
        while (this._inputPtr < end) {
            byte b;
            if ((b = this._inputBuffer[this._inputPtr++]) != 13 && b != 10) continue;
            this._hadCR = b == 13;
            return Arrays.copyOfRange(this._inputBuffer, start, this._inputPtr - 1);
        }
        return this._readNextSlow(start);
    }

    protected final byte[] _readNextSlow(int start) throws IOException {
        ByteArrayOutputStream bytes = this._tmpBytes;
        if (bytes == null) {
            this._tmpBytes = bytes = new ByteArrayOutputStream();
        } else {
            bytes.reset();
        }
        bytes.write(this._inputBuffer, start, this._inputEnd - start);
        block0: while (true) {
            if (!this._loadMore()) {
                this.close();
                break;
            }
            int end = this._inputEnd;
            for (int i = 0; i < end; ++i) {
                byte b;
                if ((b = this._inputBuffer[this._inputPtr++]) != 13 && b != 10) continue;
                this._hadCR = b == 13;
                bytes.write(this._inputBuffer, 0, this._inputPtr - 1);
                break block0;
            }
            bytes.write(this._inputBuffer, 0, this._inputEnd);
        }
        return bytes.toByteArray();
    }

    protected boolean _loadMore() throws IOException {
        int count = this._in.read(this._inputBuffer);
        if (count < 0) {
            return false;
        }
        this._inputPtr = 0;
        this._inputEnd = count;
        return true;
    }

    protected boolean _skipLF() throws IOException {
        this._hadCR = false;
        if (this._inputBuffer[this._inputPtr] == 10) {
            ++this._inputPtr;
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this.close();
                return false;
            }
        }
        return true;
    }

    public static class Factory
    extends DataReaderFactory<byte[]> {
        @Override
        public DataReader<byte[]> constructReader(InputStream in) {
            return new RawTextLineReader(in);
        }
    }
}

