/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.scala.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import scala.Function1;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.reflect.package$;

@ScalaSignature(bytes="\u0006\u0001!4QAB\u0004\u0002\nQA\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tw\u0001\u0011\u0019\u0011)A\u0006y!)!\t\u0001C\u0001\u0007\")\u0011\n\u0001C!\u0015\")\u0011\f\u0001C!5\n)\")[4Ok6\u0014WM\u001d#fg\u0016\u0014\u0018.\u00197ju\u0016\u0014(B\u0001\u0005\n\u0003\u0015!Wm]3s\u0015\tQ1\"A\u0003tG\u0006d\u0017M\u0003\u0002\r\u001b\u00051Qn\u001c3vY\u0016T!AD\b\u0002\u000f)\f7m[:p]*\u0011\u0001#E\u0001\nM\u0006\u001cH/\u001a:y[2T\u0011AE\u0001\u0004G>l7\u0001A\u000b\u0003+\u0005\u001a\"\u0001\u0001\f\u0011\u0007]ir$D\u0001\u0019\u0015\tI\"$A\u0002ti\u0012T!\u0001C\u000e\u000b\u0005qi\u0011\u0001\u00033bi\u0006\u0014\u0017N\u001c3\n\u0005yA\"!F*uIN\u001b\u0017\r\\1s\t\u0016\u001cXM]5bY&TXM\u001d\t\u0003A\u0005b\u0001\u0001B\u0003#\u0001\t\u00071EA\u0001U#\t!\u0013\u0006\u0005\u0002&O5\taEC\u0001\u000b\u0013\tAcE\u0001\u0003Ok2d\u0007CA\u0013+\u0013\tYcEA\u0002B]f\fqa\u0019:fCR|'\u000f\u0005\u0003&]Az\u0012BA\u0018'\u0005%1UO\\2uS>t\u0017\u0007\u0005\u00022q9\u0011!G\u000e\t\u0003g\u0019j\u0011\u0001\u000e\u0006\u0003kM\ta\u0001\u0010:p_Rt\u0014BA\u001c'\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011H\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005]2\u0013AC3wS\u0012,gnY3%cA\u0019Q\bQ\u0010\u000e\u0003yR!a\u0010\u0014\u0002\u000fI,g\r\\3di&\u0011\u0011I\u0010\u0002\t\u00072\f7o\u001d+bO\u00061A(\u001b8jiz\"\"\u0001\u0012%\u0015\u0005\u0015;\u0005c\u0001$\u0001?5\tq\u0001C\u0003<\u0007\u0001\u000fA\bC\u0003-\u0007\u0001\u0007Q&A\u0006eKN,'/[1mSj,GcA\u0010L'\")A\n\u0002a\u0001\u001b\u0006\u0011!\u000e\u001d\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!6\tAaY8sK&\u0011!k\u0014\u0002\u000b\u0015N|g\u000eU1sg\u0016\u0014\b\"\u0002+\u0005\u0001\u0004)\u0016\u0001B2uqR\u0004\"AV,\u000e\u0003mI!\u0001W\u000e\u0003-\u0011+7/\u001a:jC2L'0\u0019;j_:\u001cuN\u001c;fqR\fAbZ3u\u001dVdGNV1mk\u0016$\"a\u00174\u0013\u0007q{bL\u0002\u0003^\u0001\u0001Y&\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004CA0e\u001b\u0005\u0001'BA1c\u0003\u0011a\u0017M\\4\u000b\u0003\r\fAA[1wC&\u0011Q\r\u0019\u0002\u0007\u001f\nTWm\u0019;\t\u000b\u001d,\u0001\u0019A+\u0002\u0007\r$\b\u0010")
public abstract class BigNumberDeserializer<T>
extends StdScalarDeserializer<T> {
    private final Function1<String, T> creator;

    public T deserialize(JsonParser jp, DeserializationContext ctxt) {
        Object object;
        JsonToken t = jp.getCurrentToken();
        JsonToken jsonToken = t;
        boolean bl = JsonToken.VALUE_NUMBER_INT.equals(jsonToken) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken);
        if (bl) {
            object = this.creator.apply((Object)jp.getText().trim());
        } else if (JsonToken.VALUE_STRING.equals(jsonToken)) {
            Object object2;
            String text = jp.getText().trim();
            if (text.isEmpty()) {
                object2 = null;
            } else {
                try {
                    object2 = this.creator.apply((Object)text);
                }
                catch (IllegalArgumentException e) {
                    throw ctxt.weirdStringException(text, this._valueClass, "not a valid representation");
                }
            }
            object = object2;
        } else if (JsonToken.START_ARRAY.equals(jsonToken) && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jp.nextToken();
            T value = this.deserialize(jp, ctxt);
            JsonToken jsonToken2 = jp.nextToken();
            JsonToken jsonToken3 = JsonToken.END_ARRAY;
            if (jsonToken2 == null ? jsonToken3 != null : !jsonToken2.equals(jsonToken3)) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "Attempted to unwrap array for single value but there was more than a single value in the array");
            }
            object = value;
        } else {
            object = ctxt.handleUnexpectedToken(this._valueClass, jp);
        }
        return (T)object;
    }

    public Object getNullValue(DeserializationContext ctx) {
        return super.getNullValue();
    }

    public BigNumberDeserializer(Function1<String, T> creator, ClassTag<T> evidence$1) {
        this.creator = creator;
        super(package$.MODULE$.classTag(evidence$1).runtimeClass());
    }
}

