/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.parquetio.reader.converter;

import com.exasol.parquetio.reader.converter.ParquetConverter;
import com.exasol.parquetio.reader.converter.ParquetDecimalConverter$;
import com.exasol.parquetio.reader.converter.ValueHolder;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\u0015c\u0001B\u0015+\u0005VB\u0001B\u0017\u0001\u0003\u0016\u0004%\ta\u0017\u0005\tE\u0002\u0011\t\u0012)A\u00059\"A1\r\u0001BK\u0002\u0013\u0005A\r\u0003\u0005i\u0001\tE\t\u0015!\u0003f\u0011!I\u0007A!f\u0001\n\u0003Q\u0007\u0002\u00038\u0001\u0005#\u0005\u000b\u0011B6\t\u000b=\u0004A\u0011\u00019\t\rU\u0004\u0001\u0015!\u0003w\u0011\u001d\tY\u0001\u0001Q\u0001\n\u0015Dq!!\u0004\u0001A\u0003%Q\r\u0003\u0005\u0002\u0010\u0001\u0001\u000b\u0015BA\t\u0011\u001d\t9\u0003\u0001C!\u0003SAq!!\r\u0001\t\u0003\n\u0019\u0004\u0003\u0005\u0002L\u0001\u0001K\u0011BA'\u0011!\t)\u0006\u0001Q\u0005\n\u0005]\u0003\u0002CA2\u0001\u0001&I!!\u001a\t\u000f\u0005=\u0004\u0001\"\u0011\u0002r!9\u0011Q\u000f\u0001\u0005B\u0005]\u0004bBA>\u0001\u0011\u0005\u0013Q\u0010\u0005\b\u0003\u0003\u0003A\u0011IAB\u0011%\tI\tAA\u0001\n\u0003\tY\tC\u0005\u0002\u0014\u0002\t\n\u0011\"\u0001\u0002\u0016\"I\u00111\u0016\u0001\u0012\u0002\u0013\u0005\u0011Q\u0016\u0005\n\u0003c\u0003\u0011\u0013!C\u0001\u0003gC\u0011\"a.\u0001\u0003\u0003%\t%!/\t\u0011\u0005\u001d\u0007!!A\u0005\u0002\u0011D\u0011\"!3\u0001\u0003\u0003%\t!a3\t\u0013\u0005]\u0007!!A\u0005B\u0005e\u0007\"CAt\u0001\u0005\u0005I\u0011AAu\u0011%\ti\u000fAA\u0001\n\u0003\ny\u000fC\u0005\u0002t\u0002\t\t\u0011\"\u0011\u0002v\"I\u0011q\u001f\u0001\u0002\u0002\u0013\u0005\u0013\u0011 \u0005\n\u0003w\u0004\u0011\u0011!C!\u0003{<\u0011B!\u0001+\u0003\u0003E\tAa\u0001\u0007\u0011%R\u0013\u0011!E\u0001\u0005\u000bAaa\\\u0012\u0005\u0002\tm\u0001\"CA|G\u0005\u0005IQIA}\u0011%\u0011ibIA\u0001\n\u0003\u0013y\u0002C\u0005\u0003(\r\n\t\u0011\"!\u0003*!I!1H\u0012\u0002\u0002\u0013%!Q\b\u0002\u0018!\u0006\u0014\u0018/^3u\t\u0016\u001c\u0017.\\1m\u0007>tg/\u001a:uKJT!a\u000b\u0017\u0002\u0013\r|gN^3si\u0016\u0014(BA\u0017/\u0003\u0019\u0011X-\u00193fe*\u0011q\u0006M\u0001\na\u0006\u0014\u0018/^3uS>T!!\r\u001a\u0002\r\u0015D\u0018m]8m\u0015\u0005\u0019\u0014aA2p[\u000e\u00011#\u0002\u00017\t\"s\u0005CA\u001cC\u001b\u0005A$BA\u001d;\u0003\r\t\u0007/\u001b\u0006\u0003wq\n!![8\u000b\u0005ur\u0014a\u00029beF,X\r\u001e\u0006\u0003\u007f\u0001\u000ba!\u00199bG\",'\"A!\u0002\u0007=\u0014x-\u0003\u0002Dq\t\u0011\u0002K]5nSRLg/Z\"p]Z,'\u000f^3s!\t)e)D\u0001+\u0013\t9%F\u0001\tQCJ\fX/\u001a;D_:4XM\u001d;feB\u0011\u0011\nT\u0007\u0002\u0015*\t1*A\u0003tG\u0006d\u0017-\u0003\u0002N\u0015\n9\u0001K]8ek\u000e$\bCA(X\u001d\t\u0001VK\u0004\u0002R)6\t!K\u0003\u0002Ti\u00051AH]8pizJ\u0011aS\u0005\u0003-*\u000bq\u0001]1dW\u0006<W-\u0003\u0002Y3\na1+\u001a:jC2L'0\u00192mK*\u0011aKS\u0001\u000eaJLW.\u001b;jm\u0016$\u0016\u0010]3\u0016\u0003q\u0003\"!\u00181\u000e\u0003yS!a\u0018\u001f\u0002\rM\u001c\u0007.Z7b\u0013\t\tgLA\u0007Qe&l\u0017\u000e^5wKRK\b/Z\u0001\u000faJLW.\u001b;jm\u0016$\u0016\u0010]3!\u0003\u0015Ig\u000eZ3y+\u0005)\u0007CA%g\u0013\t9'JA\u0002J]R\fa!\u001b8eKb\u0004\u0013A\u00025pY\u0012,'/F\u0001l!\t)E.\u0003\u0002nU\tYa+\u00197vK\"{G\u000eZ3s\u0003\u001dAw\u000e\u001c3fe\u0002\na\u0001P5oSRtD\u0003B9sgR\u0004\"!\u0012\u0001\t\u000bi;\u0001\u0019\u0001/\t\u000b\r<\u0001\u0019A3\t\u000b%<\u0001\u0019A6\u0002\u0017\u0011,7-[7bYRK\b/\u001a\t\u0004o\u0006\u0015ab\u0001=\u0002\u00029\u0011\u0011p \b\u0003uzt!a_?\u000f\u0005Ec\u0018\"A!\n\u0005}\u0002\u0015BA\u001f?\u0013\tyF(C\u0002\u0002\u0004y\u000bQ\u0003T8hS\u000e\fG\u000eV=qK\u0006sgn\u001c;bi&|g.\u0003\u0003\u0002\b\u0005%!\u0001\b#fG&l\u0017\r\u001c'pO&\u001c\u0017\r\u001c+za\u0016\feN\\8uCRLwN\u001c\u0006\u0004\u0003\u0007q\u0016!\u00039sK\u000eL7/[8o\u0003\u0015\u00198-\u00197f\u0003E!WmY8eK\u0012$\u0015n\u0019;j_:\f'/\u001f\t\u0006\u0013\u0006M\u0011qC\u0005\u0004\u0003+Q%!B!se\u0006L\b\u0003BA\r\u0003Gi!!a\u0007\u000b\t\u0005u\u0011qD\u0001\u0005[\u0006$\bN\u0003\u0002\u0002\"\u0005!!.\u0019<b\u0013\u0011\t)#a\u0007\u0003\u0015\tKw\rR3dS6\fG.\u0001\u000biCN$\u0015n\u0019;j_:\f'/_*vaB|'\u000f\u001e\u000b\u0003\u0003W\u00012!SA\u0017\u0013\r\tyC\u0013\u0002\b\u0005>|G.Z1o\u00035\u0019X\r\u001e#jGRLwN\\1ssR!\u0011QGA\u001e!\rI\u0015qG\u0005\u0004\u0003sQ%\u0001B+oSRDq!!\u0010\u000e\u0001\u0004\ty$\u0001\u0006eS\u000e$\u0018n\u001c8bef\u0004B!!\u0011\u0002H5\u0011\u00111\t\u0006\u0004\u0003\u000bb\u0014AB2pYVlg.\u0003\u0003\u0002J\u0005\r#A\u0003#jGRLwN\\1ss\u0006\u0011r-\u001a;EK\u000eLW.\u00197Ge>lG+\u001f9f)\u0019\t9\"a\u0014\u0002R!9\u0011Q\b\bA\u0002\u0005}\u0002BBA*\u001d\u0001\u0007Q-A\u0001j\u0003I9W\r\u001e#fG&l\u0017\r\u001c$s_6duN\\4\u0015\t\u0005]\u0011\u0011\f\u0005\b\u00037z\u0001\u0019AA/\u0003\u00151\u0018\r\\;f!\rI\u0015qL\u0005\u0004\u0003CR%\u0001\u0002'p]\u001e\fAcZ3u\t\u0016\u001c\u0017.\\1m\rJ|WNQ5oCJLH\u0003BA\f\u0003OBq!a\u0017\u0011\u0001\u0004\tI\u0007E\u00028\u0003WJ1!!\u001c9\u0005\u0019\u0011\u0015N\\1ss\u00061\u0011\r\u001a3J]R$B!!\u000e\u0002t!1\u00111L\tA\u0002\u0015\fq!\u00193e\u0019>tw\r\u0006\u0003\u00026\u0005e\u0004bBA.%\u0001\u0007\u0011QL\u0001\nC\u0012$')\u001b8bef$B!!\u000e\u0002\u0000!9\u00111L\nA\u0002\u0005%\u0014AF1eIZ\u000bG.^3Ge>lG)[2uS>t\u0017M]=\u0015\t\u0005U\u0012Q\u0011\u0005\u0007\u0003\u000f#\u0002\u0019A3\u0002\u0019\u0011L7\r^5p]\u0006\u0014\u00180\u00133\u0002\t\r|\u0007/\u001f\u000b\bc\u00065\u0015qRAI\u0011\u001dQV\u0003%AA\u0002qCqaY\u000b\u0011\u0002\u0003\u0007Q\rC\u0004j+A\u0005\t\u0019A6\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0013\u0016\u00049\u0006e5FAAN!\u0011\ti*a*\u000e\u0005\u0005}%\u0002BAQ\u0003G\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015&*\u0001\u0006b]:|G/\u0019;j_:LA!!+\u0002 \n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u0016\u0016\u0004K\u0006e\u0015AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003kS3a[AM\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u0018\t\u0005\u0003{\u000b\u0019-\u0004\u0002\u0002@*!\u0011\u0011YA\u0010\u0003\u0011a\u0017M\\4\n\t\u0005\u0015\u0017q\u0018\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QZAj!\rI\u0015qZ\u0005\u0004\u0003#T%aA!os\"A\u0011Q[\u000e\u0002\u0002\u0003\u0007Q-A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u00037\u0004b!!8\u0002d\u00065WBAAp\u0015\r\t\tOS\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAs\u0003?\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u00111FAv\u0011%\t).HA\u0001\u0002\u0004\ti-\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA^\u0003cD\u0001\"!6\u001f\u0003\u0003\u0005\r!Z\u0001\tQ\u0006\u001c\bnQ8eKR\tQ-\u0001\u0005u_N#(/\u001b8h)\t\tY,\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003W\ty\u0010C\u0005\u0002V\u0006\n\t\u00111\u0001\u0002N\u00069\u0002+\u0019:rk\u0016$H)Z2j[\u0006d7i\u001c8wKJ$XM\u001d\t\u0003\u000b\u000e\u001aRa\tB\u0004\u0005'\u0001\u0002B!\u0003\u0003\u0010q+7.]\u0007\u0003\u0005\u0017Q1A!\u0004K\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\u0005\u0003\f\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0011\t\tU!\u0011D\u0007\u0003\u0005/Q1aOA\u0010\u0013\rA&q\u0003\u000b\u0003\u0005\u0007\tQ!\u00199qYf$r!\u001dB\u0011\u0005G\u0011)\u0003C\u0003[M\u0001\u0007A\fC\u0003dM\u0001\u0007Q\rC\u0003jM\u0001\u00071.A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t-\"q\u0007\t\u0006\u0013\n5\"\u0011G\u0005\u0004\u0005_Q%AB(qi&|g\u000e\u0005\u0004J\u0005gaVm[\u0005\u0004\u0005kQ%A\u0002+va2,7\u0007\u0003\u0005\u0003:\u001d\n\t\u00111\u0001r\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005\u007f\u0001B!!0\u0003B%!!1IA`\u0005\u0019y%M[3di\u0002")
public final class ParquetDecimalConverter
extends PrimitiveConverter
implements ParquetConverter,
Product,
Serializable {
    private final PrimitiveType primitiveType;
    private final int index;
    private final ValueHolder holder;
    private final LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalType;
    private final int precision;
    private final int scale;
    private BigDecimal[] decodedDictionary;

    public static Option<Tuple3<PrimitiveType, Object, ValueHolder>> unapply(ParquetDecimalConverter x$0) {
        return ParquetDecimalConverter$.MODULE$.unapply(x$0);
    }

    public static ParquetDecimalConverter apply(PrimitiveType primitiveType, int index, ValueHolder holder) {
        return ParquetDecimalConverter$.MODULE$.apply(primitiveType, index, holder);
    }

    public static Function1<Tuple3<PrimitiveType, Object, ValueHolder>, ParquetDecimalConverter> tupled() {
        return ParquetDecimalConverter$.MODULE$.tupled();
    }

    public static Function1<PrimitiveType, Function1<Object, Function1<ValueHolder, ParquetDecimalConverter>>> curried() {
        return ParquetDecimalConverter$.MODULE$.curried();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public void parentStart() {
        ParquetConverter.parentStart$(this);
    }

    @Override
    public void parentEnd() {
        ParquetConverter.parentEnd$(this);
    }

    public PrimitiveType primitiveType() {
        return this.primitiveType;
    }

    public int index() {
        return this.index;
    }

    public ValueHolder holder() {
        return this.holder;
    }

    public boolean hasDictionarySupport() {
        return true;
    }

    public void setDictionary(Dictionary dictionary) {
        this.decodedDictionary = new BigDecimal[dictionary.getMaxId() + 1];
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), dictionary.getMaxId()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            $this.decodedDictionary[i] = this.getDecimalFromType(dictionary, i);
        });
    }

    private BigDecimal getDecimalFromType(Dictionary dictionary, int i) {
        PrimitiveType.PrimitiveTypeName primitiveTypeName = this.primitiveType().getPrimitiveTypeName();
        if (PrimitiveType.PrimitiveTypeName.INT32.equals(primitiveTypeName)) {
            return this.getDecimalFromLong(dictionary.decodeToInt(i));
        }
        if (PrimitiveType.PrimitiveTypeName.INT64.equals(primitiveTypeName)) {
            return this.getDecimalFromLong(dictionary.decodeToLong(i));
        }
        if (PrimitiveType.PrimitiveTypeName.BINARY.equals(primitiveTypeName)) {
            return this.getDecimalFromBinary(dictionary.decodeToBinary(i));
        }
        if (PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY.equals(primitiveTypeName)) {
            return this.getDecimalFromBinary(dictionary.decodeToBinary(i));
        }
        throw new UnsupportedOperationException("Cannot convert parquet type to decimal type. Please check that Parquet decimal type is stored as INT32, INT64, BINARY or FIXED_LEN_BYTE_ARRAY.");
    }

    private BigDecimal getDecimalFromLong(long value) {
        return BigDecimal.valueOf(value, this.scale);
    }

    private BigDecimal getDecimalFromBinary(Binary value) {
        BigInteger bigInteger = new BigInteger(value.getBytes());
        return new BigDecimal(bigInteger, this.scale, new MathContext(this.precision));
    }

    public void addInt(int value) {
        this.holder().put(this.index(), this.getDecimalFromLong(value));
    }

    public void addLong(long value) {
        this.holder().put(this.index(), this.getDecimalFromLong(value));
    }

    public void addBinary(Binary value) {
        this.holder().put(this.index(), this.getDecimalFromBinary(value));
    }

    public void addValueFromDictionary(int dictionaryId) {
        this.holder().put(this.index(), this.decodedDictionary[dictionaryId]);
    }

    public ParquetDecimalConverter copy(PrimitiveType primitiveType, int index, ValueHolder holder) {
        return new ParquetDecimalConverter(primitiveType, index, holder);
    }

    public PrimitiveType copy$default$1() {
        return this.primitiveType();
    }

    public int copy$default$2() {
        return this.index();
    }

    public ValueHolder copy$default$3() {
        return this.holder();
    }

    public String productPrefix() {
        return "ParquetDecimalConverter";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.primitiveType();
            }
            case 1: {
                return BoxesRunTime.boxToInteger((int)this.index());
            }
            case 2: {
                return this.holder();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParquetDecimalConverter;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "primitiveType";
            }
            case 1: {
                return "index";
            }
            case 2: {
                return "holder";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.primitiveType()));
        n = Statics.mix((int)n, (int)this.index());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.holder()));
        return Statics.finalizeHash((int)n, (int)3);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParquetDecimalConverter)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParquetDecimalConverter parquetDecimalConverter = (ParquetDecimalConverter)x$1;
        if (this.index() != parquetDecimalConverter.index()) return false;
        PrimitiveType primitiveType = this.primitiveType();
        PrimitiveType primitiveType2 = parquetDecimalConverter.primitiveType();
        if (primitiveType == null) {
            if (primitiveType2 != null) {
                return false;
            }
        } else if (!primitiveType.equals(primitiveType2)) return false;
        ValueHolder valueHolder = this.holder();
        ValueHolder valueHolder2 = parquetDecimalConverter.holder();
        if (valueHolder == null) {
            if (valueHolder2 == null) return true;
            return false;
        } else {
            if (!valueHolder.equals(valueHolder2)) return false;
            return true;
        }
    }

    public ParquetDecimalConverter(PrimitiveType primitiveType, int index, ValueHolder holder) {
        this.primitiveType = primitiveType;
        this.index = index;
        this.holder = holder;
        ParquetConverter.$init$(this);
        Product.$init$((Product)this);
        this.decimalType = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)primitiveType.getLogicalTypeAnnotation();
        this.precision = this.decimalType.getPrecision();
        this.scale = this.decimalType.getScale();
        this.decodedDictionary = null;
    }
}

