/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.maestro.model;

import com.docusign.maestro.model.ProgressInstance;
import com.docusign.maestro.model.StartedByInstance;
import com.docusign.maestro.model.WorkflowInstanceState;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Schema(description="Details of a Workflow Instance triggered for a Workflow Definition")
public class WorkflowInstance
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="accountId")
    private String accountId = null;
    @JsonProperty(value="creatorId")
    private String creatorId = null;
    @JsonProperty(value="dacId")
    private String dacId = null;
    @JsonProperty(value="endDate")
    private String endDate = null;
    @JsonProperty(value="instanceName")
    private String instanceName = null;
    @JsonProperty(value="instanceState")
    private WorkflowInstanceState instanceState = null;
    @JsonProperty(value="progress")
    private ProgressInstance progress = null;
    @JsonProperty(value="startDate")
    private String startDate = null;
    @JsonProperty(value="startedBy")
    private StartedByInstance startedBy = null;
    @JsonProperty(value="templateId")
    private String templateId = null;
    @JsonProperty(value="users")
    private Map<String, String> users = new HashMap<String, String>();

    public WorkflowInstance accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Schema(description="")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public WorkflowInstance creatorId(String creatorId) {
        this.creatorId = creatorId;
        return this;
    }

    @Schema(required=true, description="")
    public String getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public WorkflowInstance dacId(String dacId) {
        this.dacId = dacId;
        return this;
    }

    @Schema(required=true, description="")
    public String getDacId() {
        return this.dacId;
    }

    public void setDacId(String dacId) {
        this.dacId = dacId;
    }

    public WorkflowInstance endDate(String endDate) {
        this.endDate = endDate;
        return this;
    }

    @Schema(description="Track the End time of the Workflow Instance")
    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public WorkflowInstance instanceName(String instanceName) {
        this.instanceName = instanceName;
        return this;
    }

    @Schema(description="The friendly name of the particular workflow instance")
    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public WorkflowInstance instanceState(WorkflowInstanceState instanceState) {
        this.instanceState = instanceState;
        return this;
    }

    @Schema(required=true, description="")
    public WorkflowInstanceState getInstanceState() {
        return this.instanceState;
    }

    public void setInstanceState(WorkflowInstanceState instanceState) {
        this.instanceState = instanceState;
    }

    public WorkflowInstance progress(ProgressInstance progress) {
        this.progress = progress;
        return this;
    }

    @Schema(description="")
    public ProgressInstance getProgress() {
        return this.progress;
    }

    public void setProgress(ProgressInstance progress) {
        this.progress = progress;
    }

    public WorkflowInstance startDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    @Schema(description="Track the Start time of the Workflow Instance")
    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public WorkflowInstance startedBy(StartedByInstance startedBy) {
        this.startedBy = startedBy;
        return this;
    }

    @Schema(description="")
    public StartedByInstance getStartedBy() {
        return this.startedBy;
    }

    public void setStartedBy(StartedByInstance startedBy) {
        this.startedBy = startedBy;
    }

    public WorkflowInstance templateId(String templateId) {
        this.templateId = templateId;
        return this;
    }

    @Schema(required=true, description="")
    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public WorkflowInstance users(Map<String, String> users) {
        this.users = users;
        return this;
    }

    public WorkflowInstance putUsersItem(String key, String usersItem) {
        this.users.put(key, usersItem);
        return this;
    }

    @Schema(required=true, description="Contains the list of Users and Steps mapping")
    public Map<String, String> getUsers() {
        return this.users;
    }

    public void setUsers(Map<String, String> users) {
        this.users = users;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowInstance workflowInstance = (WorkflowInstance)o;
        return Objects.equals(this.accountId, workflowInstance.accountId) && Objects.equals(this.creatorId, workflowInstance.creatorId) && Objects.equals(this.dacId, workflowInstance.dacId) && Objects.equals(this.endDate, workflowInstance.endDate) && Objects.equals(this.instanceName, workflowInstance.instanceName) && Objects.equals((Object)this.instanceState, (Object)workflowInstance.instanceState) && Objects.equals(this.progress, workflowInstance.progress) && Objects.equals(this.startDate, workflowInstance.startDate) && Objects.equals(this.startedBy, workflowInstance.startedBy) && Objects.equals(this.templateId, workflowInstance.templateId) && Objects.equals(this.users, workflowInstance.users);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.creatorId, this.dacId, this.endDate, this.instanceName, this.instanceState, this.progress, this.startDate, this.startedBy, this.templateId, this.users});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkflowInstance {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    creatorId: ").append(this.toIndentedString(this.creatorId)).append("\n");
        sb.append("    dacId: ").append(this.toIndentedString(this.dacId)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    instanceName: ").append(this.toIndentedString(this.instanceName)).append("\n");
        sb.append("    instanceState: ").append(this.toIndentedString((Object)this.instanceState)).append("\n");
        sb.append("    progress: ").append(this.toIndentedString(this.progress)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    startedBy: ").append(this.toIndentedString(this.startedBy)).append("\n");
        sb.append("    templateId: ").append(this.toIndentedString(this.templateId)).append("\n");
        sb.append("    users: ").append(this.toIndentedString(this.users)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

