/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.maestro.api;

import com.docusign.maestro.client.ApiClient;
import com.docusign.maestro.client.ApiException;
import com.docusign.maestro.client.ApiResponse;
import com.docusign.maestro.client.Configuration;
import com.docusign.maestro.client.Pair;
import com.docusign.maestro.model.CreateOrUpdateWorkflowDefinitionRequestBody;
import com.docusign.maestro.model.DeployRequest;
import com.docusign.maestro.model.DeployResponse;
import com.docusign.maestro.model.GetConfigurationInstancesResponse;
import com.docusign.maestro.model.NewOrUpdatedWorkflowDefinitionResponse;
import com.docusign.maestro.model.WorkflowDefinitionList;
import com.docusign.maestro.model.WorkflowDefinitionWithId;
import com.docusign.maestro.model.WorkflowDeleteResponse;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;

public class WorkflowManagementApi {
    private ApiClient apiClient;

    public WorkflowManagementApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WorkflowManagementApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public NewOrUpdatedWorkflowDefinitionResponse createWorkflowDefinition(String accountId, CreateOrUpdateWorkflowDefinitionRequestBody body) throws ApiException {
        ApiResponse<NewOrUpdatedWorkflowDefinitionResponse> localVarResponse = this.createWorkflowDefinitionWithHttpInfo(accountId, body);
        return localVarResponse.getData();
    }

    public ApiResponse<NewOrUpdatedWorkflowDefinitionResponse> createWorkflowDefinitionWithHttpInfo(String accountId, CreateOrUpdateWorkflowDefinitionRequestBody body) throws ApiException {
        CreateOrUpdateWorkflowDefinitionRequestBody localVarPostBody = body;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createWorkflowDefinition");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createWorkflowDefinition");
        }
        String localVarPath = "/v1/accounts/{accountId}/management/workflow_definitions".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<NewOrUpdatedWorkflowDefinitionResponse> localVarReturnType = new GenericType<NewOrUpdatedWorkflowDefinitionResponse>(){};
        NewOrUpdatedWorkflowDefinitionResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<NewOrUpdatedWorkflowDefinitionResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public WorkflowDeleteResponse deleteWorkflowDefinition(String accountId, String workflowDefinitionId) throws ApiException {
        ApiResponse<WorkflowDeleteResponse> localVarResponse = this.deleteWorkflowDefinitionWithHttpInfo(accountId, workflowDefinitionId);
        return localVarResponse.getData();
    }

    public ApiResponse<WorkflowDeleteResponse> deleteWorkflowDefinitionWithHttpInfo(String accountId, String workflowDefinitionId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteWorkflowDefinition");
        }
        if (workflowDefinitionId == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowDefinitionId' when calling deleteWorkflowDefinition");
        }
        String localVarPath = "/v1/accounts/{accountId}/management/workflow_definitions/{workflowDefinitionId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{workflowDefinitionId\\}", this.apiClient.escapeString(workflowDefinitionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<WorkflowDeleteResponse> localVarReturnType = new GenericType<WorkflowDeleteResponse>(){};
        WorkflowDeleteResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<WorkflowDeleteResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public WorkflowDefinitionWithId getWorkflowDefinition(String accountId, String workflowDefinitionId) throws ApiException {
        return this.getWorkflowDefinition(accountId, workflowDefinitionId, null);
    }

    public WorkflowDefinitionWithId getWorkflowDefinition(String accountId, String workflowDefinitionId, GetWorkflowDefinitionOptions options) throws ApiException {
        ApiResponse<WorkflowDefinitionWithId> localVarResponse = this.getWorkflowDefinitionWithHttpInfo(accountId, workflowDefinitionId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<WorkflowDefinitionWithId> getWorkflowDefinitionWithHttpInfo(String accountId, String workflowDefinitionId, GetWorkflowDefinitionOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getWorkflowDefinition");
        }
        if (workflowDefinitionId == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowDefinitionId' when calling getWorkflowDefinition");
        }
        String localVarPath = "/v1/accounts/{accountId}/management/workflow_definitions/{workflowDefinitionId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{workflowDefinitionId\\}", this.apiClient.escapeString(workflowDefinitionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("lastDeployedId", options.lastDeployedId));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<WorkflowDefinitionWithId> localVarReturnType = new GenericType<WorkflowDefinitionWithId>(){};
        WorkflowDefinitionWithId localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<WorkflowDefinitionWithId>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public GetConfigurationInstancesResponse getWorkflowDefinitionConfigInstances(String accountId, String workflowDefinitionId) throws ApiException {
        ApiResponse<GetConfigurationInstancesResponse> localVarResponse = this.getWorkflowDefinitionConfigInstancesWithHttpInfo(accountId, workflowDefinitionId);
        return localVarResponse.getData();
    }

    public ApiResponse<GetConfigurationInstancesResponse> getWorkflowDefinitionConfigInstancesWithHttpInfo(String accountId, String workflowDefinitionId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getWorkflowDefinitionConfigInstances");
        }
        if (workflowDefinitionId == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowDefinitionId' when calling getWorkflowDefinitionConfigInstances");
        }
        String localVarPath = "/v1/accounts/{accountId}/management/workflow_definitions/{workflowDefinitionId}/config_instances".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{workflowDefinitionId\\}", this.apiClient.escapeString(workflowDefinitionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<GetConfigurationInstancesResponse> localVarReturnType = new GenericType<GetConfigurationInstancesResponse>(){};
        GetConfigurationInstancesResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<GetConfigurationInstancesResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public WorkflowDefinitionList getWorkflowDefinitions(String accountId) throws ApiException {
        return this.getWorkflowDefinitions(accountId, null);
    }

    public WorkflowDefinitionList getWorkflowDefinitions(String accountId, GetWorkflowDefinitionsOptions options) throws ApiException {
        ApiResponse<WorkflowDefinitionList> localVarResponse = this.getWorkflowDefinitionsWithHttpInfo(accountId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<WorkflowDefinitionList> getWorkflowDefinitionsWithHttpInfo(String accountId, GetWorkflowDefinitionsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getWorkflowDefinitions");
        }
        String localVarPath = "/v1/accounts/{accountId}/management/workflow_definitions".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", options.status));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<WorkflowDefinitionList> localVarReturnType = new GenericType<WorkflowDefinitionList>(){};
        WorkflowDefinitionList localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<WorkflowDefinitionList>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public DeployResponse publishOrUnPublishWorkflowDefinition(String accountId, String workflowDefinitionId, DeployRequest body) throws ApiException {
        ApiResponse<DeployResponse> localVarResponse = this.publishOrUnPublishWorkflowDefinitionWithHttpInfo(accountId, workflowDefinitionId, body);
        return localVarResponse.getData();
    }

    public ApiResponse<DeployResponse> publishOrUnPublishWorkflowDefinitionWithHttpInfo(String accountId, String workflowDefinitionId, DeployRequest body) throws ApiException {
        DeployRequest localVarPostBody = body;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling publishOrUnPublishWorkflowDefinition");
        }
        if (workflowDefinitionId == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowDefinitionId' when calling publishOrUnPublishWorkflowDefinition");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling publishOrUnPublishWorkflowDefinition");
        }
        String localVarPath = "/v1/accounts/{accountId}/management/workflow_definitions/{workflowDefinitionId}/publish".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{workflowDefinitionId\\}", this.apiClient.escapeString(workflowDefinitionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DeployResponse> localVarReturnType = new GenericType<DeployResponse>(){};
        DeployResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<DeployResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public NewOrUpdatedWorkflowDefinitionResponse updateWorkflowDefinition(String accountId, String workflowDefinitionId, CreateOrUpdateWorkflowDefinitionRequestBody body) throws ApiException {
        ApiResponse<NewOrUpdatedWorkflowDefinitionResponse> localVarResponse = this.updateWorkflowDefinitionWithHttpInfo(accountId, workflowDefinitionId, body);
        return localVarResponse.getData();
    }

    public ApiResponse<NewOrUpdatedWorkflowDefinitionResponse> updateWorkflowDefinitionWithHttpInfo(String accountId, String workflowDefinitionId, CreateOrUpdateWorkflowDefinitionRequestBody body) throws ApiException {
        CreateOrUpdateWorkflowDefinitionRequestBody localVarPostBody = body;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateWorkflowDefinition");
        }
        if (workflowDefinitionId == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowDefinitionId' when calling updateWorkflowDefinition");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateWorkflowDefinition");
        }
        String localVarPath = "/v1/accounts/{accountId}/management/workflow_definitions/{workflowDefinitionId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{workflowDefinitionId\\}", this.apiClient.escapeString(workflowDefinitionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<NewOrUpdatedWorkflowDefinitionResponse> localVarReturnType = new GenericType<NewOrUpdatedWorkflowDefinitionResponse>(){};
        NewOrUpdatedWorkflowDefinitionResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<NewOrUpdatedWorkflowDefinitionResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public class GetWorkflowDefinitionsOptions {
        private String status = null;

        public void setStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }
    }

    public class GetWorkflowDefinitionOptions {
        private String lastDeployedId = null;

        public void setLastDeployedId(String lastDeployedId) {
            this.lastDeployedId = lastDeployedId;
        }

        public String getLastDeployedId() {
            return this.lastDeployedId;
        }
    }
}

