/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.ErrorDetails;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

@Schema(description="Description of a page of a document.")
public class Page
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="dpi")
    private String dpi = null;
    @JsonProperty(value="errorDetails")
    private ErrorDetails errorDetails = null;
    @JsonProperty(value="height")
    private String height = null;
    @JsonProperty(value="imageBytes")
    private String imageBytes = null;
    @JsonProperty(value="mimeType")
    private String mimeType = null;
    @JsonProperty(value="pageId")
    private String pageId = null;
    @JsonProperty(value="sequence")
    private String sequence = null;
    @JsonProperty(value="width")
    private String width = null;

    public Page dpi(String dpi) {
        this.dpi = dpi;
        return this;
    }

    @Schema(description="The number of dots per inch used for the page image.")
    public String getDpi() {
        return this.dpi;
    }

    public void setDpi(String dpi) {
        this.dpi = dpi;
    }

    public Page errorDetails(ErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
        return this;
    }

    @Schema(description="Array or errors.")
    public ErrorDetails getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(ErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
    }

    public Page height(String height) {
        this.height = height;
        return this;
    }

    @Schema(description="Height of the tab in pixels.")
    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public Page imageBytes(String imageBytes) {
        this.imageBytes = imageBytes;
        return this;
    }

    @Schema(description="")
    public String getImageBytes() {
        return this.imageBytes;
    }

    public void setImageBytes(String imageBytes) {
        this.imageBytes = imageBytes;
    }

    public Page mimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    @Schema(description="")
    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public Page pageId(String pageId) {
        this.pageId = pageId;
        return this;
    }

    @Schema(description="")
    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public Page sequence(String sequence) {
        this.sequence = sequence;
        return this;
    }

    @Schema(description="")
    public String getSequence() {
        return this.sequence;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public Page width(String width) {
        this.width = width;
        return this;
    }

    @Schema(description="Width of the tab in pixels.")
    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Page page = (Page)o;
        return Objects.equals(this.dpi, page.dpi) && Objects.equals(this.errorDetails, page.errorDetails) && Objects.equals(this.height, page.height) && Objects.equals(this.imageBytes, page.imageBytes) && Objects.equals(this.mimeType, page.mimeType) && Objects.equals(this.pageId, page.pageId) && Objects.equals(this.sequence, page.sequence) && Objects.equals(this.width, page.width);
    }

    public int hashCode() {
        return Objects.hash(this.dpi, this.errorDetails, this.height, this.imageBytes, this.mimeType, this.pageId, this.sequence, this.width);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Page {\n");
        sb.append("    dpi: ").append(this.toIndentedString(this.dpi)).append("\n");
        sb.append("    errorDetails: ").append(this.toIndentedString(this.errorDetails)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    imageBytes: ").append(this.toIndentedString(this.imageBytes)).append("\n");
        sb.append("    mimeType: ").append(this.toIndentedString(this.mimeType)).append("\n");
        sb.append("    pageId: ").append(this.toIndentedString(this.pageId)).append("\n");
        sb.append("    sequence: ").append(this.toIndentedString(this.sequence)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

