/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

@Schema(description="A tab associated with the bulk send recipient. In a bulk send request, each recipient tab must match a recipient tab on the envelope or template that you want to send. To match up, the `tabLabel` for this tab and the `tabLabel` for the corresponding tab on the envelope or template must be the same.  For example, if the envelope has a placeholder text tab with the `tabLabel` `childName`, you must assign the same `tabLabel` `childName` to the tab here that you are populating with that information.")
public class BulkSendingCopyTab
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="initialValue")
    private String initialValue = null;
    @JsonProperty(value="tabLabel")
    private String tabLabel = null;

    public BulkSendingCopyTab initialValue(String initialValue) {
        this.initialValue = initialValue;
        return this;
    }

    @Schema(description="The original value of the tab.")
    public String getInitialValue() {
        return this.initialValue;
    }

    public void setInitialValue(String initialValue) {
        this.initialValue = initialValue;
    }

    public BulkSendingCopyTab tabLabel(String tabLabel) {
        this.tabLabel = tabLabel;
        return this;
    }

    @Schema(description="The label string associated with the tab.")
    public String getTabLabel() {
        return this.tabLabel;
    }

    public void setTabLabel(String tabLabel) {
        this.tabLabel = tabLabel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BulkSendingCopyTab bulkSendingCopyTab = (BulkSendingCopyTab)o;
        return Objects.equals(this.initialValue, bulkSendingCopyTab.initialValue) && Objects.equals(this.tabLabel, bulkSendingCopyTab.tabLabel);
    }

    public int hashCode() {
        return Objects.hash(this.initialValue, this.tabLabel);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BulkSendingCopyTab {\n");
        sb.append("    initialValue: ").append(this.toIndentedString(this.initialValue)).append("\n");
        sb.append("    tabLabel: ").append(this.toIndentedString(this.tabLabel)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

