/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

@Schema(description="Describes a recipient who is a member of a conditional group.")
public class RecipientOption
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="email")
    private String email = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="recipientLabel")
    private String recipientLabel = null;
    @JsonProperty(value="roleName")
    private String roleName = null;
    @JsonProperty(value="signingGroupId")
    private String signingGroupId = null;

    public RecipientOption email(String email) {
        this.email = email;
        return this;
    }

    @Schema(description="")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public RecipientOption name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RecipientOption recipientLabel(String recipientLabel) {
        this.recipientLabel = recipientLabel;
        return this;
    }

    @Schema(description="")
    public String getRecipientLabel() {
        return this.recipientLabel;
    }

    public void setRecipientLabel(String recipientLabel) {
        this.recipientLabel = recipientLabel;
    }

    public RecipientOption roleName(String roleName) {
        this.roleName = roleName;
        return this;
    }

    @Schema(description="Optional element. Specifies the role name associated with the recipient.<br/><br/>This is required when working with template recipients.")
    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public RecipientOption signingGroupId(String signingGroupId) {
        this.signingGroupId = signingGroupId;
        return this;
    }

    @Schema(description="When set to **true** and the feature is enabled in the sender's account, the signing recipient is required to draw signatures and initials at each signature/initial tab ( instead of adopting a signature/initial style or only drawing a signature/initial once).")
    public String getSigningGroupId() {
        return this.signingGroupId;
    }

    public void setSigningGroupId(String signingGroupId) {
        this.signingGroupId = signingGroupId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecipientOption recipientOption = (RecipientOption)o;
        return Objects.equals(this.email, recipientOption.email) && Objects.equals(this.name, recipientOption.name) && Objects.equals(this.recipientLabel, recipientOption.recipientLabel) && Objects.equals(this.roleName, recipientOption.roleName) && Objects.equals(this.signingGroupId, recipientOption.signingGroupId);
    }

    public int hashCode() {
        return Objects.hash(this.email, this.name, this.recipientLabel, this.roleName, this.signingGroupId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecipientOption {\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    recipientLabel: ").append(this.toIndentedString(this.recipientLabel)).append("\n");
        sb.append("    roleName: ").append(this.toIndentedString(this.roleName)).append("\n");
        sb.append("    signingGroupId: ").append(this.toIndentedString(this.signingGroupId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

