/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.EventResult;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

@Schema(description="Contains information about the authentication status.")
public class AuthenticationStatus
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="accessCodeResult")
    private EventResult accessCodeResult = null;
    @JsonProperty(value="ageVerifyResult")
    private EventResult ageVerifyResult = null;
    @JsonProperty(value="anySocialIDResult")
    private EventResult anySocialIDResult = null;
    @JsonProperty(value="facebookResult")
    private EventResult facebookResult = null;
    @JsonProperty(value="googleResult")
    private EventResult googleResult = null;
    @JsonProperty(value="identityVerificationResult")
    private EventResult identityVerificationResult = null;
    @JsonProperty(value="idLookupResult")
    private EventResult idLookupResult = null;
    @JsonProperty(value="idQuestionsResult")
    private EventResult idQuestionsResult = null;
    @JsonProperty(value="linkedinResult")
    private EventResult linkedinResult = null;
    @JsonProperty(value="liveIDResult")
    private EventResult liveIDResult = null;
    @JsonProperty(value="ofacResult")
    private EventResult ofacResult = null;
    @JsonProperty(value="openIDResult")
    private EventResult openIDResult = null;
    @JsonProperty(value="phoneAuthResult")
    private EventResult phoneAuthResult = null;
    @JsonProperty(value="salesforceResult")
    private EventResult salesforceResult = null;
    @JsonProperty(value="signatureProviderResult")
    private EventResult signatureProviderResult = null;
    @JsonProperty(value="smsAuthResult")
    private EventResult smsAuthResult = null;
    @JsonProperty(value="sTANPinResult")
    private EventResult sTANPinResult = null;
    @JsonProperty(value="twitterResult")
    private EventResult twitterResult = null;
    @JsonProperty(value="yahooResult")
    private EventResult yahooResult = null;

    public AuthenticationStatus accessCodeResult(EventResult accessCodeResult) {
        this.accessCodeResult = accessCodeResult;
        return this;
    }

    @Schema(description="The result of a user's attempt to authenticate by using an access code. It returns:  - `Status`: `Pass` or `Fail`. - `dateTime`: The date and time that the event occurred. - `FailureDescription`: A string containing the details about a failed authentication. - `VendorFailureStatusCode`: A string containing the vendor's status code for a failed authentication. ")
    public EventResult getAccessCodeResult() {
        return this.accessCodeResult;
    }

    public void setAccessCodeResult(EventResult accessCodeResult) {
        this.accessCodeResult = accessCodeResult;
    }

    public AuthenticationStatus ageVerifyResult(EventResult ageVerifyResult) {
        this.ageVerifyResult = ageVerifyResult;
        return this;
    }

    @Schema(description="The result of an age verification check. It returns:  - `Status`: `Pass` or `Fail`. - `dateTime`: The date and time that the event occurred. - `FailureDescription`: A string containing the details about a failed authentication. - `VendorFailureStatusCode`: A string containing the vendor's status code for a failed authentication. ")
    public EventResult getAgeVerifyResult() {
        return this.ageVerifyResult;
    }

    public void setAgeVerifyResult(EventResult ageVerifyResult) {
        this.ageVerifyResult = ageVerifyResult;
    }

    public AuthenticationStatus anySocialIDResult(EventResult anySocialIDResult) {
        this.anySocialIDResult = anySocialIDResult;
        return this;
    }

    @Schema(description="Deprecated.")
    public EventResult getAnySocialIDResult() {
        return this.anySocialIDResult;
    }

    public void setAnySocialIDResult(EventResult anySocialIDResult) {
        this.anySocialIDResult = anySocialIDResult;
    }

    public AuthenticationStatus facebookResult(EventResult facebookResult) {
        this.facebookResult = facebookResult;
        return this;
    }

    @Schema(description="Deprecated.")
    public EventResult getFacebookResult() {
        return this.facebookResult;
    }

    public void setFacebookResult(EventResult facebookResult) {
        this.facebookResult = facebookResult;
    }

    public AuthenticationStatus googleResult(EventResult googleResult) {
        this.googleResult = googleResult;
        return this;
    }

    @Schema(description="Deprecated.")
    public EventResult getGoogleResult() {
        return this.googleResult;
    }

    public void setGoogleResult(EventResult googleResult) {
        this.googleResult = googleResult;
    }

    public AuthenticationStatus identityVerificationResult(EventResult identityVerificationResult) {
        this.identityVerificationResult = identityVerificationResult;
        return this;
    }

    @Schema(description="The result of an [Identity Verification][IDV] workflow.  [IDV]: /docs/esign-rest-api/reference/accounts/identityverifications/")
    public EventResult getIdentityVerificationResult() {
        return this.identityVerificationResult;
    }

    public void setIdentityVerificationResult(EventResult identityVerificationResult) {
        this.identityVerificationResult = identityVerificationResult;
    }

    public AuthenticationStatus idLookupResult(EventResult idLookupResult) {
        this.idLookupResult = idLookupResult;
        return this;
    }

    @Schema(description="The result of an ID lookup authentication check. It returns:  - `Status`: `Pass` or `Fail`. - `dateTime`: The date and time that the event occurred. - `FailureDescription`: A string containing the details about a failed authentication. - `VendorFailureStatusCode`: A string containing the vendor's status code for a failed authentication. ")
    public EventResult getIdLookupResult() {
        return this.idLookupResult;
    }

    public void setIdLookupResult(EventResult idLookupResult) {
        this.idLookupResult = idLookupResult;
    }

    public AuthenticationStatus idQuestionsResult(EventResult idQuestionsResult) {
        this.idQuestionsResult = idQuestionsResult;
        return this;
    }

    @Schema(description="The result of the user's answers to ID challenge questions. It returns:  - `Status`: `Pass` or `Fail`. - `dateTime`: The date and time that the event occurred. - `FailureDescription`: A string containing the details about a failed authentication. - `VendorFailureStatusCode`: A string containing the vendor's status code for a failed authentication. ")
    public EventResult getIdQuestionsResult() {
        return this.idQuestionsResult;
    }

    public void setIdQuestionsResult(EventResult idQuestionsResult) {
        this.idQuestionsResult = idQuestionsResult;
    }

    public AuthenticationStatus linkedinResult(EventResult linkedinResult) {
        this.linkedinResult = linkedinResult;
        return this;
    }

    @Schema(description="Deprecated.")
    public EventResult getLinkedinResult() {
        return this.linkedinResult;
    }

    public void setLinkedinResult(EventResult linkedinResult) {
        this.linkedinResult = linkedinResult;
    }

    public AuthenticationStatus liveIDResult(EventResult liveIDResult) {
        this.liveIDResult = liveIDResult;
        return this;
    }

    @Schema(description="Deprecated.")
    public EventResult getLiveIDResult() {
        return this.liveIDResult;
    }

    public void setLiveIDResult(EventResult liveIDResult) {
        this.liveIDResult = liveIDResult;
    }

    public AuthenticationStatus ofacResult(EventResult ofacResult) {
        this.ofacResult = ofacResult;
        return this;
    }

    @Schema(description="The result of an Office of Foreign Asset Control (OFAC) check. It returns:  - `Status`: `Pass` or `Fail`. - `dateTime`: The date and time that the event occurred. - `FailureDescription`: A string containing the details about a failed authentication. - `VendorFailureStatusCode`: A string containing the vendor's status code for a failed authentication. ")
    public EventResult getOfacResult() {
        return this.ofacResult;
    }

    public void setOfacResult(EventResult ofacResult) {
        this.ofacResult = ofacResult;
    }

    public AuthenticationStatus openIDResult(EventResult openIDResult) {
        this.openIDResult = openIDResult;
        return this;
    }

    @Schema(description="Deprecated.")
    public EventResult getOpenIDResult() {
        return this.openIDResult;
    }

    public void setOpenIDResult(EventResult openIDResult) {
        this.openIDResult = openIDResult;
    }

    public AuthenticationStatus phoneAuthResult(EventResult phoneAuthResult) {
        this.phoneAuthResult = phoneAuthResult;
        return this;
    }

    @Schema(description="The result of the user's attempt to authenticate by using two-factor authentication (2FA) through phone messaging. It returns:  - `Status`: `Pass` or `Fail`. - `dateTime`: The date and time that the event occurred. - `FailureDescription`: A string containing the details about a failed authentication. - `VendorFailureStatusCode`: A string containing the vendor's status code for a failed authentication. ")
    public EventResult getPhoneAuthResult() {
        return this.phoneAuthResult;
    }

    public void setPhoneAuthResult(EventResult phoneAuthResult) {
        this.phoneAuthResult = phoneAuthResult;
    }

    public AuthenticationStatus salesforceResult(EventResult salesforceResult) {
        this.salesforceResult = salesforceResult;
        return this;
    }

    @Schema(description="Success/failure result of authentication using sign-in with a Salesforce account. It returns:  - `Status`: `Pass` or `Fail`. - `dateTime`: The date and time that the event occurred. - `FailureDescription`: A string containing the details about a failed authentication. - `VendorFailureStatusCode`: A string containing the vendor's status code for a failed authentication. ")
    public EventResult getSalesforceResult() {
        return this.salesforceResult;
    }

    public void setSalesforceResult(EventResult salesforceResult) {
        this.salesforceResult = salesforceResult;
    }

    public AuthenticationStatus signatureProviderResult(EventResult signatureProviderResult) {
        this.signatureProviderResult = signatureProviderResult;
        return this;
    }

    @Schema(description="The result of the user's attempt to authenticate by using a signature provider.")
    public EventResult getSignatureProviderResult() {
        return this.signatureProviderResult;
    }

    public void setSignatureProviderResult(EventResult signatureProviderResult) {
        this.signatureProviderResult = signatureProviderResult;
    }

    public AuthenticationStatus smsAuthResult(EventResult smsAuthResult) {
        this.smsAuthResult = smsAuthResult;
        return this;
    }

    @Schema(description="The result of the user's attempt to authenticate by using two-factor authentication (2FA) through SMS messaging on a mobile phone.")
    public EventResult getSmsAuthResult() {
        return this.smsAuthResult;
    }

    public void setSmsAuthResult(EventResult smsAuthResult) {
        this.smsAuthResult = smsAuthResult;
    }

    public AuthenticationStatus sTANPinResult(EventResult sTANPinResult) {
        this.sTANPinResult = sTANPinResult;
        return this;
    }

    @Schema(description="The result of a Student Authentication Network (STAN) authentication check. It returns:  - `Status`: `Pass` or `Fail`. - `dateTime`: The date and time that the event occurred. - `FailureDescription`: A string containing the details about a failed authentication. - `VendorFailureStatusCode`: A string containing the vendor's status code for a failed authentication. ")
    public EventResult getSTANPinResult() {
        return this.sTANPinResult;
    }

    public void setSTANPinResult(EventResult sTANPinResult) {
        this.sTANPinResult = sTANPinResult;
    }

    public AuthenticationStatus twitterResult(EventResult twitterResult) {
        this.twitterResult = twitterResult;
        return this;
    }

    @Schema(description="Deprecated.")
    public EventResult getTwitterResult() {
        return this.twitterResult;
    }

    public void setTwitterResult(EventResult twitterResult) {
        this.twitterResult = twitterResult;
    }

    public AuthenticationStatus yahooResult(EventResult yahooResult) {
        this.yahooResult = yahooResult;
        return this;
    }

    @Schema(description="Deprecated.")
    public EventResult getYahooResult() {
        return this.yahooResult;
    }

    public void setYahooResult(EventResult yahooResult) {
        this.yahooResult = yahooResult;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationStatus authenticationStatus = (AuthenticationStatus)o;
        return Objects.equals(this.accessCodeResult, authenticationStatus.accessCodeResult) && Objects.equals(this.ageVerifyResult, authenticationStatus.ageVerifyResult) && Objects.equals(this.anySocialIDResult, authenticationStatus.anySocialIDResult) && Objects.equals(this.facebookResult, authenticationStatus.facebookResult) && Objects.equals(this.googleResult, authenticationStatus.googleResult) && Objects.equals(this.identityVerificationResult, authenticationStatus.identityVerificationResult) && Objects.equals(this.idLookupResult, authenticationStatus.idLookupResult) && Objects.equals(this.idQuestionsResult, authenticationStatus.idQuestionsResult) && Objects.equals(this.linkedinResult, authenticationStatus.linkedinResult) && Objects.equals(this.liveIDResult, authenticationStatus.liveIDResult) && Objects.equals(this.ofacResult, authenticationStatus.ofacResult) && Objects.equals(this.openIDResult, authenticationStatus.openIDResult) && Objects.equals(this.phoneAuthResult, authenticationStatus.phoneAuthResult) && Objects.equals(this.salesforceResult, authenticationStatus.salesforceResult) && Objects.equals(this.signatureProviderResult, authenticationStatus.signatureProviderResult) && Objects.equals(this.smsAuthResult, authenticationStatus.smsAuthResult) && Objects.equals(this.sTANPinResult, authenticationStatus.sTANPinResult) && Objects.equals(this.twitterResult, authenticationStatus.twitterResult) && Objects.equals(this.yahooResult, authenticationStatus.yahooResult);
    }

    public int hashCode() {
        return Objects.hash(this.accessCodeResult, this.ageVerifyResult, this.anySocialIDResult, this.facebookResult, this.googleResult, this.identityVerificationResult, this.idLookupResult, this.idQuestionsResult, this.linkedinResult, this.liveIDResult, this.ofacResult, this.openIDResult, this.phoneAuthResult, this.salesforceResult, this.signatureProviderResult, this.smsAuthResult, this.sTANPinResult, this.twitterResult, this.yahooResult);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticationStatus {\n");
        sb.append("    accessCodeResult: ").append(this.toIndentedString(this.accessCodeResult)).append("\n");
        sb.append("    ageVerifyResult: ").append(this.toIndentedString(this.ageVerifyResult)).append("\n");
        sb.append("    anySocialIDResult: ").append(this.toIndentedString(this.anySocialIDResult)).append("\n");
        sb.append("    facebookResult: ").append(this.toIndentedString(this.facebookResult)).append("\n");
        sb.append("    googleResult: ").append(this.toIndentedString(this.googleResult)).append("\n");
        sb.append("    identityVerificationResult: ").append(this.toIndentedString(this.identityVerificationResult)).append("\n");
        sb.append("    idLookupResult: ").append(this.toIndentedString(this.idLookupResult)).append("\n");
        sb.append("    idQuestionsResult: ").append(this.toIndentedString(this.idQuestionsResult)).append("\n");
        sb.append("    linkedinResult: ").append(this.toIndentedString(this.linkedinResult)).append("\n");
        sb.append("    liveIDResult: ").append(this.toIndentedString(this.liveIDResult)).append("\n");
        sb.append("    ofacResult: ").append(this.toIndentedString(this.ofacResult)).append("\n");
        sb.append("    openIDResult: ").append(this.toIndentedString(this.openIDResult)).append("\n");
        sb.append("    phoneAuthResult: ").append(this.toIndentedString(this.phoneAuthResult)).append("\n");
        sb.append("    salesforceResult: ").append(this.toIndentedString(this.salesforceResult)).append("\n");
        sb.append("    signatureProviderResult: ").append(this.toIndentedString(this.signatureProviderResult)).append("\n");
        sb.append("    smsAuthResult: ").append(this.toIndentedString(this.smsAuthResult)).append("\n");
        sb.append("    sTANPinResult: ").append(this.toIndentedString(this.sTANPinResult)).append("\n");
        sb.append("    twitterResult: ").append(this.toIndentedString(this.twitterResult)).append("\n");
        sb.append("    yahooResult: ").append(this.toIndentedString(this.yahooResult)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

