/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.reconcile;

import com.dangdang.ddframe.job.lite.config.LiteJobConfiguration;
import com.dangdang.ddframe.job.lite.internal.config.ConfigurationService;
import com.dangdang.ddframe.job.lite.internal.election.LeaderService;
import com.dangdang.ddframe.job.lite.internal.sharding.ShardingService;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import com.google.common.util.concurrent.AbstractScheduledService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReconcileService
extends AbstractScheduledService {
    private static final Logger log = LoggerFactory.getLogger(ReconcileService.class);
    private long lastReconcileTime = System.currentTimeMillis();
    private final ConfigurationService configService;
    private final ShardingService shardingService;
    private final LeaderService leaderService;

    public ReconcileService(CoordinatorRegistryCenter regCenter, String jobName) {
        this.configService = new ConfigurationService(regCenter, jobName);
        this.shardingService = new ShardingService(regCenter, jobName);
        this.leaderService = new LeaderService(regCenter, jobName);
    }

    protected void runOneIteration() throws Exception {
        int reconcileIntervalMinutes;
        LiteJobConfiguration config = this.configService.load(true);
        int n = reconcileIntervalMinutes = null == config ? -1 : config.getReconcileIntervalMinutes();
        if (reconcileIntervalMinutes > 0 && System.currentTimeMillis() - this.lastReconcileTime >= (long)(reconcileIntervalMinutes * 60 * 1000)) {
            this.lastReconcileTime = System.currentTimeMillis();
            if (this.leaderService.isLeaderUntilBlock() && !this.shardingService.isNeedSharding() && this.shardingService.hasShardingInfoInOfflineServers()) {
                log.warn("Elastic Job: job status node has inconsistent value,start reconciling...");
                this.shardingService.setReshardingFlag();
            }
        }
    }

    protected AbstractScheduledService.Scheduler scheduler() {
        return AbstractScheduledService.Scheduler.newFixedDelaySchedule((long)0L, (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }
}

