/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.instance;

import com.dangdang.ddframe.job.lite.internal.instance.InstanceNode;
import com.dangdang.ddframe.job.lite.internal.instance.InstanceOperation;
import com.dangdang.ddframe.job.lite.internal.instance.InstanceService;
import com.dangdang.ddframe.job.lite.internal.listener.AbstractJobListener;
import com.dangdang.ddframe.job.lite.internal.listener.AbstractListenerManager;
import com.dangdang.ddframe.job.lite.internal.schedule.JobRegistry;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;

public final class TriggerListenerManager
extends AbstractListenerManager {
    private final String jobName;
    private final InstanceNode instanceNode;
    private final InstanceService instanceService;

    public TriggerListenerManager(CoordinatorRegistryCenter regCenter, String jobName) {
        super(regCenter, jobName);
        this.jobName = jobName;
        this.instanceNode = new InstanceNode(jobName);
        this.instanceService = new InstanceService(regCenter, jobName);
    }

    @Override
    public void start() {
        this.addDataListener(new JobTriggerStatusJobListener());
    }

    class JobTriggerStatusJobListener
    extends AbstractJobListener {
        JobTriggerStatusJobListener() {
        }

        @Override
        protected void dataChanged(String path, TreeCacheEvent.Type eventType, String data) {
            if (!InstanceOperation.TRIGGER.name().equals(data) || !TriggerListenerManager.this.instanceNode.isLocalInstancePath(path) || TreeCacheEvent.Type.NODE_UPDATED != eventType) {
                return;
            }
            TriggerListenerManager.this.instanceService.clearTriggerFlag();
            if (!JobRegistry.getInstance().isShutdown(TriggerListenerManager.this.jobName) && !JobRegistry.getInstance().isJobRunning(TriggerListenerManager.this.jobName)) {
                JobRegistry.getInstance().getJobScheduleController(TriggerListenerManager.this.jobName).triggerJob();
            }
        }
    }
}

