/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.instance;

import com.dangdang.ddframe.job.lite.internal.instance.InstanceNode;
import com.dangdang.ddframe.job.lite.internal.instance.InstanceService;
import com.dangdang.ddframe.job.lite.internal.listener.AbstractJobListener;
import com.dangdang.ddframe.job.lite.internal.listener.AbstractListenerManager;
import com.dangdang.ddframe.job.lite.internal.schedule.JobRegistry;
import com.dangdang.ddframe.job.lite.internal.schedule.SchedulerFacade;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;

public final class ShutdownListenerManager
extends AbstractListenerManager {
    private final String jobName;
    private final InstanceNode instanceNode;
    private final InstanceService instanceService;
    private final SchedulerFacade schedulerFacade;

    public ShutdownListenerManager(CoordinatorRegistryCenter regCenter, String jobName) {
        super(regCenter, jobName);
        this.jobName = jobName;
        this.instanceNode = new InstanceNode(jobName);
        this.instanceService = new InstanceService(regCenter, jobName);
        this.schedulerFacade = new SchedulerFacade(regCenter, jobName);
    }

    @Override
    public void start() {
        this.addDataListener(new InstanceShutdownStatusJobListener());
    }

    class InstanceShutdownStatusJobListener
    extends AbstractJobListener {
        InstanceShutdownStatusJobListener() {
        }

        @Override
        protected void dataChanged(String path, TreeCacheEvent.Type eventType, String data) {
            if (!JobRegistry.getInstance().isShutdown(ShutdownListenerManager.this.jobName) && !JobRegistry.getInstance().getJobScheduleController(ShutdownListenerManager.this.jobName).isPaused() && this.isRemoveInstance(path, eventType) && !this.isReconnectedRegistryCenter()) {
                ShutdownListenerManager.this.schedulerFacade.shutdownInstance();
            }
        }

        private boolean isRemoveInstance(String path, TreeCacheEvent.Type eventType) {
            return ShutdownListenerManager.this.instanceNode.isLocalInstancePath(path) && TreeCacheEvent.Type.NODE_REMOVED == eventType;
        }

        private boolean isReconnectedRegistryCenter() {
            return ShutdownListenerManager.this.instanceService.isLocalJobInstanceExisted();
        }
    }
}

