/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.proxy.optimization.predictive;

import io.github.bucket4j.distributed.proxy.optimization.PredictionParameters;
import java.util.Iterator;
import java.util.LinkedList;

public class Sampling {
    private final PredictionParameters predictionParameters;
    private LinkedList<Sample> samples = new LinkedList();
    private double othersRate;

    public Sampling(PredictionParameters predictionParameters) {
        this.predictionParameters = predictionParameters;
    }

    public boolean isNeedToExecuteRemoteImmediately(long currentTimeNanos) {
        while (!this.samples.isEmpty()) {
            Sample sample = this.samples.getFirst();
            long sampleAge = currentTimeNanos - sample.syncTimeNanos;
            if (sampleAge <= this.predictionParameters.sampleMaxAgeNanos) break;
            this.samples.removeFirst();
        }
        return this.othersRate == Double.POSITIVE_INFINITY || this.samples.size() < this.predictionParameters.minSamples;
    }

    public long predictedConsumptionByOthersSinceLastSync(long currentTimeNanos) {
        Sample freshSample = this.samples.getLast();
        long timeSinceLastSync = currentTimeNanos - freshSample.syncTimeNanos;
        if (timeSinceLastSync <= 0L || this.othersRate == 0.0) {
            return 0L;
        }
        double predictedConsumptionSinceLastSync = this.othersRate * (double)timeSinceLastSync;
        if (predictedConsumptionSinceLastSync >= 9.223372036854776E18) {
            return Long.MAX_VALUE;
        }
        return (long)predictedConsumptionSinceLastSync;
    }

    public void rememberRemoteCommandResult(long selfConsumedTokens, long consumedTokensCounter, long now) {
        this.othersRate = 0.0;
        Sample freshSample = new Sample(now, consumedTokensCounter, selfConsumedTokens);
        Iterator samplesIterator = this.samples.iterator();
        while (samplesIterator.hasNext()) {
            Sample sample = (Sample)samplesIterator.next();
            if (freshSample.observedConsumptionCounter < sample.observedConsumptionCounter) {
                samplesIterator.remove();
                continue;
            }
            if (now - sample.syncTimeNanos > this.predictionParameters.sampleMaxAgeNanos) {
                samplesIterator.remove();
                continue;
            }
            if (freshSample.syncTimeNanos < sample.syncTimeNanos) {
                samplesIterator.remove();
                continue;
            }
            if (freshSample.syncTimeNanos != sample.syncTimeNanos || sample == this.samples.getFirst()) continue;
            freshSample.selfConsumedTokens += sample.selfConsumedTokens;
            samplesIterator.remove();
        }
        this.samples.addLast(freshSample);
        if (this.samples.size() > this.predictionParameters.maxSamples) {
            this.samples.removeFirst();
        } else if (this.samples.size() < this.predictionParameters.minSamples) {
            return;
        }
        Sample oldestSample = this.samples.getFirst();
        long tokensSelfConsumedDuringSamplePeriod = 0L;
        for (Sample sample : this.samples) {
            if (sample == oldestSample) continue;
            tokensSelfConsumedDuringSamplePeriod += sample.selfConsumedTokens;
        }
        long tokensConsumedByOthersDuringSamplingPeriod = freshSample.observedConsumptionCounter - oldestSample.observedConsumptionCounter - tokensSelfConsumedDuringSamplePeriod;
        if (tokensConsumedByOthersDuringSamplingPeriod <= 0L) {
            return;
        }
        long timeBetweenSynchronizations = freshSample.syncTimeNanos - oldestSample.syncTimeNanos;
        if (timeBetweenSynchronizations == 0L) {
            this.othersRate = Double.POSITIVE_INFINITY;
            return;
        }
        this.othersRate = (double)tokensConsumedByOthersDuringSamplingPeriod / (double)timeBetweenSynchronizations;
    }

    public long getLastSyncTimeNanos() {
        return this.samples.getLast().syncTimeNanos;
    }

    public void clear() {
        this.samples.clear();
    }

    private static class Sample {
        private long syncTimeNanos;
        private long observedConsumptionCounter;
        private long selfConsumedTokens;

        public Sample(long syncTimeNanos, long observedConsumptionCounter, long selfConsumedTokens) {
            this.syncTimeNanos = syncTimeNanos;
            this.observedConsumptionCounter = observedConsumptionCounter;
            this.selfConsumedTokens = selfConsumedTokens;
        }
    }
}

