/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.ProgressListener;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

final class RequestBodyFromStream
extends RequestBody {
    private final InputStream inputStream;
    private final ProgressListener progressListener;
    private final MediaType mediaType;
    private final long fileSize;

    RequestBodyFromStream(InputStream inputStream, MediaType mediaType, ProgressListener progressListener, long fileSize) {
        this.inputStream = inputStream;
        this.progressListener = progressListener;
        this.mediaType = mediaType;
        this.fileSize = fileSize;
    }

    public MediaType contentType() {
        return this.mediaType;
    }

    public void writeTo(BufferedSink bufferedSink) {
        if (this.progressListener == null) {
            this.writeWithoutProgressListener(bufferedSink);
        } else {
            this.writeWithProgressListener(bufferedSink);
        }
    }

    public long contentLength() {
        return this.fileSize;
    }

    private void writeWithoutProgressListener(BufferedSink bufferedSink) {
        try (Source source = Okio.source((InputStream)this.inputStream);){
            bufferedSink.writeAll(source);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeWithProgressListener(BufferedSink bufferedSink) {
        try {
            byte[] buffer = new byte[8192];
            int n = this.inputStream.read(buffer);
            int totalWritten = 0;
            while (n != -1) {
                bufferedSink.write(buffer, 0, n);
                totalWritten += n;
                if (this.progressListener != null) {
                    this.progressListener.onProgressChanged(totalWritten, this.contentLength());
                }
                n = this.inputStream.read(buffer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

