/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.ai;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.ai.CreateAiAskHeaders;
import com.box.sdkgen.managers.ai.CreateAiExtractHeaders;
import com.box.sdkgen.managers.ai.CreateAiExtractStructuredHeaders;
import com.box.sdkgen.managers.ai.CreateAiTextGenHeaders;
import com.box.sdkgen.managers.ai.GetAiAgentDefaultConfigHeaders;
import com.box.sdkgen.managers.ai.GetAiAgentDefaultConfigQueryParams;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.aiagent.AiAgent;
import com.box.sdkgen.schemas.aiask.AiAsk;
import com.box.sdkgen.schemas.aiextract.AiExtract;
import com.box.sdkgen.schemas.aiextractstructured.AiExtractStructured;
import com.box.sdkgen.schemas.aiextractstructuredresponse.AiExtractStructuredResponse;
import com.box.sdkgen.schemas.airesponse.AiResponse;
import com.box.sdkgen.schemas.airesponsefull.AiResponseFull;
import com.box.sdkgen.schemas.aitextgen.AiTextGen;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class AiManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public AiManager() {
        this.networkSession = new NetworkSession();
    }

    protected AiManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public AiResponseFull createAiAsk(AiAsk requestBody) {
        return this.createAiAsk(requestBody, new CreateAiAskHeaders());
    }

    public AiResponseFull createAiAsk(AiAsk requestBody, CreateAiAskHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/ai/ask"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        if (UtilsManager.convertToString(response.getStatus()).equals("204")) {
            return null;
        }
        return JsonManager.deserialize(response.getData(), AiResponseFull.class);
    }

    public AiResponse createAiTextGen(AiTextGen requestBody) {
        return this.createAiTextGen(requestBody, new CreateAiTextGenHeaders());
    }

    public AiResponse createAiTextGen(AiTextGen requestBody, CreateAiTextGenHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/ai/text_gen"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), AiResponse.class);
    }

    public AiAgent getAiAgentDefaultConfig(GetAiAgentDefaultConfigQueryParams queryParams) {
        return this.getAiAgentDefaultConfig(queryParams, new GetAiAgentDefaultConfigHeaders());
    }

    public AiAgent getAiAgentDefaultConfig(GetAiAgentDefaultConfigQueryParams queryParams, GetAiAgentDefaultConfigHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("mode", UtilsManager.convertToString(queryParams.getMode())), UtilsManager.entryOf("language", UtilsManager.convertToString(queryParams.getLanguage())), UtilsManager.entryOf("model", UtilsManager.convertToString(queryParams.getModel()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/ai_agent_default"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), AiAgent.class);
    }

    public AiResponse createAiExtract(AiExtract requestBody) {
        return this.createAiExtract(requestBody, new CreateAiExtractHeaders());
    }

    public AiResponse createAiExtract(AiExtract requestBody, CreateAiExtractHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/ai/extract"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), AiResponse.class);
    }

    public AiExtractStructuredResponse createAiExtractStructured(AiExtractStructured requestBody) {
        return this.createAiExtractStructured(requestBody, new CreateAiExtractStructuredHeaders());
    }

    public AiExtractStructuredResponse createAiExtractStructured(AiExtractStructured requestBody, CreateAiExtractStructuredHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/ai/extract_structured"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), AiExtractStructuredResponse.class);
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public AiManager build() {
            return new AiManager(this);
        }
    }
}

