/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.schemas.searchresults;

import com.box.sdkgen.internal.NullableFieldTracker;
import com.box.sdkgen.internal.SerializableObject;
import com.box.sdkgen.schemas.searchresultitem.SearchResultItem;
import com.box.sdkgen.schemas.searchresults.SearchResultsTypeField;
import com.box.sdkgen.serialization.json.EnumWrapper;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import java.util.Objects;

@JsonFilter(value="nullablePropertyFilter")
public class SearchResults
extends SerializableObject {
    @JsonProperty(value="total_count")
    protected Long totalCount;
    protected Long limit;
    protected Long offset;
    @JsonDeserialize(using=SearchResultsTypeField.SearchResultsTypeFieldDeserializer.class)
    @JsonSerialize(using=SearchResultsTypeField.SearchResultsTypeFieldSerializer.class)
    protected EnumWrapper<SearchResultsTypeField> type;
    protected List<SearchResultItem> entries;

    public SearchResults() {
        this.type = new EnumWrapper<SearchResultsTypeField>(SearchResultsTypeField.SEARCH_RESULTS_ITEMS);
    }

    protected SearchResults(Builder builder) {
        this.totalCount = builder.totalCount;
        this.limit = builder.limit;
        this.offset = builder.offset;
        this.type = builder.type;
        this.entries = builder.entries;
        this.markNullableFieldsAsSet(builder.getExplicitlySetNullableFields());
    }

    public Long getTotalCount() {
        return this.totalCount;
    }

    public Long getLimit() {
        return this.limit;
    }

    public Long getOffset() {
        return this.offset;
    }

    public EnumWrapper<SearchResultsTypeField> getType() {
        return this.type;
    }

    public List<SearchResultItem> getEntries() {
        return this.entries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchResults casted = (SearchResults)o;
        return Objects.equals(this.totalCount, casted.totalCount) && Objects.equals(this.limit, casted.limit) && Objects.equals(this.offset, casted.offset) && Objects.equals(this.type, casted.type) && Objects.equals(this.entries, casted.entries);
    }

    public int hashCode() {
        return Objects.hash(this.totalCount, this.limit, this.offset, this.type, this.entries);
    }

    public String toString() {
        return "SearchResults{totalCount='" + this.totalCount + '\'' + ", limit='" + this.limit + '\'' + ", offset='" + this.offset + '\'' + ", type='" + this.type + '\'' + ", entries='" + this.entries + '\'' + "}";
    }

    public static class Builder
    extends NullableFieldTracker {
        protected Long totalCount;
        protected Long limit;
        protected Long offset;
        protected EnumWrapper<SearchResultsTypeField> type = new EnumWrapper<SearchResultsTypeField>(SearchResultsTypeField.SEARCH_RESULTS_ITEMS);
        protected List<SearchResultItem> entries;

        public Builder totalCount(Long totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public Builder limit(Long limit) {
            this.limit = limit;
            return this;
        }

        public Builder offset(Long offset) {
            this.offset = offset;
            return this;
        }

        public Builder type(SearchResultsTypeField type) {
            this.type = new EnumWrapper<SearchResultsTypeField>(type);
            return this;
        }

        public Builder type(EnumWrapper<SearchResultsTypeField> type) {
            this.type = type;
            return this;
        }

        public Builder entries(List<SearchResultItem> entries) {
            this.entries = entries;
            return this;
        }

        public SearchResults build() {
            return new SearchResults(this);
        }
    }
}

