/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.schemas.fileversion;

import com.box.sdkgen.internal.Nullable;
import com.box.sdkgen.internal.utils.DateTimeUtils;
import com.box.sdkgen.schemas.fileversionbase.FileVersionBaseTypeField;
import com.box.sdkgen.schemas.fileversionmini.FileVersionMini;
import com.box.sdkgen.schemas.usermini.UserMini;
import com.box.sdkgen.serialization.json.EnumWrapper;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonFilter(value="nullablePropertyFilter")
public class FileVersion
extends FileVersionMini {
    protected String name;
    protected Long size;
    @JsonProperty(value="created_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    protected OffsetDateTime createdAt;
    @JsonProperty(value="modified_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    protected OffsetDateTime modifiedAt;
    @JsonProperty(value="modified_by")
    protected UserMini modifiedBy;
    @JsonProperty(value="trashed_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    @Nullable
    protected OffsetDateTime trashedAt;
    @JsonProperty(value="trashed_by")
    protected UserMini trashedBy;
    @JsonProperty(value="restored_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    @Nullable
    protected OffsetDateTime restoredAt;
    @JsonProperty(value="restored_by")
    protected UserMini restoredBy;
    @JsonProperty(value="purged_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    @Nullable
    protected OffsetDateTime purgedAt;
    @JsonProperty(value="uploader_display_name")
    protected String uploaderDisplayName;

    public FileVersion(@JsonProperty(value="id") String id) {
        super(id);
    }

    protected FileVersion(Builder builder) {
        super(builder);
        this.name = builder.name;
        this.size = builder.size;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.modifiedBy = builder.modifiedBy;
        this.trashedAt = builder.trashedAt;
        this.trashedBy = builder.trashedBy;
        this.restoredAt = builder.restoredAt;
        this.restoredBy = builder.restoredBy;
        this.purgedAt = builder.purgedAt;
        this.uploaderDisplayName = builder.uploaderDisplayName;
        this.markNullableFieldsAsSet(builder.getExplicitlySetNullableFields());
    }

    public String getName() {
        return this.name;
    }

    public Long getSize() {
        return this.size;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public OffsetDateTime getModifiedAt() {
        return this.modifiedAt;
    }

    public UserMini getModifiedBy() {
        return this.modifiedBy;
    }

    public OffsetDateTime getTrashedAt() {
        return this.trashedAt;
    }

    public UserMini getTrashedBy() {
        return this.trashedBy;
    }

    public OffsetDateTime getRestoredAt() {
        return this.restoredAt;
    }

    public UserMini getRestoredBy() {
        return this.restoredBy;
    }

    public OffsetDateTime getPurgedAt() {
        return this.purgedAt;
    }

    public String getUploaderDisplayName() {
        return this.uploaderDisplayName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileVersion casted = (FileVersion)o;
        return Objects.equals(this.id, casted.id) && Objects.equals(this.type, casted.type) && Objects.equals(this.sha1, casted.sha1) && Objects.equals(this.name, casted.name) && Objects.equals(this.size, casted.size) && Objects.equals(this.createdAt, casted.createdAt) && Objects.equals(this.modifiedAt, casted.modifiedAt) && Objects.equals(this.modifiedBy, casted.modifiedBy) && Objects.equals(this.trashedAt, casted.trashedAt) && Objects.equals(this.trashedBy, casted.trashedBy) && Objects.equals(this.restoredAt, casted.restoredAt) && Objects.equals(this.restoredBy, casted.restoredBy) && Objects.equals(this.purgedAt, casted.purgedAt) && Objects.equals(this.uploaderDisplayName, casted.uploaderDisplayName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.type, this.sha1, this.name, this.size, this.createdAt, this.modifiedAt, this.modifiedBy, this.trashedAt, this.trashedBy, this.restoredAt, this.restoredBy, this.purgedAt, this.uploaderDisplayName);
    }

    @Override
    public String toString() {
        return "FileVersion{id='" + this.id + '\'' + ", type='" + this.type + '\'' + ", sha1='" + this.sha1 + '\'' + ", name='" + this.name + '\'' + ", size='" + this.size + '\'' + ", createdAt='" + this.createdAt + '\'' + ", modifiedAt='" + this.modifiedAt + '\'' + ", modifiedBy='" + this.modifiedBy + '\'' + ", trashedAt='" + this.trashedAt + '\'' + ", trashedBy='" + this.trashedBy + '\'' + ", restoredAt='" + this.restoredAt + '\'' + ", restoredBy='" + this.restoredBy + '\'' + ", purgedAt='" + this.purgedAt + '\'' + ", uploaderDisplayName='" + this.uploaderDisplayName + '\'' + "}";
    }

    public static class Builder
    extends FileVersionMini.Builder {
        protected String name;
        protected Long size;
        protected OffsetDateTime createdAt;
        protected OffsetDateTime modifiedAt;
        protected UserMini modifiedBy;
        protected OffsetDateTime trashedAt;
        protected UserMini trashedBy;
        protected OffsetDateTime restoredAt;
        protected UserMini restoredBy;
        protected OffsetDateTime purgedAt;
        protected String uploaderDisplayName;

        public Builder(String id) {
            super(id);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder size(Long size) {
            this.size = size;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedBy(UserMini modifiedBy) {
            this.modifiedBy = modifiedBy;
            return this;
        }

        public Builder trashedAt(OffsetDateTime trashedAt) {
            this.trashedAt = trashedAt;
            this.markNullableFieldAsSet("trashed_at");
            return this;
        }

        public Builder trashedBy(UserMini trashedBy) {
            this.trashedBy = trashedBy;
            return this;
        }

        public Builder restoredAt(OffsetDateTime restoredAt) {
            this.restoredAt = restoredAt;
            this.markNullableFieldAsSet("restored_at");
            return this;
        }

        public Builder restoredBy(UserMini restoredBy) {
            this.restoredBy = restoredBy;
            return this;
        }

        public Builder purgedAt(OffsetDateTime purgedAt) {
            this.purgedAt = purgedAt;
            this.markNullableFieldAsSet("purged_at");
            return this;
        }

        public Builder uploaderDisplayName(String uploaderDisplayName) {
            this.uploaderDisplayName = uploaderDisplayName;
            return this;
        }

        @Override
        public Builder type(FileVersionBaseTypeField type) {
            this.type = new EnumWrapper<FileVersionBaseTypeField>(type);
            return this;
        }

        @Override
        public Builder type(EnumWrapper<FileVersionBaseTypeField> type) {
            this.type = type;
            return this;
        }

        @Override
        public Builder sha1(String sha1) {
            this.sha1 = sha1;
            return this;
        }

        @Override
        public FileVersion build() {
            return new FileVersion(this);
        }
    }
}

