/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.schemas.comment;

import com.box.sdkgen.internal.utils.DateTimeUtils;
import com.box.sdkgen.schemas.comment.CommentItemField;
import com.box.sdkgen.schemas.commentbase.CommentBase;
import com.box.sdkgen.schemas.commentbase.CommentBaseTypeField;
import com.box.sdkgen.schemas.usermini.UserMini;
import com.box.sdkgen.serialization.json.EnumWrapper;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonFilter(value="nullablePropertyFilter")
public class Comment
extends CommentBase {
    @JsonProperty(value="is_reply_comment")
    protected Boolean isReplyComment;
    protected String message;
    @JsonProperty(value="created_by")
    protected UserMini createdBy;
    @JsonProperty(value="created_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    protected OffsetDateTime createdAt;
    @JsonProperty(value="modified_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    protected OffsetDateTime modifiedAt;
    protected CommentItemField item;

    public Comment() {
    }

    protected Comment(Builder builder) {
        super(builder);
        this.isReplyComment = builder.isReplyComment;
        this.message = builder.message;
        this.createdBy = builder.createdBy;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.item = builder.item;
        this.markNullableFieldsAsSet(builder.getExplicitlySetNullableFields());
    }

    public Boolean getIsReplyComment() {
        return this.isReplyComment;
    }

    public String getMessage() {
        return this.message;
    }

    public UserMini getCreatedBy() {
        return this.createdBy;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public OffsetDateTime getModifiedAt() {
        return this.modifiedAt;
    }

    public CommentItemField getItem() {
        return this.item;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Comment casted = (Comment)o;
        return Objects.equals(this.id, casted.id) && Objects.equals(this.type, casted.type) && Objects.equals(this.isReplyComment, casted.isReplyComment) && Objects.equals(this.message, casted.message) && Objects.equals(this.createdBy, casted.createdBy) && Objects.equals(this.createdAt, casted.createdAt) && Objects.equals(this.modifiedAt, casted.modifiedAt) && Objects.equals(this.item, casted.item);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.type, this.isReplyComment, this.message, this.createdBy, this.createdAt, this.modifiedAt, this.item);
    }

    @Override
    public String toString() {
        return "Comment{id='" + this.id + '\'' + ", type='" + this.type + '\'' + ", isReplyComment='" + this.isReplyComment + '\'' + ", message='" + this.message + '\'' + ", createdBy='" + this.createdBy + '\'' + ", createdAt='" + this.createdAt + '\'' + ", modifiedAt='" + this.modifiedAt + '\'' + ", item='" + this.item + '\'' + "}";
    }

    public static class Builder
    extends CommentBase.Builder {
        protected Boolean isReplyComment;
        protected String message;
        protected UserMini createdBy;
        protected OffsetDateTime createdAt;
        protected OffsetDateTime modifiedAt;
        protected CommentItemField item;

        public Builder isReplyComment(Boolean isReplyComment) {
            this.isReplyComment = isReplyComment;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder createdBy(UserMini createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder item(CommentItemField item) {
            this.item = item;
            return this;
        }

        @Override
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public Builder type(CommentBaseTypeField type) {
            this.type = new EnumWrapper<CommentBaseTypeField>(type);
            return this;
        }

        @Override
        public Builder type(EnumWrapper<CommentBaseTypeField> type) {
            this.type = type;
            return this;
        }

        @Override
        public Comment build() {
            return new Comment(this);
        }
    }
}

