/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.search;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.search.SearchByMetadataQueryHeaders;
import com.box.sdkgen.managers.search.SearchForContentHeaders;
import com.box.sdkgen.managers.search.SearchForContentQueryParams;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.metadataquery.MetadataQuery;
import com.box.sdkgen.schemas.metadataqueryresults.MetadataQueryResults;
import com.box.sdkgen.schemas.searchresultsresponse.SearchResultsResponse;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class SearchManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public SearchManager() {
        this.networkSession = new NetworkSession();
    }

    protected SearchManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public MetadataQueryResults searchByMetadataQuery(MetadataQuery requestBody) {
        return this.searchByMetadataQuery(requestBody, new SearchByMetadataQueryHeaders());
    }

    public MetadataQueryResults searchByMetadataQuery(MetadataQuery requestBody, SearchByMetadataQueryHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/metadata_queries/execute_read"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), MetadataQueryResults.class);
    }

    public SearchResultsResponse searchForContent() {
        return this.searchForContent(new SearchForContentQueryParams(), new SearchForContentHeaders());
    }

    public SearchResultsResponse searchForContent(SearchForContentQueryParams queryParams) {
        return this.searchForContent(queryParams, new SearchForContentHeaders());
    }

    public SearchResultsResponse searchForContent(SearchForContentHeaders headers) {
        return this.searchForContent(new SearchForContentQueryParams(), headers);
    }

    public SearchResultsResponse searchForContent(SearchForContentQueryParams queryParams, SearchForContentHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("query", UtilsManager.convertToString(queryParams.getQuery())), UtilsManager.entryOf("scope", UtilsManager.convertToString(queryParams.getScope())), UtilsManager.entryOf("file_extensions", UtilsManager.convertToString(queryParams.getFileExtensions())), UtilsManager.entryOf("created_at_range", UtilsManager.convertToString(queryParams.getCreatedAtRange())), UtilsManager.entryOf("updated_at_range", UtilsManager.convertToString(queryParams.getUpdatedAtRange())), UtilsManager.entryOf("size_range", UtilsManager.convertToString(queryParams.getSizeRange())), UtilsManager.entryOf("owner_user_ids", UtilsManager.convertToString(queryParams.getOwnerUserIds())), UtilsManager.entryOf("recent_updater_user_ids", UtilsManager.convertToString(queryParams.getRecentUpdaterUserIds())), UtilsManager.entryOf("ancestor_folder_ids", UtilsManager.convertToString(queryParams.getAncestorFolderIds())), UtilsManager.entryOf("content_types", UtilsManager.convertToString(queryParams.getContentTypes())), UtilsManager.entryOf("type", UtilsManager.convertToString(queryParams.getType())), UtilsManager.entryOf("trash_content", UtilsManager.convertToString(queryParams.getTrashContent())), UtilsManager.entryOf("mdfilters", UtilsManager.convertToString(queryParams.getMdfilters())), UtilsManager.entryOf("sort", UtilsManager.convertToString(queryParams.getSort())), UtilsManager.entryOf("direction", UtilsManager.convertToString(queryParams.getDirection())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit())), UtilsManager.entryOf("include_recent_shared_links", UtilsManager.convertToString(queryParams.getIncludeRecentSharedLinks())), UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields())), UtilsManager.entryOf("offset", UtilsManager.convertToString(queryParams.getOffset())), UtilsManager.entryOf("deleted_user_ids", UtilsManager.convertToString(queryParams.getDeletedUserIds())), UtilsManager.entryOf("deleted_at_range", UtilsManager.convertToString(queryParams.getDeletedAtRange()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/search"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), SearchResultsResponse.class);
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public SearchManager build() {
            return new SearchManager(this);
        }
    }
}

