/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.listcollaborations;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.listcollaborations.GetCollaborationsHeaders;
import com.box.sdkgen.managers.listcollaborations.GetCollaborationsQueryParams;
import com.box.sdkgen.managers.listcollaborations.GetFileCollaborationsHeaders;
import com.box.sdkgen.managers.listcollaborations.GetFileCollaborationsQueryParams;
import com.box.sdkgen.managers.listcollaborations.GetFolderCollaborationsHeaders;
import com.box.sdkgen.managers.listcollaborations.GetFolderCollaborationsQueryParams;
import com.box.sdkgen.managers.listcollaborations.GetGroupCollaborationsHeaders;
import com.box.sdkgen.managers.listcollaborations.GetGroupCollaborationsQueryParams;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.collaborations.Collaborations;
import com.box.sdkgen.schemas.collaborationsoffsetpaginated.CollaborationsOffsetPaginated;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class ListCollaborationsManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public ListCollaborationsManager() {
        this.networkSession = new NetworkSession();
    }

    protected ListCollaborationsManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public Collaborations getFileCollaborations(String fileId) {
        return this.getFileCollaborations(fileId, new GetFileCollaborationsQueryParams(), new GetFileCollaborationsHeaders());
    }

    public Collaborations getFileCollaborations(String fileId, GetFileCollaborationsQueryParams queryParams) {
        return this.getFileCollaborations(fileId, queryParams, new GetFileCollaborationsHeaders());
    }

    public Collaborations getFileCollaborations(String fileId, GetFileCollaborationsHeaders headers) {
        return this.getFileCollaborations(fileId, new GetFileCollaborationsQueryParams(), headers);
    }

    public Collaborations getFileCollaborations(String fileId, GetFileCollaborationsQueryParams queryParams, GetFileCollaborationsHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit())), UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/files/", UtilsManager.convertToString(fileId), "/collaborations"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), Collaborations.class);
    }

    public Collaborations getFolderCollaborations(String folderId) {
        return this.getFolderCollaborations(folderId, new GetFolderCollaborationsQueryParams(), new GetFolderCollaborationsHeaders());
    }

    public Collaborations getFolderCollaborations(String folderId, GetFolderCollaborationsQueryParams queryParams) {
        return this.getFolderCollaborations(folderId, queryParams, new GetFolderCollaborationsHeaders());
    }

    public Collaborations getFolderCollaborations(String folderId, GetFolderCollaborationsHeaders headers) {
        return this.getFolderCollaborations(folderId, new GetFolderCollaborationsQueryParams(), headers);
    }

    public Collaborations getFolderCollaborations(String folderId, GetFolderCollaborationsQueryParams queryParams, GetFolderCollaborationsHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit())), UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/folders/", UtilsManager.convertToString(folderId), "/collaborations"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), Collaborations.class);
    }

    public CollaborationsOffsetPaginated getCollaborations(GetCollaborationsQueryParams queryParams) {
        return this.getCollaborations(queryParams, new GetCollaborationsHeaders());
    }

    public CollaborationsOffsetPaginated getCollaborations(GetCollaborationsQueryParams queryParams, GetCollaborationsHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("status", UtilsManager.convertToString(queryParams.getStatus())), UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields())), UtilsManager.entryOf("offset", UtilsManager.convertToString(queryParams.getOffset())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/collaborations"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), CollaborationsOffsetPaginated.class);
    }

    public CollaborationsOffsetPaginated getGroupCollaborations(String groupId) {
        return this.getGroupCollaborations(groupId, new GetGroupCollaborationsQueryParams(), new GetGroupCollaborationsHeaders());
    }

    public CollaborationsOffsetPaginated getGroupCollaborations(String groupId, GetGroupCollaborationsQueryParams queryParams) {
        return this.getGroupCollaborations(groupId, queryParams, new GetGroupCollaborationsHeaders());
    }

    public CollaborationsOffsetPaginated getGroupCollaborations(String groupId, GetGroupCollaborationsHeaders headers) {
        return this.getGroupCollaborations(groupId, new GetGroupCollaborationsQueryParams(), headers);
    }

    public CollaborationsOffsetPaginated getGroupCollaborations(String groupId, GetGroupCollaborationsQueryParams queryParams, GetGroupCollaborationsHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit())), UtilsManager.entryOf("offset", UtilsManager.convertToString(queryParams.getOffset()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/groups/", UtilsManager.convertToString(groupId), "/collaborations"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), CollaborationsOffsetPaginated.class);
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public ListCollaborationsManager build() {
            return new ListCollaborationsManager(this);
        }
    }
}

