/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.events;

import com.box.sdkgen.box.eventstream.EventStream;
import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.events.GetEventStreamHeaders;
import com.box.sdkgen.managers.events.GetEventStreamQueryParams;
import com.box.sdkgen.managers.events.GetEventsHeaders;
import com.box.sdkgen.managers.events.GetEventsQueryParams;
import com.box.sdkgen.managers.events.GetEventsWithLongPollingHeaders;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.events.Events;
import com.box.sdkgen.schemas.realtimeservers.RealtimeServers;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class EventsManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public EventsManager() {
        this.networkSession = new NetworkSession();
    }

    protected EventsManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public RealtimeServers getEventsWithLongPolling() {
        return this.getEventsWithLongPolling(new GetEventsWithLongPollingHeaders());
    }

    public RealtimeServers getEventsWithLongPolling(GetEventsWithLongPollingHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/events"), "OPTIONS").headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), RealtimeServers.class);
    }

    public Events getEvents() {
        return this.getEvents(new GetEventsQueryParams(), new GetEventsHeaders());
    }

    public Events getEvents(GetEventsQueryParams queryParams) {
        return this.getEvents(queryParams, new GetEventsHeaders());
    }

    public Events getEvents(GetEventsHeaders headers) {
        return this.getEvents(new GetEventsQueryParams(), headers);
    }

    public Events getEvents(GetEventsQueryParams queryParams, GetEventsHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("stream_type", UtilsManager.convertToString(queryParams.getStreamType())), UtilsManager.entryOf("stream_position", UtilsManager.convertToString(queryParams.getStreamPosition())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit())), UtilsManager.entryOf("event_type", UtilsManager.convertToString(queryParams.getEventType())), UtilsManager.entryOf("created_after", UtilsManager.convertToString(queryParams.getCreatedAfter())), UtilsManager.entryOf("created_before", UtilsManager.convertToString(queryParams.getCreatedBefore()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/events"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), Events.class);
    }

    public EventStream getEventStream() {
        return this.getEventStream(new GetEventStreamQueryParams(), new GetEventStreamHeaders());
    }

    public EventStream getEventStream(GetEventStreamQueryParams queryParams) {
        return this.getEventStream(queryParams, new GetEventStreamHeaders());
    }

    public EventStream getEventStream(GetEventStreamHeaders headers) {
        return this.getEventStream(new GetEventStreamQueryParams(), headers);
    }

    public EventStream getEventStream(GetEventStreamQueryParams queryParams, GetEventStreamHeaders headers) {
        return new EventStream.Builder(this, queryParams).headersInput(headers).build();
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public EventsManager build() {
            return new EventsManager(this);
        }
    }
}

